/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.containers;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.inventory.container.ContainerCraftingFurnace;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.WindowConstants;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.modules.building.WindowSelectRequest;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.minecolonies.core.util.DomumOrnamentumUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowFurnaceCrafting
extends AbstractContainerScreen<ContainerCraftingFurnace> {
    private static final ResourceLocation CRAFTING_FURNACE = new ResourceLocation("minecolonies", "textures/gui/furnace.png");
    private static final int BUTTON_X_OFFSET = 1;
    private static final int BUTTON_Y_POS = 170;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int REQUEST_X_OFFSET = 90 - WindowConstants.CRAFTING_SWITCH_SIZE.width / 2;
    private static final int REQUEST_Y_OFFSET = 70 - WindowConstants.CRAFTING_SWITCH_SIZE.height;
    private final ContainerCraftingFurnace container;
    private final AbstractBuildingView building;
    private final CraftingModuleView module;
    private final Map<IRequest<?>, List<ItemStack>> requestables = new HashMap();

    public WindowFurnaceCrafting(ContainerCraftingFurnace container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.container = container;
        this.building = (AbstractBuildingView)IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)playerInventory.f_35978_.f_19853_.m_46472_(), container.getPos());
        this.module = (CraftingModuleView)this.building.getModuleView(container.getModuleId());
    }

    @NotNull
    public AbstractBuildingView getBuildingView() {
        return this.building;
    }

    protected void m_7856_() {
        super.m_7856_();
        MutableComponent buttonDisplay = Component.m_237115_((String)(this.module.canLearn((CraftingType)ModCraftingTypes.SMELTING.get()) ? "gui.done" : "com.minecolonies.coremod.gui.recipe.full"));
        Button doneButton = new Button.Builder((Component)buttonDisplay, (Button.OnPress)new OnButtonPress()).m_252794_(this.f_97735_ + 1, this.f_97736_ + 170).m_253046_(150, 20).m_253136_();
        this.m_142416_((GuiEventListener)doneButton);
        if (!this.module.canLearn((CraftingType)ModCraftingTypes.SMELTING.get())) {
            doneButton.f_93623_ = false;
        }
        ImageButton requestsButton = new ImageButton(this.f_97735_ + REQUEST_X_OFFSET, this.f_97736_ + REQUEST_Y_OFFSET, WindowConstants.CRAFTING_SWITCH_SIZE.width, WindowConstants.CRAFTING_SWITCH_SIZE.height, WindowConstants.CRAFTING_SWITCH_SIZE.width + 1, 0, WindowConstants.CRAFTING_SWITCH_SIZE.height + 1, WindowConstants.CRAFTING_SWITCH_TEXTURE, btn -> {
            this.requestables.clear();
            new WindowSelectRequest(this.module, this::matchingRequest, this::reopenWithRequest).open();
        });
        requestsButton.f_93624_ = Compatibility.jeiProxy.isLoaded();
        this.m_142416_((GuiEventListener)requestsButton);
    }

    private boolean matchingRequest(@NotNull IRequest<?> request) {
        if (!DomumOrnamentumUtils.getRequestedStack(request).m_41619_()) {
            return false;
        }
        Object obj = request.getRequest();
        if (obj instanceof IConcreteDeliverable) {
            IConcreteDeliverable deliverable = (IConcreteDeliverable)obj;
            this.requestables.put(request, deliverable.getRequestedItems());
            return true;
        }
        return false;
    }

    private void reopenWithRequest(@Nullable IRequest<?> request) {
        this.f_96541_.m_91152_((Screen)this);
        List stacks = this.requestables.getOrDefault(request, new ArrayList());
        if (!stacks.isEmpty()) {
            Compatibility.jeiProxy.showRecipes(stacks);
        }
    }

    protected void m_7286_(@NotNull GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        stack.m_280218_(CRAFTING_FURNACE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(@NotNull GuiGraphics stack, int x, int y, float z) {
        this.m_280273_(stack);
        super.m_88315_(stack, x, y, z);
        this.m_280072_(stack, x, y);
    }

    public class OnButtonPress
    implements Button.OnPress {
        public void m_93750_(@NotNull Button button) {
            if (WindowFurnaceCrafting.this.module.canLearn((CraftingType)ModCraftingTypes.SMELTING.get())) {
                ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
                input.add(new ItemStorage(((Slot)WindowFurnaceCrafting.this.container.f_38839_.get(0)).m_7993_()));
                ItemStack primaryOutput = ((Slot)WindowFurnaceCrafting.this.container.f_38839_.get(1)).m_7993_().m_41777_();
                if (!ItemStackUtils.isEmpty(primaryOutput)) {
                    Network.getNetwork().sendToServer(new AddRemoveRecipeMessage((IBuildingView)WindowFurnaceCrafting.this.building, input, 1, primaryOutput, false, Blocks.f_50094_, WindowFurnaceCrafting.this.module.getProducer().getRuntimeID()));
                }
            }
        }
    }
}

