/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.containers;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.WindowConstants;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.modules.building.WindowSelectRequest;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.SwitchRecipeCraftingTeachingMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.minecolonies.core.util.DomumOrnamentumUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowCrafting
extends AbstractContainerScreen<ContainerCrafting> {
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("minecolonies", "textures/gui/crafting2x2.png");
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES3X3 = new ResourceLocation("minecolonies", "textures/gui/crafting3x3.png");
    private static final int BUTTON_X_OFFSET = 1;
    private static final int BUTTON_Y_POS = 170;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int SWITCH_X_OFFSET = 148;
    private static final int SWITCH_Y_OFFSET = 43 - WindowConstants.CRAFTING_SWITCH_SIZE.height / 2;
    private static final int REQUEST_X_OFFSET = 100 - WindowConstants.CRAFTING_SWITCH_SIZE.width / 2;
    private static final int REQUEST_Y_OFFSET = 70 - WindowConstants.CRAFTING_SWITCH_SIZE.height;
    private static final int GUI_COLOR = 0x404040;
    private static final int X_OFFSET = 97;
    private static final int Y_OFFSET = 8;
    private static final int CRAFTING_GRID_SIZE = 4;
    private static final int MAX_CRAFTING_GRID_SIZE = 9;
    private final AbstractBuildingView building;
    private final boolean completeCrafting;
    private final CraftingModuleView module;
    private ImageButton switchButton;
    private final Map<IRequest<?>, List<ItemStack>> requestables = new HashMap();

    public WindowCrafting(ContainerCrafting container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.building = (AbstractBuildingView)IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)playerInventory.f_35978_.f_19853_.m_46472_(), container.getPos());
        this.module = (CraftingModuleView)this.building.getModuleView(container.getModuleId());
        this.completeCrafting = this.module.canLearn((CraftingType)ModCraftingTypes.LARGE_CRAFTING.get());
    }

    @NotNull
    public AbstractBuildingView getBuildingView() {
        return this.building;
    }

    public boolean isCompleteCrafting() {
        return this.completeCrafting;
    }

    protected void m_7856_() {
        super.m_7856_();
        MutableComponent buttonDisplay = Component.m_237115_((String)(this.module.canLearn((CraftingType)ModCraftingTypes.SMALL_CRAFTING.get()) ? "gui.done" : "com.minecolonies.coremod.gui.recipe.full"));
        Button doneButton = Button.m_253074_((Component)buttonDisplay, this::onDoneClicked).m_252794_(this.f_97735_ + 1, this.f_97736_ + 170).m_253046_(150, 20).m_253136_();
        this.m_142416_((GuiEventListener)doneButton);
        if (!this.module.canLearn((CraftingType)ModCraftingTypes.SMALL_CRAFTING.get())) {
            doneButton.f_93623_ = false;
        }
        this.switchButton = new ImageButton(this.f_97735_ + 148, this.f_97736_ + SWITCH_Y_OFFSET, WindowConstants.CRAFTING_SWITCH_SIZE.width, WindowConstants.CRAFTING_SWITCH_SIZE.height, 0, 0, WindowConstants.CRAFTING_SWITCH_SIZE.height + 1, WindowConstants.CRAFTING_SWITCH_TEXTURE, btn -> Network.getNetwork().sendToServer(new SwitchRecipeCraftingTeachingMessage()));
        this.switchButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.switchButton);
        ImageButton requestsButton = new ImageButton(this.f_97735_ + REQUEST_X_OFFSET, this.f_97736_ + REQUEST_Y_OFFSET, WindowConstants.CRAFTING_SWITCH_SIZE.width, WindowConstants.CRAFTING_SWITCH_SIZE.height, WindowConstants.CRAFTING_SWITCH_SIZE.width + 1, 0, WindowConstants.CRAFTING_SWITCH_SIZE.height + 1, WindowConstants.CRAFTING_SWITCH_TEXTURE, btn -> {
            this.requestables.clear();
            new WindowSelectRequest(this.module, this::matchingRequest, this::reopenWithRequest).open();
        });
        requestsButton.f_93624_ = Compatibility.jeiProxy.isLoaded();
        this.m_142416_((GuiEventListener)requestsButton);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.switchButton.f_93624_ = ((ContainerCrafting)this.f_97732_).canSwitchRecipes();
    }

    private boolean matchingRequest(@NotNull IRequest<?> request) {
        if (!DomumOrnamentumUtils.getRequestedStack(request).m_41619_()) {
            return false;
        }
        Object obj = request.getRequest();
        if (obj instanceof IConcreteDeliverable) {
            IConcreteDeliverable deliverable = (IConcreteDeliverable)obj;
            this.requestables.put(request, deliverable.getRequestedItems());
            return true;
        }
        return false;
    }

    private void reopenWithRequest(@Nullable IRequest<?> request) {
        this.f_96541_.m_91152_((Screen)this);
        List stacks = this.requestables.getOrDefault(request, new ArrayList());
        if (!stacks.isEmpty()) {
            Compatibility.jeiProxy.showRecipes(stacks);
        }
    }

    private void onDoneClicked(Button button) {
        if (this.module.canLearn((CraftingType)ModCraftingTypes.SMALL_CRAFTING.get())) {
            LinkedList<ItemStorage> input = new LinkedList<ItemStorage>();
            for (int i = 0; i < (this.completeCrafting ? 9 : 4); ++i) {
                ItemStack stack = ((ContainerCrafting)this.f_97732_).craftMatrix.m_8020_(i);
                ItemStack copy = stack.m_41777_();
                ItemStackUtils.setSize(copy, 1);
                input.add(new ItemStorage(copy));
            }
            ItemStack primaryOutput = ((ContainerCrafting)this.f_97732_).craftResult.m_8020_(0).m_41777_();
            List<ItemStack> secondaryOutputs = ((ContainerCrafting)this.f_97732_).getRemainingItems();
            if (!ItemStackUtils.isEmpty(primaryOutput)) {
                Network.getNetwork().sendToServer(new AddRemoveRecipeMessage((IBuildingView)this.building, input, this.completeCrafting ? 3 : 2, primaryOutput, secondaryOutputs, false, this.module.getProducer().getRuntimeID()));
            }
        }
    }

    protected void m_280003_(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        stack.m_280056_(this.f_96547_, Component.m_237115_((String)"container.crafting").getString(), 97, 8, 0x404040, false);
    }

    protected void m_7286_(@NotNull GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation texture = this.completeCrafting ? CRAFTING_TABLE_GUI_TEXTURES3X3 : CRAFTING_TABLE_GUI_TEXTURES;
        stack.m_280218_(texture, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(@NotNull GuiGraphics stack, int x, int y, float z) {
        this.m_280273_(stack);
        super.m_88315_(stack, x, y, z);
        this.m_280072_(stack, x, y);
    }
}

