/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IStackBasedTask;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.modules.RequestTreeWindowModule;
import com.minecolonies.core.colony.requestsystem.requests.AbstractRequest;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowRequestDetail
extends AbstractWindowSkeleton
implements ButtonHandler {
    public static final ResourceLocation WINDOW_ID = new ResourceLocation("minecolonies", "gui/windowrequestdetail.xml");
    private static final String REQUESTER = "requester";
    private static final String LIST_ELEMENT_ID_REQUEST_STACK = "requestStack";
    private static final int LIFE_COUNT_DIVIDER = 30;
    private static final String LIST_ELEMENT_ID_REQUEST_LOCATION = "targetLocation";
    private static final String RESOLVER = "resolver";
    private static final String DELIVERY_IMAGE = "deliveryImage";
    private final IRequest<?> request;
    private final int colonyId;
    private final RequestTreeWindowModule requestTreeWindowModule;
    private int lifeCount = 0;

    public WindowRequestDetail(@Nullable BOWindow parent, IRequest<?> request, int colonyId, RequestTreeWindowModule requestTreeWindowModule) {
        super(parent, WINDOW_ID);
        this.request = request;
        this.colonyId = colonyId;
        this.requestTreeWindowModule = requestTreeWindowModule;
    }

    @Override
    public void onOpened() {
        if (this.request instanceof IStackBasedTask) {
            ItemIcon icon = (ItemIcon)this.findPaneOfTypeByID("detailIcon", ItemIcon.class);
            ItemStack copyStack = ((IStackBasedTask)((Object)this.request)).getTaskStack().m_41777_();
            copyStack.m_41764_(((IStackBasedTask)((Object)this.request)).getDisplayCount());
            icon.setItem(copyStack);
            icon.setVisible(true);
            ((Text)this.findPaneOfTypeByID("shortDetail", Text.class)).setText(((IStackBasedTask)((Object)this.request)).getDisplayPrefix().m_130940_(ChatFormatting.BLACK));
        } else {
            ((ItemIcon)this.findPaneOfTypeByID("detailIcon", ItemIcon.class)).setVisible(false);
            ((Text)this.findPaneOfTypeByID("shortDetail", Text.class)).setText(Component.m_237113_((String)this.request.getLongDisplayString().getString().replace("\u00a7f", "")).m_130940_(ChatFormatting.BLACK));
        }
        Image logo = (Image)this.findPaneOfTypeByID(DELIVERY_IMAGE, Image.class);
        ItemIcon exampleStackDisplay = (ItemIcon)this.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_STACK, ItemIcon.class);
        List<ItemStack> displayStacks = this.request.getDisplayStacks();
        IColonyView colony = IColonyManager.getInstance().getColonyView(this.colonyId, (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
        if (!displayStacks.isEmpty()) {
            exampleStackDisplay.setItem(displayStacks.get(this.lifeCount / 30 % displayStacks.size()));
        } else if (!this.request.getDisplayIcon().equals((Object)AbstractRequest.MISSING)) {
            logo.setVisible(true);
            logo.setImage(this.request.getDisplayIcon(), false);
            PaneBuilders.tooltipBuilder().hoverPane((Pane)logo).build().setText(this.request.getResolverToolTip(colony));
        }
        ((Text)this.findPaneOfTypeByID(REQUESTER, Text.class)).setText(this.request.getRequester().getRequesterDisplayName(colony.getRequestManager(), this.request));
        ((Text)this.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_LOCATION, Text.class)).setText(Component.m_237113_((String)this.request.getRequester().getLocation().toString()));
        try {
            IRequestResolver<?> resolver = colony.getRequestManager().getResolverForRequest((IToken<?>)this.request.getId());
            if (resolver == null) {
                Log.getLogger().warn("---IRequestResolver Null in WindowRequestDetail---");
                return;
            }
            ((Text)this.findPaneOfTypeByID(RESOLVER, Text.class)).setText(Component.m_237113_((String)("Resolver: " + resolver.getRequesterDisplayName(colony.getRequestManager(), this.request).getString())));
        }
        catch (IllegalArgumentException e) {
            Log.getLogger().warn("---IRequestResolver Null in WindowRequestDetail---", (Throwable)e);
        }
        ((ButtonImage)this.findPaneOfTypeByID("fulfill", ButtonImage.class)).setEnabled(this.requestTreeWindowModule.isFulfillable(this.request));
        ((ButtonImage)this.findPaneOfTypeByID("cancel", ButtonImage.class)).setEnabled(this.requestTreeWindowModule.isCancellable(this.request));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!Screen.m_96638_()) {
            ++this.lifeCount;
        }
        ItemIcon exampleStackDisplay = (ItemIcon)this.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_STACK, ItemIcon.class);
        List<ItemStack> displayStacks = this.request.getDisplayStacks();
        if (!displayStacks.isEmpty()) {
            exampleStackDisplay.setItem(displayStacks.get(this.lifeCount / 30 % displayStacks.size()));
        } else {
            exampleStackDisplay.setItem(ItemStackUtils.EMPTY);
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals("fulfill")) {
            RequestTreeWindowModule requestTreeWindowModule = this.requestTreeWindowModule;
            if (requestTreeWindowModule instanceof RequestTreeWindowModule.IRequestTreeSupportsFulfill) {
                RequestTreeWindowModule.IRequestTreeSupportsFulfill requestTreeSupportsFulfill = (RequestTreeWindowModule.IRequestTreeSupportsFulfill)((Object)requestTreeWindowModule);
                requestTreeSupportsFulfill.onFulfill(this.request);
            }
            this.window.close();
        } else if (button.getID().equals("cancel")) {
            this.requestTreeWindowModule.cancel(this.request);
            this.window.close();
        }
    }
}

