/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.controls.Button;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.MinimumStack;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.modules.RequestTreeWindowModule;
import com.minecolonies.core.network.messages.server.ItemSettingMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;

public class WindowClipBoard
extends AbstractWindowSkeleton {
    private final ClipboardRequestTreeWindowModule requestTreeWindowModule;
    private boolean showImportant;

    public WindowClipBoard(IColonyView colony, boolean showImportant) {
        super(new ResourceLocation("minecolonies", "gui/windowclipboard.xml"));
        this.showImportant = showImportant;
        this.requestTreeWindowModule = this.registerLayoutModule(ClipboardRequestTreeWindowModule::new, new ClipboardRequestTreeWindowModule.Options(colony, () -> this.showImportant), 16, 44);
        this.registerButton("important", this::toggleImportant);
        this.paintButtonState();
    }

    private void toggleImportant() {
        this.showImportant = !this.showImportant;
        this.paintButtonState();
        ItemSettingMessage hideSetting = new ItemSettingMessage();
        hideSetting.setSetting("hideunimportant", this.showImportant ? 1 : 0);
        Network.getNetwork().sendToServer(hideSetting);
        this.requestTreeWindowModule.refreshOpenRequests();
    }

    private void paintButtonState() {
        Button importantToggle = (Button)this.findPaneOfTypeByID("important", Button.class);
        if (this.showImportant) {
            importantToggle.setColors(Color.getByName((String)"green", (int)0));
        } else {
            importantToggle.setColors(Color.getByName((String)"red", (int)0));
        }
    }

    private static class ClipboardRequestTreeWindowModule
    extends RequestTreeWindowModule {
        private final Supplier<Boolean> showImportant;

        public ClipboardRequestTreeWindowModule(AbstractWindowSkeleton parent, Options options) {
            super(parent, options.colony);
            this.showImportant = options.showImportant;
        }

        @Override
        protected Collection<IRequest<?>> getOpenRequests() {
            boolean showImportant = this.showImportant.get();
            IRequestManager requestManager = this.colony.getRequestManager();
            ArrayList<IRequest> requests = new ArrayList<IRequest>();
            ArrayList asyncRequest = new ArrayList();
            for (ICitizenDataView view : this.colony.getCitizens().values()) {
                if (view.getJobView() == null) continue;
                asyncRequest.addAll(view.getJobView().getAsyncRequests());
            }
            try {
                IPlayerRequestResolver resolver = requestManager.getPlayerResolver();
                IRetryingRequestResolver retryingRequestResolver = requestManager.getRetryingRequestResolver();
                HashSet requestTokens = new HashSet();
                requestTokens.addAll((Collection<IToken<?>>)resolver.getAllAssignedRequests());
                requestTokens.addAll((Collection<IToken<?>>)retryingRequestResolver.getAllAssignedRequests());
                for (IToken iToken : requestTokens) {
                    IRequest<?> request2 = requestManager.getRequestForToken(iToken);
                    while (request2 != null && request2.hasParent()) {
                        request2 = requestManager.getRequestForToken((IToken<?>)request2.getParent());
                    }
                    if (request2 == null || !showImportant && request2.getType().equals((Object)TypeToken.of(MinimumStack.class)) || requests.contains(request2)) continue;
                    requests.add(request2);
                }
                if (!showImportant) {
                    requests.removeIf(req -> asyncRequest.contains(req.getId()));
                }
                BlockPos playerPos = Minecraft.m_91087_().f_91074_.m_20183_();
                requests.sort(Comparator.comparing(request -> request.getRequester().getLocation().getInDimensionLocation().m_123331_(new Vec3i(playerPos.m_123341_(), playerPos.m_123342_(), playerPos.m_123343_()))).thenComparingInt(request -> request.getId().hashCode()));
            }
            catch (Exception e) {
                Log.getLogger().warn("Exception trying to retrieve requests:", (Throwable)e);
                requestManager.reset();
                return ImmutableList.of();
            }
            return ImmutableList.copyOf(requests);
        }

        private record Options(IColonyView colony, Supplier<Boolean> showImportant) {
        }
    }
}

