/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.SwitchView;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.modules.IModuleContainer;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.modules.IWindowModule;
import com.minecolonies.core.client.gui.modules.IWindowWithLayoutModule;
import com.minecolonies.core.network.messages.server.ClickGuiButtonTriggerMessage;
import com.minecolonies.core.network.messages.server.OpenGuiWindowTriggerMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWindowSkeleton
extends BOWindow
implements ButtonHandler,
IModuleContainer<IWindowModule> {
    @NotNull
    private final HashMap<String, Consumer<Button>> buttons;
    private final List<IWindowModule> modules = new ArrayList<IWindowModule>();
    protected final Text pageNum;
    protected final Button buttonPrevPage;
    protected final Button buttonNextPage;
    protected SwitchView switchView;
    @Nullable
    private final BOWindow parent;

    public AbstractWindowSkeleton(ResourceLocation resource) {
        this(null, resource);
    }

    public AbstractWindowSkeleton(@Nullable BOWindow parent, ResourceLocation resource) {
        super(resource);
        this.parent = parent;
        this.buttons = new HashMap();
        this.switchView = (SwitchView)this.findPaneOfTypeByID("pages", SwitchView.class);
        if (this.switchView != null) {
            this.buttonNextPage = (Button)this.findPaneOfTypeByID("nextPage", Button.class);
            this.buttonPrevPage = (Button)this.findPaneOfTypeByID("prevPage", Button.class);
            PaneBuilders.singleLineTooltip((MutableComponent)Component.m_237115_((String)"com.minecolonies.core.gui.nextpage"), (Pane)this.buttonNextPage);
            PaneBuilders.singleLineTooltip((MutableComponent)Component.m_237115_((String)"com.minecolonies.core.gui.prevpage"), (Pane)this.buttonPrevPage);
            this.pageNum = (Text)this.findPaneOfTypeByID("pageNum", Text.class);
            this.registerButton("nextPage", () -> this.setPage(true, 1));
            this.registerButton("prevPage", () -> this.setPage(true, -1));
        } else {
            this.buttonNextPage = null;
            this.buttonPrevPage = null;
            this.pageNum = null;
        }
        Network.getNetwork().sendToServer(new OpenGuiWindowTriggerMessage(this.xmlResourceLocation));
    }

    @Override
    @NotNull
    public List<IWindowModule> getModules() {
        return this.modules;
    }

    @Override
    @NotNull
    public Class<IWindowModule> getClassType() {
        return IWindowModule.class;
    }

    public final void registerButton(String id, Runnable action) {
        this.registerButton(id, (Button button) -> action.run());
    }

    public final void registerButton(String id, Consumer<Button> action) {
        this.buttons.put(id, action);
    }

    public final <T extends IWindowModule, A> T registerModule(BiFunction<AbstractWindowSkeleton, A, T> moduleBuilder, A argument) {
        IWindowModule module = (IWindowModule)moduleBuilder.apply(this, argument);
        this.modules.add(module);
        return (T)module;
    }

    public final <T extends IWindowWithLayoutModule, A> T registerLayoutModule(BiFunction<AbstractWindowSkeleton, A, T> moduleBuilder, A argument, int xPos, int yPos) {
        IWindowWithLayoutModule module = (IWindowWithLayoutModule)moduleBuilder.apply(this, argument);
        Pane rootPane = Loader.createFromXMLFile2((ResourceLocation)module.getLayout(), (View)this);
        rootPane.setPosition(xPos, yPos);
        module.onLayoutMounted(rootPane);
        this.modules.add(module);
        return (T)module;
    }

    public void onOpened() {
        super.onOpened();
        this.modules.forEach(IWindowModule::onOpened);
    }

    public void onUpdate() {
        super.onUpdate();
        this.modules.forEach(IWindowModule::onUpdate);
    }

    public void onClosed() {
        super.onClosed();
        this.modules.forEach(IWindowModule::onClosed);
    }

    public void onButtonClicked(@NotNull Button button) {
        if (this.buttons.containsKey(button.getID())) {
            this.buttons.get(button.getID()).accept(button);
            Network.getNetwork().sendToServer(new ClickGuiButtonTriggerMessage(button.getID(), this.xmlResourceLocation));
        }
        this.modules.forEach(module -> module.onButtonClicked(button));
    }

    public final void doNothing(Button ignored) {
    }

    public void setPage(boolean relative, int page) {
        if (this.switchView == null) {
            return;
        }
        int switchPagesSize = this.switchView.getChildrenSize();
        if (switchPagesSize <= 1) {
            this.buttonPrevPage.off();
            this.buttonNextPage.off();
            this.pageNum.off();
            return;
        }
        int curPage = this.switchView.setView(relative, page) + 1;
        this.buttonNextPage.on();
        this.buttonPrevPage.on();
        if (curPage == 1 && !this.switchView.isEndlessScrollingEnabled()) {
            this.buttonPrevPage.off();
        }
        if (curPage == switchPagesSize && !this.switchView.isEndlessScrollingEnabled()) {
            this.buttonNextPage.off();
        }
        if (this.pageNum != null) {
            this.pageNum.setText(Component.m_237113_((String)(curPage + "/" + switchPagesSize)));
        }
    }

    public void close() {
        super.close();
        if (this.parent != null) {
            this.parent.open();
        }
    }
}

