/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractBuildingWindow;
import com.minecolonies.core.client.gui.WindowBuildBuilding;
import com.minecolonies.core.client.gui.WindowHutAllInventory;
import com.minecolonies.core.client.gui.WindowHutNameEntry;
import com.minecolonies.core.client.gui.WindowInfo;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.core.network.messages.server.colony.building.BuildRequestMessage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractBuildingMainWindow<B extends IBuildingView>
extends AbstractBuildingWindow<B> {
    private final Text title;
    private final Button buttonBuild;

    public AbstractBuildingMainWindow(B buildingView, ResourceLocation resource) {
        super(buildingView, resource);
        this.registerButton("build", this::buildClicked);
        this.registerButton("info", this::infoClicked);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("editName", this::editName);
        this.registerButton("allinventory", this::allInventoryClicked);
        this.title = (Text)this.findPaneOfTypeByID("name", Text.class);
        this.buttonBuild = (Button)this.findPaneOfTypeByID("build", Button.class);
        Button buttonInfo = (Button)this.findPaneOfTypeByID("info", Button.class);
        if (buttonInfo != null) {
            buttonInfo.setVisible(I18n.m_118936_((String)("com.minecolonies.coremod.info." + buildingView.getBuildingType().getTranslationKey().replace("com.minecolonies.building.", "") + ".0")));
        }
    }

    private void buildClicked() {
        String buttonLabel;
        String string = buttonLabel = this.buttonBuild.getText().m_214077_() instanceof TranslatableContents ? ((TranslatableContents)this.buttonBuild.getText().m_214077_()).m_237508_() : this.buttonBuild.getTextAsString();
        if (buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.cancelbuild") || buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.cancelupgrade")) {
            Network.getNetwork().sendToServer(new BuildRequestMessage(this.buildingView, BuildRequestMessage.Mode.BUILD, BlockPos.f_121853_));
        } else if (buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.cancelrepair")) {
            Network.getNetwork().sendToServer(new BuildRequestMessage(this.buildingView, BuildRequestMessage.Mode.REPAIR, BlockPos.f_121853_));
        } else if (buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.canceldeconstruction")) {
            Network.getNetwork().sendToServer(new BuildRequestMessage(this.buildingView, BuildRequestMessage.Mode.REMOVE, BlockPos.f_121853_));
        } else {
            new WindowBuildBuilding(this.buildingView.getColony(), this.buildingView).open();
        }
    }

    private void infoClicked() {
        new WindowInfo(this.buildingView).open();
    }

    private void inventoryClicked() {
        Network.getNetwork().sendToServer(new OpenInventoryMessage(this.buildingView));
    }

    private void editName() {
        new WindowHutNameEntry(this.buildingView).open();
    }

    private void allInventoryClicked() {
        new WindowHutAllInventory(this.buildingView, this).open();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateButtonBuild(this.buildingView);
    }

    private void updateButtonBuild(IBuildingView buildingView) {
        if (this.buttonBuild == null) {
            return;
        }
        if (buildingView.isBuilding()) {
            if (buildingView.getBuildingLevel() == 0) {
                this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.cancelbuild"));
            } else {
                this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.cancelupgrade"));
            }
        } else if (buildingView.isRepairing()) {
            this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.cancelrepair"));
        } else if (buildingView.isDeconstructing()) {
            this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.canceldeconstruction"));
        } else {
            this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.buildrepair"));
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.setPage(false, 0);
        if (this.title != null) {
            MutableComponent component = Component.m_237115_((String)this.buildingView.getBuildingDisplayName());
            MutableComponent componentWithLevel = component.m_130946_(" ").m_130946_(String.valueOf(this.buildingView.getBuildingLevel()));
            this.title.setText(componentWithLevel);
        }
        this.updateButtonBuild(this.buildingView);
    }
}

