/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.BuildingStatisticsModule;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;

public class StatsUtil {
    public static void trackStatFromFurnace(IBuilding building, String statName, FurnaceBlockEntity furnace, int slot) {
        ItemStack item;
        if (furnace != null && (item = furnace.m_8020_(slot)) != null) {
            StatsUtil.trackStatByName(building, statName, item.m_41786_(), item.m_41613_());
        }
    }

    public static void trackStatByStackMap(IBuilding building, String statName, Object2IntMap<ItemStack> itemMap) {
        for (Object2IntMap.Entry entry : itemMap.object2IntEntrySet()) {
            ItemStack stack = (ItemStack)entry.getKey();
            int count = entry.getIntValue();
            StatsUtil.trackStatByStack(building, statName, stack, count);
        }
    }

    public static void trackStatByStack(IBuilding building, String statIdentifier, ItemStack stack, int count) {
        if (stack == null) {
            Log.getLogger().warn("Attempted to track stat '{}' with null stack: ", (Object)statIdentifier);
            return;
        }
        StatsUtil.trackStatByName(building, statIdentifier, stack.m_41786_(), count);
    }

    public static void trackStatByName(IBuilding building, String statIdentifier, String displayName, int count) {
        if (building == null) {
            Log.getLogger().warn("Attempted to track stat '{}' with null building: ", (Object)statIdentifier);
            return;
        }
        String statKey = statIdentifier + ";" + displayName;
        BuildingStatisticsModule statsModule = (BuildingStatisticsModule)building.getModule(BuildingModules.STATS_MODULE);
        if (statsModule != null) {
            statsModule.incrementBy(statKey, count);
        } else {
            Log.getLogger().error("Attempt to track stats on a building that has no statistics module: {}", (Object)building);
        }
    }

    public static void trackStatByName(IBuilding building, String statIdentifier, Component displayName, int count) {
        if (displayName == null) {
            Log.getLogger().warn("Attempted to track stat '{}' with null displayName as component: ", (Object)statIdentifier);
            return;
        }
        StatsUtil.trackStatByName(building, statIdentifier, displayName.getString(), count);
    }

    public static void trackStat(IBuilding building, String statIdentifier, int count) {
        if (building == null) {
            Log.getLogger().warn("Attempted to track stat '{}' with null building: ", (Object)statIdentifier);
            return;
        }
        BuildingStatisticsModule statsModule = (BuildingStatisticsModule)building.getModule(BuildingModules.STATS_MODULE);
        if (statsModule != null) {
            statsModule.incrementBy(statIdentifier, count);
        }
    }
}

