/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.core.config.AppenderControl;

public final class ReflectionUtils {
    private static Map<TypeToken<?>, Set<TypeToken<?>>> cache = new HashMap();

    private ReflectionUtils() {
    }

    public static <T> Set<TypeToken<?>> getSuperClasses(TypeToken<T> token) {
        Set<TypeToken<?>> cachedSet = cache.get(token);
        if (cachedSet != null) {
            return cachedSet;
        }
        LinkedHashSet directSet = new LinkedHashSet(token.getTypes());
        LinkedHashSet resultingSet = new LinkedHashSet();
        directSet.forEach(t -> {
            resultingSet.add((TypeToken<?>)t);
            resultingSet.add(TypeToken.of((Class)t.getRawType()));
        });
        cache.put(token, resultingSet);
        return resultingSet;
    }

    public static void setFMLLoggingLevelOnConsoleToDebug(AppenderControl control) throws NoSuchFieldException, IllegalAccessException {
        Field levelField = control.getClass().getField("level");
        levelField.setAccessible(true);
        levelField.set(control, Integer.MAX_VALUE);
    }
}

