/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.NotNull;

public final class CraftingUtils {
    private CraftingUtils() {
        throw new IllegalStateException("Tried to initialize: CraftingUtils but this is a Utility class.");
    }

    public static int calculateMaxCraftingCount(@NotNull ItemStack outputStack, @NotNull IRecipeStorage storage) {
        int craftingCount = (int)Math.ceil((double)Math.max(ItemStackUtils.getSize(outputStack), ItemStackUtils.getSize(storage.getPrimaryOutput())) / (double)ItemStackUtils.getSize(storage.getPrimaryOutput()));
        for (ItemStorage ingredientStorage : storage.getCleanedInput()) {
            ItemStack ingredient = ingredientStorage.getItemStack();
            int ingredientInputCount = ItemStackUtils.getSize(ingredient) * craftingCount;
            if (ingredientInputCount <= ingredient.m_41741_()) continue;
            craftingCount = Math.max(ingredient.m_41741_(), ItemStackUtils.getSize(storage.getPrimaryOutput())) / ItemStackUtils.getSize(storage.getPrimaryOutput());
        }
        return craftingCount;
    }

    public static int calculateMaxCraftingCount(int count, @NotNull IRecipeStorage storage) {
        return (int)Math.ceil((double)Math.max(count, ItemStackUtils.getSize(storage.getPrimaryOutput())) / (double)ItemStackUtils.getSize(storage.getPrimaryOutput()));
    }

    public static OptionalPredicate<ItemStack> getProductValidatorBasedOnTags(@NotNull String crafterJobName) {
        return stack -> {
            TagKey<Item> excludedProducts = ModTags.crafterProductExclusions.get(crafterJobName);
            if (excludedProducts != null && stack.m_204117_(excludedProducts)) {
                return Optional.of(false);
            }
            TagKey<Item> allowedProducts = ModTags.crafterProduct.get(crafterJobName);
            if (allowedProducts != null && stack.m_204117_(allowedProducts)) {
                return Optional.of(true);
            }
            return Optional.empty();
        };
    }

    public static OptionalPredicate<ItemStack> getIngredientValidatorBasedOnTags(@NotNull String crafterJobName) {
        return CraftingUtils.getIngredientValidatorBasedOnTags(crafterJobName, false);
    }

    public static OptionalPredicate<ItemStack> getIngredientValidatorBasedOnTags(@NotNull String crafterJobName, boolean includeDoRules) {
        return stack -> {
            TagKey<Item> includedDoIngredients;
            if (includeDoRules && (includedDoIngredients = ModTags.crafterDoIngredient.get(crafterJobName)) != null && stack.m_204117_(includedDoIngredients)) {
                return Optional.of(true);
            }
            TagKey<Item> excludedIngredients = ModTags.crafterIngredientExclusions.get(crafterJobName);
            if (excludedIngredients != null && stack.m_204117_(excludedIngredients)) {
                return Optional.of(false);
            }
            TagKey<Item> allowedIngredients = ModTags.crafterIngredient.get(crafterJobName);
            if (allowedIngredients != null && stack.m_204117_(allowedIngredients)) {
                return Optional.of(true);
            }
            return Optional.empty();
        };
    }

    public static Optional<Boolean> isRecipeCompatibleBasedOnTags(@NotNull IGenericRecipe recipe, @NotNull String crafterJobName) {
        return OptionalPredicate.combine(recipe.matchesOutput(CraftingUtils.getProductValidatorBasedOnTags(crafterJobName)), () -> recipe.matchesInput(CraftingUtils.getIngredientValidatorBasedOnTags(crafterJobName)));
    }

    public static void forEachCreativeTabItems(@NotNull CreativeModeTab.ItemDisplayParameters displayParams, @NotNull BiConsumer<CreativeModeTab, Collection<ItemStack>> consumer) {
        HolderLookup.RegistryLookup registry = (HolderLookup.RegistryLookup)displayParams.f_268485_().m_254861_(Registries.f_279569_).get();
        Map<CreativeModeTab, ResourceKey> tabKeys = registry.m_214062_().distinct().collect(Collectors.toMap(Holder::get, Holder.Reference::m_205785_));
        for (CreativeModeTab tab : CreativeModeTabs.m_257478_()) {
            HashSet stacks;
            if (tab.m_257962_() != CreativeModeTab.Type.CATEGORY) continue;
            if (tab.m_260957_().isEmpty()) {
                stacks = new HashSet();
                try {
                    CraftingUtils.onCreativeModeTabBuildContents(tab, (ResourceKey<CreativeModeTab>)Objects.requireNonNull(tabKeys.get(tab), "unregistered tab"), tab.f_256824_, displayParams, (stack, vis) -> stacks.add(stack));
                }
                catch (Throwable ex) {
                    Log.getLogger().warn("Error populating items for " + tab.m_40786_().getString(), ex);
                }
            } else {
                stacks = tab.m_260957_();
            }
            consumer.accept(tab, stacks);
        }
    }

    private static void onCreativeModeTabBuildContents(CreativeModeTab tab, ResourceKey<CreativeModeTab> tabKey, CreativeModeTab.DisplayItemsGenerator originalGenerator, CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output) {
        MutableHashedLinkedMap entries = new MutableHashedLinkedMap(ItemStackLinkedSet.f_260558_, (key, left, right) -> CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        originalGenerator.m_257865_(params, (stack, vis) -> {
            if (stack.m_41613_() != 1) {
                throw new IllegalArgumentException("The stack count must be 1");
            }
            entries.put((Object)stack, (Object)vis);
        });
        ModLoader.get().postEvent((Event)new BuildCreativeModeTabContentsEvent(tab, tabKey, params, entries));
        for (Map.Entry entry : entries) {
            output.m_246267_((ItemStack)entry.getKey(), (CreativeModeTab.TabVisibility)entry.getValue());
        }
    }
}

