/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.compatibility.dynamictrees.DynamicTreeCompat;
import com.minecolonies.api.compatibility.resourcefulbees.ResourcefulBeesCompat;
import com.minecolonies.api.compatibility.tinkers.SlimeTreeCheck;
import com.minecolonies.api.compatibility.tinkers.TinkersToolHelper;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.registry.ModRecipeSerializer;
import com.minecolonies.api.items.CheckedNbtKey;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.colony.crafting.CustomRecipeManager;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import com.minecolonies.core.generation.ItemNbtCalculator;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibilityManager
implements ICompatibilityManager {
    private static final int MAX_DEPTH = 100;
    private final Map<Block, ItemStorage> leavesToSaplingMap = new HashMap<Block, ItemStorage>();
    private final List<ItemStorage> saplings = new ArrayList<ItemStorage>();
    private final Set<Block> oreBlocks = new HashSet<Block>();
    private final Set<ItemStorage> smeltableOres = new HashSet<ItemStorage>();
    private final Map<Item, CompostRecipe> compostRecipes = new HashMap<Item, CompostRecipe>();
    private final Set<ItemStorage> plantables = new HashSet<ItemStorage>();
    private final Set<ItemStorage> fuel = new HashSet<ItemStorage>();
    private final Set<ItemStorage> food = new HashSet<ItemStorage>();
    private final Set<ItemStorage> edibles = new HashSet<ItemStorage>();
    private ImmutableSet<ItemStorage> beekeeperflowers = ImmutableSet.of();
    private final Map<Integer, List<ItemStorage>> luckyOres = new HashMap<Integer, List<ItemStorage>>();
    private static final Random random = new Random();
    private static ImmutableList<ItemStack> allItems = ImmutableList.of();
    private ImmutableSet<ResourceLocation> monsters = ImmutableSet.of();
    private final Map<ItemStorage, CreativeModeTab> creativeModeTabMap = new HashMap<ItemStorage, CreativeModeTab>();

    private void clear() {
        this.saplings.clear();
        this.oreBlocks.clear();
        this.smeltableOres.clear();
        this.plantables.clear();
        this.beekeeperflowers = ImmutableSet.of();
        this.food.clear();
        this.edibles.clear();
        this.fuel.clear();
        this.compostRecipes.clear();
        this.monsters = ImmutableSet.of();
        this.creativeModeTabMap.clear();
    }

    @Override
    public void discover(@NotNull RecipeManager recipeManager, Level level) {
        this.clear();
        this.discoverAllItems(level);
        this.discoverModCompat();
        this.discoverCompostRecipes(recipeManager);
        this.discoverMobs();
    }

    @Override
    public void serialize(@NotNull FriendlyByteBuf buf) {
        CompatibilityManager.serializeItemStorageList(buf, this.saplings);
        CompatibilityManager.serializeBlockList(buf, this.oreBlocks);
        CompatibilityManager.serializeItemStorageList(buf, this.smeltableOres);
        CompatibilityManager.serializeItemStorageList(buf, this.plantables);
        CompatibilityManager.serializeItemStorageList(buf, this.beekeeperflowers);
        CompatibilityManager.serializeItemStorageList(buf, this.food);
        CompatibilityManager.serializeItemStorageList(buf, this.edibles);
        CompatibilityManager.serializeItemStorageList(buf, this.fuel);
        CompatibilityManager.serializeRegistryIds(buf, ForgeRegistries.ENTITY_TYPES, this.monsters);
        CompatibilityManager.serializeCompostRecipes(buf, this.compostRecipes);
        buf.writeInt(ItemStackUtils.CHECKED_NBT_KEYS.size());
        for (Map.Entry<Item, Set<CheckedNbtKey>> entry : ItemStackUtils.CHECKED_NBT_KEYS.entrySet()) {
            buf.writeInt(BuiltInRegistries.f_257033_.m_7447_((Object)entry.getKey()));
            buf.writeInt(entry.getValue().size());
            for (CheckedNbtKey key : entry.getValue()) {
                ItemNbtCalculator.serializeKeyToBuffer(key, buf);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void deserialize(@NotNull FriendlyByteBuf buf, ClientLevel level) {
        this.clear();
        this.discoverAllItems((Level)level);
        this.saplings.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.oreBlocks.addAll(CompatibilityManager.deserializeBlockList(buf));
        this.smeltableOres.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.plantables.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.beekeeperflowers = ImmutableSet.copyOf(CompatibilityManager.deserializeItemStorageList(buf));
        this.food.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.edibles.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.fuel.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.monsters = ImmutableSet.copyOf(CompatibilityManager.deserializeRegistryIds(buf, ForgeRegistries.ENTITY_TYPES));
        Log.getLogger().info("Synchronized {} saplings", (Object)this.saplings.size());
        Log.getLogger().info("Synchronized {} ore blocks with {} smeltable ores", (Object)this.oreBlocks.size(), (Object)this.smeltableOres.size());
        Log.getLogger().info("Synchronized {} plantables", (Object)this.plantables.size());
        Log.getLogger().info("Synchronized {} flowers", (Object)this.beekeeperflowers.size());
        Log.getLogger().info("Synchronized {} food types with {} edible", (Object)this.food.size(), (Object)this.edibles.size());
        Log.getLogger().info("Synchronized {} fuel types", (Object)this.fuel.size());
        Log.getLogger().info("Synchronized {} monsters", (Object)this.monsters.size());
        this.discoverCompostRecipes(CompatibilityManager.deserializeCompostRecipes(buf));
        this.discoverModCompat();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7942_(buf.readInt());
            HashSet<CheckedNbtKey> nbtKeys = new HashSet<CheckedNbtKey>();
            int children = buf.readInt();
            for (int j = 0; j < children; ++j) {
                nbtKeys.add(ItemNbtCalculator.deSerializeKeyFromBuffer(buf));
            }
            ItemStackUtils.CHECKED_NBT_KEYS.put(item, nbtKeys);
        }
    }

    private static void serializeItemStorageList(@NotNull FriendlyByteBuf buf, @NotNull Collection<ItemStorage> list) {
        buf.m_236828_(list, StandardFactoryController.getInstance()::serialize);
    }

    @NotNull
    private static List<ItemStorage> deserializeItemStorageList(@NotNull FriendlyByteBuf buf) {
        return buf.m_236845_(StandardFactoryController.getInstance()::deserialize);
    }

    private static void serializeBlockList(@NotNull FriendlyByteBuf buf, @NotNull Collection<Block> list) {
        buf.m_236828_(list.stream().map(ItemStack::new).toList(), FriendlyByteBuf::m_130055_);
    }

    @NotNull
    private static List<Block> deserializeBlockList(@NotNull FriendlyByteBuf buf) {
        List stacks = buf.m_236845_(FriendlyByteBuf::m_130267_);
        return stacks.stream().flatMap(stack -> {
            Stream<Object> stream;
            Item patt9953$temp = stack.m_41720_();
            if (patt9953$temp instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)patt9953$temp;
                stream = Stream.of(blockItem.m_40614_());
            } else {
                stream = Stream.empty();
            }
            return stream;
        }).toList();
    }

    private static void serializeRegistryIds(@NotNull FriendlyByteBuf buf, @NotNull IForgeRegistry<?> registry, @NotNull Collection<ResourceLocation> ids) {
        buf.m_236828_(ids, (b, id) -> b.writeRegistryIdUnsafe(registry, id));
    }

    @NotNull
    private static <T> List<ResourceLocation> deserializeRegistryIds(@NotNull FriendlyByteBuf buf, @NotNull IForgeRegistry<T> registry) {
        return buf.m_236845_(b -> b.readRegistryIdUnsafe(registry)).stream().flatMap(item -> Stream.ofNullable(registry.getKey(item))).toList();
    }

    private static void serializeCompostRecipes(@NotNull FriendlyByteBuf buf, @NotNull Map<Item, CompostRecipe> compostRecipes) {
        List<CompostRecipe> recipes = compostRecipes.values().stream().distinct().toList();
        buf.m_236828_(recipes, ((CompostRecipe.Serializer)ModRecipeSerializer.CompostRecipeSerializer.get())::toNetwork);
    }

    @NotNull
    private static List<CompostRecipe> deserializeCompostRecipes(@NotNull FriendlyByteBuf buf) {
        CompostRecipe.Serializer serializer = (CompostRecipe.Serializer)ModRecipeSerializer.CompostRecipeSerializer.get();
        ResourceLocation empty = new ResourceLocation("");
        return buf.m_236845_(b -> serializer.fromNetwork(empty, (FriendlyByteBuf)b));
    }

    @Override
    public List<ItemStack> getListOfAllItems() {
        if (allItems.isEmpty()) {
            Log.getLogger().error("getListOfAllItems when empty");
        }
        return allItems;
    }

    @Override
    public Set<ItemStorage> getSetOfAllItems() {
        if (this.creativeModeTabMap.isEmpty()) {
            Log.getLogger().error("getSetOfAllItems when empty");
        }
        return this.creativeModeTabMap.keySet();
    }

    @Override
    public boolean isPlantable(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_41720_() instanceof BlockItem && itemStack.m_204117_(ModTags.floristFlowers);
    }

    @Override
    public boolean isLuckyBlock(Block block) {
        return block.m_49966_().m_204336_(ModTags.oreChanceBlocks);
    }

    @Override
    @Nullable
    public ItemStack getSaplingForLeaf(Block block) {
        if (this.leavesToSaplingMap.containsKey(block)) {
            return this.leavesToSaplingMap.get(block).getItemStack();
        }
        return null;
    }

    @Override
    public Set<ItemStorage> getCopyOfSaplings() {
        if (this.saplings.isEmpty()) {
            Log.getLogger().error("getCopyOfSaplings when empty");
        }
        return new HashSet<ItemStorage>(this.saplings);
    }

    @Override
    public Set<ItemStorage> getFuel() {
        if (this.fuel.isEmpty()) {
            Log.getLogger().error("getFuel when empty");
        }
        return this.fuel;
    }

    @Override
    public Set<ItemStorage> getFood() {
        if (this.food.isEmpty()) {
            Log.getLogger().error("getFood when empty");
        }
        return this.food;
    }

    @Override
    public Set<ItemStorage> getEdibles(int minNutrition) {
        if (this.edibles.isEmpty()) {
            Log.getLogger().error("getEdibles when empty");
        }
        HashSet<ItemStorage> filteredEdibles = new HashSet<ItemStorage>();
        for (ItemStorage storage : this.edibles) {
            if (storage.getItemStack().getFoodProperties(null) == null || storage.getItemStack().getFoodProperties(null).m_38744_() < minNutrition) continue;
            filteredEdibles.add(storage);
        }
        return filteredEdibles;
    }

    @Override
    public Set<ItemStorage> getSmeltableOres() {
        if (this.smeltableOres.isEmpty()) {
            Log.getLogger().error("getSmeltableOres when empty");
        }
        return this.smeltableOres;
    }

    @Override
    public Map<Item, CompostRecipe> getCopyOfCompostRecipes() {
        if (this.compostRecipes.isEmpty()) {
            Log.getLogger().error("getCopyOfCompostRecipes when empty");
        }
        return ImmutableMap.copyOf(this.compostRecipes);
    }

    @Override
    public Set<ItemStorage> getCompostInputs() {
        if (this.compostRecipes.isEmpty()) {
            Log.getLogger().error("getCompostInputs when empty");
        }
        return this.compostRecipes.keySet().stream().map(item -> new ItemStorage(new ItemStack((ItemLike)item))).collect(Collectors.toSet());
    }

    @Override
    public Set<ItemStorage> getCopyOfPlantables() {
        if (this.plantables.isEmpty()) {
            Log.getLogger().error("getCopyOfPlantables when empty");
        }
        return new HashSet<ItemStorage>(this.plantables);
    }

    @Override
    public Set<ItemStorage> getImmutableFlowers() {
        if (this.beekeeperflowers.isEmpty()) {
            Log.getLogger().error("getImmutableFlowers when empty");
        }
        return this.beekeeperflowers;
    }

    @Override
    public boolean isOre(BlockState block) {
        if (this.oreBlocks.isEmpty()) {
            Log.getLogger().error("isOre when empty");
        }
        return this.oreBlocks.contains(block.m_60734_());
    }

    @Override
    public boolean isOre(@NotNull ItemStack stack) {
        if (this.isBreakableOre(stack)) {
            return true;
        }
        if (this.isMineableOre(stack) || stack.m_204117_(ModTags.raw_ore)) {
            ItemStack smeltingResult = MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack);
            return !smeltingResult.m_41619_();
        }
        return false;
    }

    @Override
    public boolean isMineableOre(@NotNull ItemStack stack) {
        return !ItemStackUtils.isEmpty(stack) && stack.m_204117_(Tags.Items.ORES);
    }

    @Override
    public boolean isBreakableOre(@NotNull ItemStack stack) {
        if (stack.m_204117_(ModTags.breakable_ore)) {
            Block block = Block.m_49814_((Item)stack.m_41720_());
            if (!block.m_49966_().m_60795_()) {
                List<LootTableAnalyzer.LootDrop> drops = CustomRecipeManager.getInstance().getLootDrops(block.m_60589_());
                for (LootTableAnalyzer.LootDrop drop : drops) {
                    for (ItemStack dropStack : drop.getItemStacks()) {
                        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(stack, dropStack).booleanValue()) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        @NotNull ListTag saplingsLeavesTagList = this.leavesToSaplingMap.entrySet().stream().filter(entry -> entry.getKey() != null).map(entry -> CompatibilityManager.writeLeafSaplingEntryToNBT(((Block)entry.getKey()).m_49966_(), (ItemStorage)entry.getValue())).collect(NBTUtils.toListNBT());
        compound.m_128365_("tagSapLeaves", (Tag)saplingsLeavesTagList);
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        NBTUtils.streamCompound(compound.m_128437_("tagSapLeaves", 10)).map(CompatibilityManager::readLeafSaplingEntryFromNBT).filter(key -> !((BlockState)key.getA()).m_60795_() && !this.leavesToSaplingMap.containsKey(((BlockState)key.getA()).m_60734_()) && !this.leavesToSaplingMap.containsValue(key.getB())).forEach(key -> this.leavesToSaplingMap.put(((BlockState)key.getA()).m_60734_(), (ItemStorage)key.getB()));
    }

    @Override
    public void connectLeafToSapling(Block leaf, ItemStack stack) {
        if (!this.leavesToSaplingMap.containsKey(leaf)) {
            this.leavesToSaplingMap.put(leaf, new ItemStorage(stack, false, true));
        }
    }

    @Override
    public CreativeModeTab getCreativeTab(ItemStorage checkItem) {
        return this.creativeModeTabMap.get(checkItem);
    }

    @Override
    public int getCreativeTabKey(ItemStorage checkItem) {
        CreativeModeTab creativeTab = this.creativeModeTabMap.get(checkItem);
        return creativeTab == null ? 0 : this.creativeModeTabMap.get(checkItem).m_257903_();
    }

    @Override
    public ImmutableSet<ResourceLocation> getAllMonsters() {
        if (this.monsters.isEmpty()) {
            Log.getLogger().error("getAllMonsters when empty");
        }
        return this.monsters;
    }

    private void discoverMobs() {
        HashSet<ResourceLocation> monsterSet = new HashSet<ResourceLocation>();
        for (Map.Entry entry : ForgeRegistries.ENTITY_TYPES.getEntries()) {
            if (((EntityType)entry.getValue()).m_20674_() == MobCategory.MONSTER) {
                monsterSet.add(((ResourceKey)entry.getKey()).m_135782_());
                continue;
            }
            if (!((EntityType)entry.getValue()).m_204039_(ModTags.hostile)) continue;
            monsterSet.add(((ResourceKey)entry.getKey()).m_135782_());
        }
        this.monsters = ImmutableSet.copyOf(monsterSet);
    }

    private void discoverAllItems(Level level) {
        if (!this.food.isEmpty()) {
            return;
        }
        HashSet tempDuplicates = new HashSet();
        HashSet tempFlowers = new HashSet();
        CreativeModeTab.ItemDisplayParameters tempDisplayParams = new CreativeModeTab.ItemDisplayParameters(level.m_246046_(), false, (HolderLookup.Provider)level.m_9598_());
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        CraftingUtils.forEachCreativeTabItems(tempDisplayParams, (tab, stacks) -> {
            Object2IntLinkedOpenHashMap mapping = new Object2IntLinkedOpenHashMap();
            for (ItemStack item : stacks) {
                if (!tempDuplicates.add(new ItemStorage(item)) || mapping.addTo((Object)item.m_41720_(), 1) > 100) continue;
                listBuilder.add((Object)item);
                this.discoverSaplings(item);
                this.discoverOres(item);
                this.discoverPlantables(item);
                this.discoverFood(item);
                this.discoverFuel(item);
                this.discoverBeekeeperFlowers(item, tempFlowers);
                this.creativeModeTabMap.put(new ItemStorage(item), (CreativeModeTab)tab);
            }
        });
        this.discoverFungi();
        this.beekeeperflowers = ImmutableSet.copyOf(tempFlowers);
        Log.getLogger().info("Finished discovering Ores " + this.oreBlocks.size() + " " + this.smeltableOres.size());
        Log.getLogger().info("Finished discovering saplings " + this.saplings.size());
        Log.getLogger().info("Finished discovering plantables " + this.plantables.size());
        Log.getLogger().info("Finished discovering food " + this.edibles.size() + " " + this.food.size());
        Log.getLogger().info("Finished discovering fuel " + this.fuel.size());
        Log.getLogger().info("Finished discovering flowers " + this.beekeeperflowers.size());
        allItems = listBuilder.build();
        Log.getLogger().info("Finished discovering items " + allItems.size());
    }

    private void discoverBeekeeperFlowers(ItemStack item, Set<ItemStorage> tempFlowers) {
        if (item.m_204117_(ItemTags.f_13149_)) {
            tempFlowers.add(new ItemStorage(item));
        }
    }

    private void discoverOres(ItemStack stack) {
        if (stack.m_204117_(Tags.Items.ORES) || stack.m_204117_(ModTags.breakable_ore) || stack.m_204117_(ModTags.raw_ore)) {
            if (stack.m_41720_() instanceof BlockItem) {
                this.oreBlocks.add(((BlockItem)stack.m_41720_()).m_40614_());
            }
            if (!MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack).m_41619_()) {
                this.smeltableOres.add(new ItemStorage(stack));
            }
        }
    }

    private void discoverSaplings(ItemStack stack) {
        if (stack.m_204117_(ItemTags.f_13180_) || stack.m_204117_(Tags.Items.MUSHROOMS) || stack.m_204117_(ModTags.fungi)) {
            this.saplings.add(new ItemStorage(stack, false, true));
        }
    }

    private void discoverFungi() {
        this.leavesToSaplingMap.put(Blocks.f_50451_, new ItemStorage(new ItemStack((ItemLike)Items.f_41954_)));
        this.leavesToSaplingMap.put(Blocks.f_50692_, new ItemStorage(new ItemStack((ItemLike)Items.f_41955_)));
    }

    private void discoverCompostRecipes(@NotNull RecipeManager recipeManager) {
        if (this.compostRecipes.isEmpty()) {
            this.discoverCompostRecipes(recipeManager.m_44054_((RecipeType)ModRecipeSerializer.CompostRecipeType.get()).values().stream().map(r -> r).toList());
            Log.getLogger().info("Finished discovering compostables " + this.compostRecipes.size());
        }
    }

    private void discoverCompostRecipes(@NotNull List<CompostRecipe> recipes) {
        for (CompostRecipe recipe : recipes) {
            for (ItemStack stack : recipe.getInput().m_43908_()) {
                this.compostRecipes.merge(stack.m_41720_(), recipe, (r1, r2) -> r1.getStrength() < r2.getStrength() ? r1 : r2);
            }
        }
    }

    private void discoverPlantables(ItemStack stack) {
        if (stack.m_204117_(ModTags.floristFlowers) && stack.m_41720_() instanceof BlockItem) {
            this.plantables.add(new ItemStorage(stack));
        }
    }

    private void discoverFuel(ItemStack stack) {
        if (FurnaceBlockEntity.m_58399_((ItemStack)stack)) {
            this.fuel.add(new ItemStorage(stack));
        }
    }

    private void discoverFood(ItemStack stack) {
        if (ItemStackUtils.ISFOOD.test(stack) || ItemStackUtils.ISCOOKABLE.test(stack)) {
            this.food.add(new ItemStorage(stack));
            if (FoodUtils.EDIBLE.test(stack)) {
                this.edibles.add(new ItemStorage(stack));
            }
        }
    }

    private static CompoundTag writeLeafSaplingEntryToNBT(BlockState state, ItemStorage storage) {
        CompoundTag compound = NbtUtils.m_129202_((BlockState)state);
        storage.getItemStack().m_41739_(compound);
        return compound;
    }

    private static Tuple<BlockState, ItemStorage> readLeafSaplingEntryFromNBT(CompoundTag compound) {
        return new Tuple<BlockState, ItemStorage>(NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)compound), new ItemStorage(ItemStack.m_41712_((CompoundTag)compound), false, true));
    }

    private void discoverModCompat() {
        if (ModList.get().isLoaded("resourcefulbees")) {
            Compatibility.beeHiveCompat = new ResourcefulBeesCompat();
        }
        if (ModList.get().isLoaded("tconstruct")) {
            Compatibility.tinkersCompat = new TinkersToolHelper();
            Compatibility.tinkersSlimeCompat = new SlimeTreeCheck();
        }
        if (ModList.get().isLoaded("dynamictrees")) {
            Compatibility.dynamicTreesCompat = new DynamicTreeCompat();
        }
    }

    @Override
    public int getNumberOfSaplings() {
        return this.saplings.size();
    }
}

