/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.modules;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IModuleContainer<T> {
    @NotNull
    public List<T> getModules();

    @NotNull
    public Class<T> getClassType();

    @NotNull
    default public <T2 extends T> List<T2> getModules(Class<T2> clazz) {
        return this.getModules(clazz, (Predicate<T2>)Predicates.alwaysTrue());
    }

    @NotNull
    default public List<T> getModules(Predicate<T> predicate) {
        return this.getModules(this.getClassType(), predicate);
    }

    @NotNull
    default public <T2 extends T> List<T2> getModules(Class<T2> clazz, Predicate<T2> predicate) {
        ArrayList<T2> modules = new ArrayList<T2>();
        for (T module : this.getModules()) {
            T2 castedModule;
            if (!clazz.isInstance(module) || !predicate.test(castedModule = clazz.cast(module))) continue;
            modules.add(castedModule);
        }
        return modules;
    }

    @Nullable
    default public <T2 extends T> T2 getModule(Class<T2> clazz) {
        return clazz.cast(this.getModule(clazz::isInstance));
    }

    @Nullable
    default public T getModule(Predicate<T> predicate) {
        return this.getModule(this.getClassType(), predicate);
    }

    @Nullable
    default public <T2 extends T> T2 getModule(Class<T2> clazz, Predicate<T2> predicate) {
        for (T module : this.getModules()) {
            T2 castedModule;
            if (!clazz.isInstance(module) || !predicate.test(castedModule = clazz.cast(module))) continue;
            return castedModule;
        }
        return null;
    }

    default public <T2 extends T> boolean hasModule(Class<T2> clazz) {
        return this.hasModule(clazz, (Predicate<T2>)Predicates.alwaysTrue());
    }

    default public boolean hasModule(Predicate<T> predicate) {
        return this.hasModule(this.getClassType(), predicate);
    }

    default public <T2 extends T> boolean hasModule(Class<T2> clazz, Predicate<T2> predicate) {
        return this.getModule(clazz, predicate) != null;
    }

    @Deprecated
    @NotNull
    default public <T2 extends T> T2 getFirstModuleOccurance(Class<T2> clazz) {
        T2 module = this.getModule(clazz);
        if (module == null) {
            throw new IllegalArgumentException(String.format("No module found for class %s", clazz.getName()));
        }
        return module;
    }

    @Deprecated
    @NotNull
    default public <T2 extends T> T2 getModuleMatching(Class<T2> clazz, Predicate<T2> modulePredicate) {
        T2 module = this.getModule(clazz, modulePredicate);
        if (module == null) {
            throw new IllegalArgumentException(String.format("No module found for class %s and predicate", clazz.getName()));
        }
        return module;
    }

    @Deprecated
    @NotNull
    default public <T2 extends T> List<T2> getModulesByType(Class<T2> clazz) {
        return this.getModules(clazz);
    }
}

