/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.interactionhandling;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.util.Tuple;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInteractionResponseHandler
implements IInteractionResponseHandler {
    private Component inquiry;
    private Map<Component, Component> responses = new LinkedHashMap<Component, Component>();
    private boolean primary;
    private IChatPriority priority;

    @SafeVarargs
    public AbstractInteractionResponseHandler(@NotNull Component inquiry, boolean primary, IChatPriority priority, Tuple<Component, Component> ... responseTuples) {
        this.inquiry = inquiry;
        this.primary = primary;
        this.priority = priority;
        for (Tuple<Component, Component> element : responseTuples) {
            this.responses.put(element.getA(), element.getB());
        }
    }

    public AbstractInteractionResponseHandler() {
    }

    @Override
    public Component getInquiry() {
        return this.inquiry;
    }

    @Override
    @Nullable
    public Component getResponseResult(Component response) {
        return this.responses.getOrDefault(response, null);
    }

    @Override
    public List<Component> getPossibleResponses() {
        return ImmutableList.copyOf(this.responses.keySet());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("inquiry", Component.Serializer.m_130703_((Component)this.inquiry));
        ListTag list = new ListTag();
        for (Map.Entry<Component, Component> element : this.responses.entrySet()) {
            CompoundTag elementTag = new CompoundTag();
            elementTag.m_128359_("response", Component.Serializer.m_130703_((Component)element.getKey()));
            elementTag.m_128359_("nextinquiry", Component.Serializer.m_130703_((Component)element.getValue()));
            list.add((Object)elementTag);
        }
        tag.m_128365_("responses", (Tag)list);
        tag.m_128379_("primary", this.isPrimary());
        tag.m_128405_("priority", this.priority.getPriority());
        tag.m_128359_("handlertype", this.getType());
        return tag;
    }

    public void deserializeNBT(@NotNull CompoundTag compoundNBT) {
        this.inquiry = Component.Serializer.m_130701_((String)compoundNBT.m_128461_("inquiry"));
        ListTag list = compoundNBT.m_128437_("responses", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag nbt = list.m_128728_(i);
            this.responses.put((Component)Component.Serializer.m_130701_((String)nbt.m_128461_("response")), (Component)Component.Serializer.m_130701_((String)nbt.m_128461_("nextinquiry")));
        }
        this.primary = compoundNBT.m_128471_("primary");
        this.priority = ChatPriority.values()[compoundNBT.m_128451_("priority")];
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public IChatPriority getPriority() {
        return this.priority;
    }

    @Override
    public boolean isVisible(Level world) {
        return true;
    }

    @Override
    public boolean isValid(ICitizenData colony) {
        return true;
    }
}

