/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.colonyEvents.registry;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.util.Log;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ColonyEventTypeRegistryEntry {
    private final BiFunction<IColony, CompoundTag, IColonyEvent> eventCreator;
    private final ResourceLocation registryName;
    private final boolean isRaidEvent;

    public ColonyEventTypeRegistryEntry(@NotNull BiFunction<IColony, CompoundTag, IColonyEvent> eventCreator, @NotNull ResourceLocation registryID) {
        this(eventCreator, registryID, false);
    }

    public ColonyEventTypeRegistryEntry(@NotNull BiFunction<IColony, CompoundTag, IColonyEvent> eventCreator, @NotNull ResourceLocation registryID, boolean isRaidEvent) {
        if (registryID.m_135815_().isEmpty()) {
            Log.getLogger().warn("Created empty registry empty for event, supply a name for it!");
        }
        this.eventCreator = eventCreator;
        this.registryName = registryID;
        this.isRaidEvent = isRaidEvent;
    }

    public IColonyEvent deserializeEvent(@Nonnull IColony colony, @Nonnull CompoundTag compound) {
        return this.eventCreator.apply(colony, compound);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public boolean isRaidEvent() {
        return this.isRaidEvent;
    }
}

