/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public interface IColonyTagCapability {
    public void removeColony(int var1, LevelChunk var2);

    public void addColony(int var1, LevelChunk var2);

    @NotNull
    public List<Integer> getStaticClaimColonies();

    public void setOwningColony(int var1, LevelChunk var2);

    public int getOwningColony();

    public void reset(LevelChunk var1);

    public void addBuildingClaim(int var1, BlockPos var2, LevelChunk var3);

    public void removeBuildingClaim(int var1, BlockPos var2, LevelChunk var3);

    public void setStaticColonyClaim(List<Integer> var1);

    @NotNull
    public Map<Integer, Set<BlockPos>> getAllClaimingBuildings();

    public void readFromNBT(CompoundTag var1);

    public static class Storage {
        public static Tag writeNBT(@NotNull Capability<IColonyTagCapability> capability, @NotNull IColonyTagCapability instance, @Nullable Direction side) {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("id", instance.getOwningColony());
            compound.m_128365_("colonies", (Tag)instance.getStaticClaimColonies().stream().map(Storage::write).collect(NBTUtils.toListNBT()));
            compound.m_128365_("buildingsClaim", (Tag)instance.getAllClaimingBuildings().entrySet().stream().map(Storage::writeClaims).collect(NBTUtils.toListNBT()));
            return compound;
        }

        public static void readNBT(@NotNull Capability<IColonyTagCapability> capability, @NotNull IColonyTagCapability instance, @Nullable Direction side, @NotNull Tag nbt) {
            if (nbt instanceof CompoundTag && ((CompoundTag)nbt).m_128441_("id")) {
                instance.readFromNBT((CompoundTag)nbt);
            }
        }

        private static CompoundTag write(int id) {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("id", id);
            return compound;
        }

        private static CompoundTag writeClaims(@NotNull Map.Entry<Integer, Set<BlockPos>> entry) {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("id", entry.getKey().intValue());
            compound.m_128365_("buildings", (Tag)entry.getValue().stream().map(pos -> BlockPosUtil.write(new CompoundTag(), "building", pos)).collect(NBTUtils.toListNBT()));
            return compound;
        }
    }

    public static class Impl
    implements IColonyTagCapability {
        private Set<Integer> colonies = new HashSet<Integer>();
        private int owningColony = 0;
        private final Map<Integer, Set<BlockPos>> claimingBuildings = new HashMap<Integer, Set<BlockPos>>();

        @Override
        public void addColony(int id, LevelChunk chunk) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(id, (ResourceKey<Level>)chunk.m_62953_().m_46472_());
            if (colony == null) {
                return;
            }
            this.colonies.add(id);
            if (this.owningColony == 0 || IColonyManager.getInstance().getColonyByDimension(this.owningColony, (ResourceKey<Level>)chunk.m_62953_().m_46472_()) == null) {
                colony.addLoadedChunk(ChunkPos.m_45589_((int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_), chunk);
                this.owningColony = id;
            }
            chunk.m_8092_(true);
        }

        @Override
        public void removeColony(int id, LevelChunk chunk) {
            this.colonies.remove(id);
            this.claimingBuildings.remove(id);
            if (this.owningColony == id) {
                this.owningColony = !this.claimingBuildings.isEmpty() ? this.claimingBuildings.keySet().iterator().next() : (!this.colonies.isEmpty() ? this.colonies.iterator().next() : 0);
            }
            chunk.m_8092_(true);
        }

        @Override
        public void setStaticColonyClaim(List<Integer> colonies) {
            this.colonies = new HashSet<Integer>(colonies);
        }

        @Override
        public void reset(LevelChunk chunk) {
            this.colonies.clear();
            this.owningColony = 0;
            this.claimingBuildings.clear();
            chunk.m_8092_(true);
        }

        @Override
        public void addBuildingClaim(int colonyId, BlockPos pos, LevelChunk chunk) {
            IColony colony;
            if (chunk.m_7697_().equals((Object)ChunkPos.f_186419_) && ((colony = IColonyManager.getInstance().getColonyByDimension(colonyId, (ResourceKey<Level>)chunk.m_62953_().m_46472_())) == null || BlockPosUtil.getDistance2D(colony.getCenter(), BlockPos.f_121853_) > 200L)) {
                Log.getLogger().warn("Claiming id:" + colonyId + " building at zero pos!" + String.valueOf(pos), (Throwable)new Exception());
            }
            if (this.owningColony == 0) {
                this.setOwningColony(colonyId, chunk);
                colony = IColonyManager.getInstance().getColonyByDimension(colonyId, (ResourceKey<Level>)chunk.m_62953_().m_46472_());
                if (colony != null) {
                    colony.addLoadedChunk(ChunkPos.m_45589_((int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_), chunk);
                }
            }
            if (this.claimingBuildings.containsKey(colonyId)) {
                this.claimingBuildings.get(colonyId).add(pos);
            } else {
                HashSet<BlockPos> newList = new HashSet<BlockPos>();
                newList.add(pos);
                this.claimingBuildings.put(colonyId, newList);
            }
            chunk.m_8092_(true);
        }

        @Override
        public void removeBuildingClaim(int colonyId, BlockPos pos, LevelChunk chunk) {
            if (!this.claimingBuildings.containsKey(colonyId)) {
                return;
            }
            chunk.m_8092_(true);
            Set<BlockPos> buildings = this.claimingBuildings.get(colonyId);
            buildings.remove(pos);
            if (buildings.isEmpty()) {
                this.claimingBuildings.remove(colonyId);
                if (this.owningColony == colonyId && !this.colonies.contains(this.owningColony)) {
                    if (this.claimingBuildings.isEmpty()) {
                        this.owningColony = this.colonies.isEmpty() ? 0 : this.colonies.iterator().next();
                    } else {
                        Iterator<Map.Entry<Integer, Set<BlockPos>>> colonyIt = this.claimingBuildings.entrySet().iterator();
                        while (colonyIt.hasNext()) {
                            Map.Entry<Integer, Set<BlockPos>> colonyEntry = colonyIt.next();
                            IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyEntry.getKey(), (ResourceKey<Level>)chunk.m_62953_().m_46472_());
                            if (colony == null) continue;
                            Iterator<BlockPos> buildingIt = colonyEntry.getValue().iterator();
                            while (buildingIt.hasNext()) {
                                BlockPos buildingPos = buildingIt.next();
                                if (colony.getBuildingManager().getBuilding(buildingPos) != null) {
                                    colony.addLoadedChunk(ChunkPos.m_45589_((int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_), chunk);
                                    this.setOwningColony(colonyEntry.getKey(), chunk);
                                    return;
                                }
                                buildingIt.remove();
                            }
                            if (!colonyEntry.getValue().isEmpty()) continue;
                            colonyIt.remove();
                        }
                    }
                }
            }
        }

        @Override
        public void setOwningColony(int id, LevelChunk chunk) {
            this.owningColony = id;
            chunk.m_8092_(true);
        }

        @Override
        public int getOwningColony() {
            return this.owningColony;
        }

        @Override
        @NotNull
        public List<Integer> getStaticClaimColonies() {
            return new ArrayList<Integer>(this.colonies);
        }

        @Override
        @NotNull
        public Map<Integer, Set<BlockPos>> getAllClaimingBuildings() {
            return this.claimingBuildings;
        }

        @Override
        public void readFromNBT(CompoundTag compound) {
            this.owningColony = compound.m_128451_("id");
            NBTUtils.streamCompound(compound.m_128437_("colonies", 10)).map(c -> c.m_128451_("id")).forEach(this.colonies::add);
            NBTUtils.streamCompound(compound.m_128437_("buildingsClaim", 10)).forEach(this::readClaims);
            if (this.owningColony == 0 && !this.getStaticClaimColonies().isEmpty()) {
                this.owningColony = this.getStaticClaimColonies().get(0);
            }
        }

        private void readClaims(CompoundTag compound) {
            int id = compound.m_128451_("id");
            NBTUtils.streamCompound(compound.m_128437_("buildings", 10)).forEach(tag -> {
                BlockPos pos = BlockPosUtil.read(tag, "building");
                if (this.claimingBuildings.containsKey(id)) {
                    this.claimingBuildings.get(id).add(pos);
                } else {
                    HashSet<BlockPos> newList = new HashSet<BlockPos>();
                    newList.add(pos);
                    this.claimingBuildings.put(id, newList);
                }
            });
        }
    }
}

