/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.block;

import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class CantaloupePlantBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)};

    public CantaloupePlantBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return Util.gs(this.isMaxAge(state) ? DelightfulItems.CANTALOUPE : DelightfulItems.CANTALOUPE_SEEDS, new int[0]);
    }

    protected boolean m_6266_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return pState.m_204336_(Tags.Blocks.SAND);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE_BY_AGE[(Integer)pState.m_61143_((Property)AGE)];
    }

    public void m_213897_(BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        if (!pState.m_60710_((LevelReader)pLevel, pPos)) {
            pLevel.m_46961_(pPos, true);
        }
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return !this.isMaxAge(state);
    }

    public void m_213898_(BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        int i = (Integer)pState.m_61143_((Property)AGE);
        if (i < 3 && pLevel.m_45524_(pPos.m_7494_(), 0) >= 8 && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_(16) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            pLevel.m_7731_(pPos, blockstate, 2);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223722_((BlockState)blockstate));
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public boolean m_7898_(@NotNull BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (pLevel.m_8055_(pPos.m_7495_()).canSustainPlant((BlockGetter)pLevel, pPos.m_7495_(), Direction.UP, (IPlantable)this)) {
            return true;
        }
        BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
        if (blockstate.m_204336_(Tags.Blocks.SAND)) {
            BlockPos blockpos = pPos.m_7495_();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!pState.canBeHydrated((BlockGetter)pLevel, pPos, pLevel.m_6425_(blockpos.m_121945_(direction)), blockpos.m_121945_(direction)) && !pLevel.m_8055_(blockpos.m_121945_(direction)).m_60713_(Blocks.f_50449_)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        boolean flag = this.isMaxAge(state);
        if (!flag && pPlayer.m_21120_(pHand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (flag) {
            CantaloupePlantBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)Util.gs(DelightfulItems.CANTALOUPE, new int[0]));
            pLevel.m_5594_(null, pPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
            BlockState blockstate = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
            pLevel.m_7731_(pPos, blockstate, 2);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pPlayer, (BlockState)blockstate));
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(state, pLevel, pPos, pPlayer, pHand, pHit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7370_(@NotNull LevelReader pLevel, @NotNull BlockPos pPos, @NotNull BlockState state, boolean pIsClient) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(@NotNull Level pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, BlockState pState) {
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(Math.min(3, (Integer)pState.m_61143_((Property)AGE) + 1))), 2);
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) >= 3;
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.BEACH;
    }
}

