/*
 * Decompiled with CFR 0.152.
 */
package com.bigenergy.achiopt.mixins;

import com.bigenergy.achiopt.interfaces.IItemPredicateMixin;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.ListTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ItemPredicate.class})
public abstract class ItemPredicateMixin
implements IItemPredicateMixin {
    @Mutable
    @Final
    @Shadow
    private final TagKey<Item> f_45029_;
    @Mutable
    @Final
    @Shadow
    private final Set<Item> f_151427_;
    @Mutable
    @Final
    @Shadow
    private final MinMaxBounds.Ints f_45031_;
    @Mutable
    @Final
    @Shadow
    private final MinMaxBounds.Ints f_45032_;
    @Mutable
    @Final
    @Shadow
    private final EnchantmentPredicate[] f_45033_;
    @Mutable
    @Final
    @Shadow
    private final EnchantmentPredicate[] f_45034_;
    @Mutable
    @Final
    @Shadow
    private final Potion f_45035_;
    @Mutable
    @Final
    @Shadow
    private final NbtPredicate f_45036_;

    protected ItemPredicateMixin(TagKey<Item> tag, Set<Item> items, MinMaxBounds.Ints count, MinMaxBounds.Ints durability, EnchantmentPredicate[] enchantments, EnchantmentPredicate[] storedEnchantments, Potion potion, NbtPredicate nbt) {
        this.f_45029_ = tag;
        this.f_151427_ = items;
        this.f_45031_ = count;
        this.f_45032_ = durability;
        this.f_45033_ = enchantments;
        this.f_45034_ = storedEnchantments;
        this.f_45035_ = potion;
        this.f_45036_ = nbt;
    }

    @Unique
    private boolean achievementOptimizer$checkEnchantments(ItemStack itemStack, EnchantmentPredicate[] enchantments) {
        Map enchantmentsMap = itemStack.getAllEnchantments();
        for (EnchantmentPredicate predicate : enchantments) {
            if (predicate.m_30476_(enchantmentsMap)) continue;
            return false;
        }
        return true;
    }

    @Unique
    private boolean achievementOptimizer$checkStoredEnchantments(ItemStack itemStack, EnchantmentPredicate[] storedEnchantments) {
        Map storedEnchantmentsMap = EnchantmentHelper.m_44882_((ListTag)EnchantedBookItem.m_41163_((ItemStack)itemStack));
        for (EnchantmentPredicate predicate : storedEnchantments) {
            if (predicate.m_30476_(storedEnchantmentsMap)) continue;
            return false;
        }
        return true;
    }

    @Shadow
    public abstract boolean m_45049_(ItemStack var1);

    @Override
    public boolean achiopt$fastMatches(ItemStack itemStack) {
        if (this.equals(ItemPredicate.f_45028_)) {
            return true;
        }
        if (this.f_45029_ != null && !itemStack.m_204117_(this.f_45029_)) {
            return false;
        }
        if (this.f_151427_ != null && !this.f_151427_.contains(itemStack.m_41720_())) {
            return false;
        }
        if (!this.f_45031_.m_55390_(itemStack.m_41613_())) {
            return false;
        }
        if (!(this.f_45032_.m_55327_() || itemStack.m_41763_() && this.f_45032_.m_55390_(itemStack.m_41776_() - itemStack.m_41773_()))) {
            return false;
        }
        if (!this.f_45036_.m_57479_(itemStack)) {
            return false;
        }
        if (this.f_45033_.length > 0 && !this.achievementOptimizer$checkEnchantments(itemStack, this.f_45033_)) {
            return false;
        }
        if (this.f_45034_.length > 0 && !this.achievementOptimizer$checkStoredEnchantments(itemStack, this.f_45034_)) {
            return false;
        }
        return this.f_45035_ == null || this.f_45035_ == PotionUtils.m_43579_((ItemStack)itemStack);
    }
}

