/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.forge;

import com.blackgear.platform.Platform;
import com.blackgear.platform.client.GameRendering;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class GameRenderingImpl {
    public static void registerBlockColors(Consumer<GameRendering.BlockColorEvent> listener) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> listener.accept(new GameRendering.BlockColorEvent((RegisterColorHandlersEvent.Block)event){
            final /* synthetic */ RegisterColorHandlersEvent.Block val$event;
            {
                this.val$event = block;
            }

            @Override
            public void register(BlockColor color, Block ... blocks) {
                this.val$event.register(color, blocks);
            }

            @Override
            public int getColor(BlockState state, BlockAndTintGetter level, BlockPos pos, int tint) {
                return this.val$event.getBlockColors().m_92577_(state, level, pos, tint);
            }
        }));
    }

    public static void registerItemColors(Consumer<GameRendering.ItemColorEvent> listener) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> listener.accept(new GameRendering.ItemColorEvent((RegisterColorHandlersEvent.Item)event){
            final /* synthetic */ RegisterColorHandlersEvent.Item val$event;
            {
                this.val$event = item;
            }

            @Override
            public void register(ItemColor color, ItemLike ... items) {
                this.val$event.register(color, items);
            }

            @Override
            public int getColor(ItemStack stack, int tint) {
                Item item = stack.m_41720_();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    BlockState state = blockItem.m_40614_().m_49966_();
                    return this.val$event.getBlockColors().m_92577_(state, null, null, tint);
                }
                return 0xFFFFFF;
            }
        }));
    }

    public static void registerBlockRenderers(Consumer<GameRendering.BlockRendererEvent> listener) {
        listener.accept(new GameRendering.BlockRendererEvent(){

            @Override
            public void register(RenderType type, Block ... blocks) {
                for (Block block : blocks) {
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
                }
            }

            @Override
            public void register(RenderType type, Fluid ... fluids) {
                for (Fluid fluid : fluids) {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)type);
                }
            }
        });
    }

    public static void registerEntityRenderers(Consumer<GameRendering.EntityRendererEvent> listener) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> listener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1)));
    }

    public static void registerBlockEntityRenderers(Consumer<GameRendering.BlockEntityRendererEvent> listener) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> listener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1)));
    }

    public static void registerModelLayers(Consumer<GameRendering.ModelLayerEvent> listener) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> listener.accept((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1)));
    }

    public static void registerSpecialModels(Consumer<GameRendering.SpecialModelEvent> listener) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            GameRendering.SpecialModelEvent modelEvent = new GameRendering.SpecialModelEvent((ModelEvent.RegisterAdditional)event){
                final /* synthetic */ ModelEvent.RegisterAdditional val$event;
                {
                    this.val$event = registerAdditional;
                }

                @Override
                public void register(ResourceLocation model) {
                    this.val$event.register(model);
                }

                @Override
                public void register(ResourceLocation ... models) {
                    for (ResourceLocation model : models) {
                        this.register(model);
                    }
                }
            };
            listener.accept(modelEvent);
        });
    }

    public static void registerModelOverrides(Consumer<GameRendering.ModelOverrideEvent> listener) {
        listener.accept(new GameRendering.ModelOverrideEvent(){});
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(event -> {
            for (ResourceLocation override : GameRendering.MODEL_OVERRIDES.values()) {
                event.register(GameRenderingImpl.wrapModel(override));
            }
        });
        modEventBus.addListener(event -> {
            Map models = event.getModels();
            for (Map.Entry<ResourceLocation, ResourceLocation> entry : GameRendering.MODEL_OVERRIDES.entrySet()) {
                ResourceLocation overrideModel = GameRenderingImpl.wrapModel(entry.getValue());
                BakedModel bakedOverride = (BakedModel)models.get(overrideModel);
                if (bakedOverride != null) {
                    ModelResourceLocation originalItemModel = new ModelResourceLocation(entry.getKey(), "inventory");
                    models.put(originalItemModel, bakedOverride);
                    continue;
                }
                Platform.LOGGER.error("Failed to find baked model for override: {}", (Object)overrideModel);
            }
        });
    }

    private static ResourceLocation wrapModel(ResourceLocation id) {
        if (id.m_135815_().startsWith("item/")) {
            return id;
        }
        return new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_());
    }

    public static void registerSkullRenderers(Consumer<GameRendering.SkullRendererEvent> listener) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            GameRendering.SkullRendererEvent skullEvent = new GameRendering.SkullRendererEvent((EntityRenderersEvent.CreateSkullModels)event){
                final /* synthetic */ EntityRenderersEvent.CreateSkullModels val$event;
                {
                    this.val$event = createSkullModels;
                }

                @Override
                public void registerSkullModel(SkullBlock.Type type, Function<ModelPart, SkullModelBase> model, ModelLayerLocation layer) {
                    this.val$event.registerSkullModel(type, model.apply(this.val$event.getEntityModelSet().m_171103_(layer)));
                }

                @Override
                public void registerSkullTexture(SkullBlock.Type type, ResourceLocation texture) {
                    SkullBlockRenderer.f_112519_.put(type, texture);
                }
            };
            listener.accept(skullEvent);
        });
    }

    public static void registerParticleFactories(Consumer<GameRendering.ParticleFactoryEvent> listener) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            GameRendering.ParticleFactoryEvent factoryEvent = new GameRendering.ParticleFactoryEvent((RegisterParticleProvidersEvent)event){
                final /* synthetic */ RegisterParticleProvidersEvent val$event;
                {
                    this.val$event = registerParticleProvidersEvent;
                }

                @Override
                public <T extends ParticleOptions, P extends ParticleType<T>> void register(Supplier<P> type, ParticleProvider<T> provider) {
                    this.val$event.registerSpecial((ParticleType)type.get(), provider);
                }

                @Override
                public <T extends ParticleOptions, P extends ParticleType<T>> void register(Supplier<P> type, GameRendering.ParticleFactoryEvent.Factory<T> factory) {
                    this.val$event.registerSpriteSet((ParticleType)type.get(), factory::create);
                }
            };
            listener.accept(factoryEvent);
        });
    }
}

