/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform;

import com.blackgear.platform.client.ClientConfig;
import com.blackgear.platform.client.ClientSetup;
import com.blackgear.platform.common.CommonSetup;
import com.blackgear.platform.common.resource.RegistryAwareJsonReloadListener;
import com.blackgear.platform.common.worldgen.modifier.BiomeManager;
import com.blackgear.platform.core.Environment;
import com.blackgear.platform.core.ModInstance;
import com.blackgear.platform.core.network.MessageHandler;
import com.blackgear.platform.core.util.config.ConfigLoader;
import com.blackgear.platform.core.util.config.ModConfig;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Platform {
    public static final String MOD_ID = "platform";
    public static final Logger LOGGER = LogManager.getLogger((String)"platform");
    public static final ClientConfig CLIENT_CONFIG = Environment.registerSafeConfig("platform", ModConfig.Type.CLIENT, ClientConfig::new);
    public static final ModInstance INSTANCE = ModInstance.create("platform").client(ClientSetup::setup).common(CommonSetup::setup).build();

    public static void bootstrap() {
        INSTANCE.bootstrap();
        MessageHandler.bootstrap();
        ConfigLoader.bootstrap();
        BiomeManager.bootstrap();
    }

    public static void afterDataReload(RegistryAccess registryAccess, boolean client) {
        RegistryAwareJsonReloadListener.runReloads(registryAccess);
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

