/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixinhandlers;

import com.mojang.blaze3d.platform.Window;
import fudge.notenoughcrashes.gui.InitErrorScreen;
import fudge.notenoughcrashes.stacktrace.CrashUtils;
import net.minecraft.CrashReport;
import net.minecraft.DetectedVersion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntryPointCatcher {
    private static CrashReport crashReport = null;
    private static final Logger LOGGER = LogManager.getLogger((String)"Not Enough Crashes Entry Points");

    public static boolean crashedDuringStartup() {
        return crashReport != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleEntryPointError(Throwable e) {
        crashReport = CrashReport.m_127521_((Throwable)e, (String)"Initializing game");
        crashReport.m_127514_("Initialization");
        Minecraft.m_167872_(null, null, (String)DetectedVersion.m_195834_().m_132493_(), null, (CrashReport)crashReport);
        CrashUtils.outputClientReport(crashReport);
        Window.m_85407_((integer, stringx) -> {});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void displayInitErrorScreen() {
        try {
            Minecraft.m_91087_().m_91152_((Screen)new InitErrorScreen(crashReport));
        }
        catch (Throwable t) {
            CrashReport additionalReport = CrashReport.m_127521_((Throwable)t, (String)"Displaying init error screen");
            LOGGER.error("An uncaught exception occured while displaying the init error screen, making normal report instead", t);
            CrashUtils.outputClientReport(additionalReport);
            System.exit(additionalReport.m_127527_() != null ? -1 : -2);
        }
    }
}

