/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.puffish.attributesmod.api.DynamicModification;
import net.puffish.attributesmod.api.PuffishAttributes;
import net.puffish.attributesmod.util.DamageKind;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class}, priority=1100)
public abstract class LivingEntityMixin {
    @ModifyExpressionValue(method={"createLivingAttributes"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/attribute/DefaultAttributeContainer;builder()Lnet/minecraft/entity/attribute/DefaultAttributeContainer$Builder;")})
    private static AttributeSupplier.Builder modifyExpressionValueAtBuilder(AttributeSupplier.Builder builder) {
        return builder.m_22266_(PuffishAttributes.MAGIC_DAMAGE).m_22266_(PuffishAttributes.MELEE_DAMAGE).m_22266_(PuffishAttributes.RANGED_DAMAGE).m_22266_(PuffishAttributes.SWORD_DAMAGE).m_22266_(PuffishAttributes.AXE_DAMAGE).m_22266_(PuffishAttributes.TRIDENT_DAMAGE).m_22266_(PuffishAttributes.HEALING).m_22266_(PuffishAttributes.JUMP).m_22266_(PuffishAttributes.RESISTANCE).m_22266_(PuffishAttributes.MAGIC_RESISTANCE).m_22266_(PuffishAttributes.MELEE_RESISTANCE).m_22266_(PuffishAttributes.RANGED_RESISTANCE).m_22266_(PuffishAttributes.ARMOR_SHRED).m_22266_(PuffishAttributes.TOUGHNESS_SHRED).m_22266_(PuffishAttributes.PROTECTION_SHRED).m_22266_(PuffishAttributes.RESISTANCE_SHRED).m_22266_(PuffishAttributes.MAGIC_RESISTANCE_SHRED).m_22266_(PuffishAttributes.MELEE_RESISTANCE_SHRED).m_22266_(PuffishAttributes.RANGED_RESISTANCE_SHRED).m_22266_(PuffishAttributes.STEALTH).m_22266_(PuffishAttributes.LIFE_STEAL).m_22266_(PuffishAttributes.FALL_REDUCTION).m_22266_(PuffishAttributes.BOW_PROJECTILE_SPEED).m_22266_(PuffishAttributes.CROSSBOW_PROJECTILE_SPEED);
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtDamage(float damage, DamageSource source) {
        if (damage < 0.0f) {
            return damage;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            OwnableEntity tameable;
            LivingEntity owner;
            DamageKind kind;
            LivingEntity attacker = (LivingEntity)entity;
            DynamicModification dm = DynamicModification.create();
            Item item = attacker.m_21205_().m_41720_();
            if (item instanceof SwordItem) {
                dm.withPositive(PuffishAttributes.SWORD_DAMAGE, attacker);
            }
            if (item instanceof AxeItem) {
                dm.withPositive(PuffishAttributes.AXE_DAMAGE, attacker);
            }
            if (item instanceof TridentItem) {
                dm.withPositive(PuffishAttributes.TRIDENT_DAMAGE, attacker);
            }
            if ((kind = DamageKind.of(source)).isMagic()) {
                dm.withPositive(PuffishAttributes.MAGIC_DAMAGE, attacker);
            } else {
                if (kind.isProjectile()) {
                    dm.withPositive(PuffishAttributes.RANGED_DAMAGE, attacker);
                }
                if (kind.isMelee()) {
                    dm.withPositive(PuffishAttributes.MELEE_DAMAGE, attacker);
                }
            }
            if (attacker instanceof OwnableEntity && (owner = (tameable = (OwnableEntity)attacker).m_269323_()) != null) {
                dm.withPositive(PuffishAttributes.TAMED_DAMAGE, owner);
            }
            damage = dm.applyTo(damage);
        }
        return damage;
    }

    @WrapOperation(method={"applyArmorToDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/DamageUtil;getDamageLeft(FFF)F")})
    private float wrapOperationAtApplyArmorToDamage(float damage, float armor, float toughness, Operation<Float> operation, @Local(argsOnly=true) DamageSource source) {
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            armor = Math.max(0.0f, DynamicModification.create().withNegative(PuffishAttributes.ARMOR_SHRED, attacker).applyTo(armor));
            toughness = Math.max(0.0f, DynamicModification.create().withNegative(PuffishAttributes.TOUGHNESS_SHRED, attacker).applyTo(toughness));
        }
        return ((Float)operation.call(new Object[]{Float.valueOf(damage), Float.valueOf(armor), Float.valueOf(toughness)})).floatValue();
    }

    @WrapOperation(method={"modifyAppliedDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/DamageUtil;getInflictedDamage(FF)F")})
    private float wrapOperationAtModifyAppliedDamage(float damageDealt, float protection, Operation<Float> original, @Local(argsOnly=true) DamageSource source) {
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            protection = Math.max(0.0f, DynamicModification.create().withNegative(PuffishAttributes.PROTECTION_SHRED, attacker).applyTo(protection));
        }
        return ((Float)original.call(new Object[]{Float.valueOf(damageDealt), Float.valueOf(protection)})).floatValue();
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtHeal(float amount) {
        if (amount < 0.0f) {
            return amount;
        }
        return DynamicModification.create().withPositive(PuffishAttributes.HEALING, (LivingEntity)this).applyTo(amount);
    }

    @ModifyReturnValue(method={"getJumpVelocity"}, at={@At(value="RETURN")})
    private float injectAtGetJumpVelocity(float jump) {
        return DynamicModification.create().withPositive(PuffishAttributes.JUMP, (LivingEntity)this).applyTo(jump);
    }

    @ModifyVariable(method={"computeFallDamage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float modifyVariableAtComputeFallDamage(float fallDistance) {
        return DynamicModification.create().withNegative(PuffishAttributes.FALL_REDUCTION, (LivingEntity)this).applyTo(fallDistance) - DynamicModification.create().withPositive(PuffishAttributes.JUMP, (LivingEntity)this).relativeTo(1.0f) * 10.0f;
    }

    @WrapMethod(method={"applyArmorToDamage"})
    private float wrapMethodApplyArmorToDamage(DamageSource source, float amount, Operation<Float> original) {
        OwnableEntity tameable;
        LivingEntity owner;
        Float damage = (Float)original.call(new Object[]{source, Float.valueOf(amount)});
        if (source.m_269533_(DamageTypeTags.f_268437_)) {
            return damage.floatValue();
        }
        if (damage.floatValue() > 1.1342745E38f) {
            return damage.floatValue();
        }
        LivingEntity entity = (LivingEntity)this;
        DamageKind kind = DamageKind.of(source);
        DynamicModification dmResistance = DynamicModification.create();
        dmResistance.withNegative(PuffishAttributes.RESISTANCE, entity);
        if (kind.isMagic()) {
            dmResistance.withNegative(PuffishAttributes.MAGIC_RESISTANCE, entity);
        } else {
            if (kind.isProjectile()) {
                dmResistance.withNegative(PuffishAttributes.RANGED_RESISTANCE, entity);
            }
            if (kind.isMelee()) {
                dmResistance.withNegative(PuffishAttributes.MELEE_RESISTANCE, entity);
            }
        }
        if (entity instanceof OwnableEntity && (owner = (tameable = (OwnableEntity)entity).m_269323_()) != null) {
            dmResistance.withNegative(PuffishAttributes.TAMED_RESISTANCE, owner);
        }
        float resistance = damage.floatValue() - dmResistance.applyTo(damage.floatValue());
        Entity entity2 = source.m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            DynamicModification dmShred = DynamicModification.create();
            dmShred.withNegative(PuffishAttributes.RESISTANCE_SHRED, attacker);
            if (kind.isMagic()) {
                dmShred.withNegative(PuffishAttributes.MAGIC_RESISTANCE_SHRED, attacker);
            } else {
                if (kind.isProjectile()) {
                    dmShred.withNegative(PuffishAttributes.RANGED_RESISTANCE_SHRED, attacker);
                }
                if (kind.isMelee()) {
                    dmShred.withNegative(PuffishAttributes.MELEE_RESISTANCE_SHRED, attacker);
                }
            }
            resistance = Math.max(0.0f, dmShred.applyTo(resistance));
        }
        return Math.max(0.0f, damage.floatValue() - resistance);
    }
}

