/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.attributesmod.main;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IdMappingEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.attributesmod.util.Registrar;

@Mod(value="puffish_attributes")
public class ForgeMain {
    private final List<RegistryAlias<?>> registryAliases = new ArrayList();

    public ForgeMain() {
        AttributesMod.setup(new RegistrarImpl());
        MinecraftForge.EVENT_BUS.addListener(this::onIdMapping);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOW, this::onRegister);
    }

    private void onIdMapping(IdMappingEvent event) {
        this.registryAliases.forEach(RegistryAlias::apply);
    }

    private void onRegister(RegisterEvent event) {
        this.registryAliases.forEach(registryAlias -> registryAlias.applyFor(event.getVanillaRegistry()));
    }

    private class RegistrarImpl
    implements Registrar {
        private RegistrarImpl() {
        }

        @Override
        public <V, T extends V> void register(Registry<V> registry, ResourceLocation id, T entry) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registry.m_123023_(), (String)id.m_135827_());
            deferredRegister.register(id.m_135815_(), () -> entry);
            deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
        }

        @Override
        public <V> void registerAlias(Registry<V> registry, ResourceLocation aliasId, ResourceLocation id) {
            ForgeMain.this.registryAliases.add(new RegistryAlias<V>(registry, aliasId, id));
        }
    }

    private record RegistryAlias<V>(Registry<V> registry, ResourceLocation aliasId, ResourceLocation id) {
        public void applyFor(Registry<?> registry) {
            if (registry == this.registry) {
                this.apply();
            }
        }

        public void apply() {
            try {
                Class<?> namespacedWrapperClass = Class.forName("net.minecraftforge.registries.NamespacedWrapper");
                Class<ForgeRegistry> forgeRegistryClass = ForgeRegistry.class;
                Field delegateField = namespacedWrapperClass.getDeclaredField("delegate");
                delegateField.setAccessible(true);
                Field holdersByNameField = namespacedWrapperClass.getDeclaredField("holdersByName");
                holdersByNameField.setAccessible(true);
                ForgeRegistry delegate = (ForgeRegistry)delegateField.get(this.registry);
                boolean locked = delegate.isLocked();
                if (locked) {
                    delegate.unfreeze();
                }
                delegate.addAlias(this.aliasId, this.id);
                if (locked) {
                    delegate.freeze();
                }
                Map holdersByName = (Map)holdersByNameField.get(this.registry);
                holdersByName.put(this.aliasId, (Holder.Reference)holdersByName.get(this.id));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

