/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.vinery.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineConnectingBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<GeneralUtil.LineConnectingType> TYPE = GeneralUtil.LINE_CONNECTING_TYPE;

    public LineConnectingBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)GeneralUtil.LineConnectingType.NONE)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_().m_122424_();
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
        Level world = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        return switch (facing) {
            case Direction.EAST -> (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122019_()), world.m_8055_(clickedPos.m_122012_()))));
            case Direction.SOUTH -> (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122024_()), world.m_8055_(clickedPos.m_122029_()))));
            case Direction.WEST -> (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122012_()), world.m_8055_(clickedPos.m_122019_()))));
            default -> (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122029_()), world.m_8055_(clickedPos.m_122024_()))));
        };
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (!world.f_46443_) {
            GeneralUtil.LineConnectingType type;
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            switch (facing) {
                case EAST: {
                    GeneralUtil.LineConnectingType lineConnectingType = this.getType(state, world.m_8055_(pos.m_122019_()), world.m_8055_(pos.m_122012_()));
                    break;
                }
                case SOUTH: {
                    GeneralUtil.LineConnectingType lineConnectingType = this.getType(state, world.m_8055_(pos.m_122024_()), world.m_8055_(pos.m_122029_()));
                    break;
                }
                case WEST: {
                    GeneralUtil.LineConnectingType lineConnectingType = this.getType(state, world.m_8055_(pos.m_122012_()), world.m_8055_(pos.m_122019_()));
                    break;
                }
                default: {
                    GeneralUtil.LineConnectingType lineConnectingType = type = this.getType(state, world.m_8055_(pos.m_122029_()), world.m_8055_(pos.m_122024_()));
                }
            }
            if (state.m_61143_(TYPE) != type) {
                state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
            }
            world.m_7731_(pos, state, 3);
        }
    }

    public GeneralUtil.LineConnectingType getType(BlockState state, BlockState left, BlockState right) {
        boolean shapeRightSame;
        boolean shapeLeftSame = left.m_60734_() == state.m_60734_() && left.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
        boolean bl = shapeRightSame = right.m_60734_() == state.m_60734_() && right.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
        if (shapeLeftSame && shapeRightSame) {
            return GeneralUtil.LineConnectingType.MIDDLE;
        }
        if (shapeLeftSame) {
            return GeneralUtil.LineConnectingType.LEFT;
        }
        return shapeRightSame ? GeneralUtil.LineConnectingType.RIGHT : GeneralUtil.LineConnectingType.NONE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE});
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

