/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.vinery.client.gui.handler.FermentationBarrelGuiHandler;
import net.satisfy.vinery.core.Vinery;
import net.satisfy.vinery.platform.PlatformHelper;

@OnlyIn(value=Dist.CLIENT)
public class FermentationBarrelGui
extends AbstractContainerScreen<FermentationBarrelGuiHandler> {
    public static final ResourceLocation BACKGROUND = Vinery.identifier("textures/gui/fermentation_barrel_gui.png");
    private static final int FLUID_WIDTH = 20;
    private static final int FLUID_X = 82;
    private static final int FLUID_Y = 44;
    private static final int CRAFT_PROGRESS_TEXTURE_X = 176;
    private static final int CRAFT_PROGRESS_TEXTURE_Y = 0;
    private static final int CRAFT_PROGRESS_WIDTH = 11;
    private static final int CRAFT_PROGRESS_HEIGHT = 29;
    private static final int CRAFT_PROGRESS_GUI_X = 122;
    private static final int CRAFT_PROGRESS_GUI_Y = 20;
    private static final int CRAFT_PROGRESS_GUI_HEIGHT = 29;

    public FermentationBarrelGui(FermentationBarrelGuiHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.f_97728_ = 8;
        this.f_97729_ = 6;
        this.f_97730_ = 8;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        Component tooltip;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.isMouseOverFluidArea(mouseX, mouseY)) {
            tooltip = this.getFluidTooltip();
            guiGraphics.m_280557_(this.f_96547_, tooltip, mouseX, mouseY);
        }
        if (this.isMouseOverCraftingTimeArea(mouseX, mouseY)) {
            tooltip = this.getCraftingTimeTooltip();
            guiGraphics.m_280557_(this.f_96547_, tooltip, mouseX, mouseY);
        }
    }

    private Component getFluidTooltip() {
        String juiceType = ((FermentationBarrelGuiHandler)this.f_97732_).getJuiceType();
        int fluidLevel = ((FermentationBarrelGuiHandler)this.f_97732_).getFluidLevel();
        int maxFluidLevel = PlatformHelper.getMaxFluidLevel();
        double percentage = (double)fluidLevel / (double)maxFluidLevel * 100.0;
        String percentageStr = String.format("%.2f", percentage);
        if (juiceType.startsWith("red")) {
            String region = juiceType.substring(4);
            return Component.m_237110_((String)("tooltip.vinery.fermentation_barrel.red_" + region + "_juice_with_percentage"), (Object[])new Object[]{percentageStr});
        }
        if (juiceType.startsWith("white")) {
            String region = juiceType.substring(6);
            return Component.m_237110_((String)("tooltip.vinery.fermentation_barrel.white_" + region + "_juice_with_percentage"), (Object[])new Object[]{percentageStr});
        }
        if (juiceType.equals("apple")) {
            return Component.m_237110_((String)"tooltip.vinery.fermentation_barrel.apple_juice_with_percentage", (Object[])new Object[]{percentageStr});
        }
        return Component.m_237115_((String)"tooltip.vinery.fermentation_barrel.empty");
    }

    private Component getCraftingTimeTooltip() {
        int currentTicks;
        int totalTicks = ((FermentationBarrelGuiHandler)this.f_97732_).data.m_6413_(1);
        int remainingTicks = totalTicks - (currentTicks = ((FermentationBarrelGuiHandler)this.f_97732_).data.m_6413_(0));
        if (remainingTicks > 0) {
            int seconds = remainingTicks / 20;
            int minutes = seconds / 60;
            String formattedTime = String.format("%d:%02d Seconds", minutes, seconds %= 60);
            return Component.m_237110_((String)"tooltip.vinery.fermentation_barrel.crafting_time", (Object[])new Object[]{formattedTime});
        }
        return Component.m_237110_((String)"tooltip.vinery.fermentation_barrel.crafting_time", (Object[])new Object[]{"0:00 Seconds"});
    }

    private boolean isMouseOverFluidArea(int mouseX, int mouseY) {
        int fluidAreaLeft = this.f_97735_ + 82 - 1;
        int fluidAreaTop = this.f_97736_ + 44 - 5;
        int fluidAreaRight = this.f_97735_ + 82 + 20 + 1;
        int fluidAreaBottom = this.f_97736_ + 44 + 10;
        return mouseX >= fluidAreaLeft && mouseX <= fluidAreaRight && mouseY >= fluidAreaTop && mouseY <= fluidAreaBottom;
    }

    private boolean isMouseOverCraftingTimeArea(int mouseX, int mouseY) {
        int totalTicks = ((FermentationBarrelGuiHandler)this.f_97732_).data.m_6413_(1);
        int currentTicks = ((FermentationBarrelGuiHandler)this.f_97732_).data.m_6413_(0);
        if (totalTicks <= 0 || currentTicks >= totalTicks) {
            return false;
        }
        int craftingTimeAreaLeft = this.f_97735_ + 122;
        int craftingTimeAreaTop = this.f_97736_ + 20;
        int craftingTimeAreaRight = this.f_97735_ + 122 + 11;
        int craftingTimeAreaBottom = this.f_97736_ + 20 + 29;
        return mouseX >= craftingTimeAreaLeft && mouseX <= craftingTimeAreaRight && mouseY >= craftingTimeAreaTop && mouseY <= craftingTimeAreaBottom;
    }

    public static void drawJuiceBar(GuiGraphics guiGraphics, String juiceType, int juiceAmount, int originX, int originY) {
        int MAX_FLUID = PlatformHelper.getMaxFluidLevel();
        int scaledWidth = (int)((double)juiceAmount / (double)MAX_FLUID * 20.0);
        scaledWidth = Math.max(0, Math.min(20, scaledWidth));
        int TEXTURE_X_START = 176;
        int TEXTURE__START = juiceType.startsWith("red") ? 29 : (juiceType.startsWith("white") ? 33 : (juiceType.equals("apple") ? 37 : 0));
        guiGraphics.m_280218_(BACKGROUND, originX, originY, 176, TEXTURE__START, scaledWidth, 4);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        int x = this.f_97735_;
        int y = this.f_97736_;
        guiGraphics.m_280218_(BACKGROUND, x, y, 0, 0, this.f_97726_, this.f_97727_);
        FermentationBarrelGui.drawJuiceBar(guiGraphics, ((FermentationBarrelGuiHandler)this.f_97732_).getJuiceType(), ((FermentationBarrelGuiHandler)this.f_97732_).getFluidLevel(), x + 82, y + 44);
        this.renderCraftingProgress(guiGraphics, x, y);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280056_(this.f_96547_, this.f_96539_.getString(), this.f_97728_, this.f_97729_, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, this.f_169604_.getString(), this.f_97730_, this.f_97731_, 0x404040, false);
    }

    protected void renderCraftingProgress(GuiGraphics guiGraphics, int guiLeft, int guiTop) {
        int filledHeight = ((FermentationBarrelGuiHandler)this.f_97732_).getScaledProgress(29);
        int drawY = guiTop + 20 + (29 - filledHeight);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        guiGraphics.m_280218_(BACKGROUND, guiLeft + 122, drawY, 176, 0 + (29 - filledHeight), 11, filledHeight);
    }
}

