/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.mixin;

import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.world.RegionAwareTE;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RandomizableContainerBlockEntity.class})
public class LockableLootTileEntityMixin
implements RegionAwareTE {
    private boolean spawnedBoss = false;
    private WeakReference<ServerLevelAccessor> region = new WeakReference<Object>(null);

    @Inject(method={"setLootTable(Lnet/minecraft/resources/ResourceLocation;J)V"}, at={@At(value="RETURN")})
    private void onSetLoot(ResourceLocation lootTable, long seed, CallbackInfo ci) {
        ServerLevelAccessor world = (ServerLevelAccessor)this.region.get();
        if (world != null && !this.spawnedBoss) {
            this.spawnedBoss = true;
            BossSpawnHandler.onChestPlaced(world, (RandomizableContainerBlockEntity)this);
        }
        this.region.clear();
    }

    @Inject(method={"tryLoadLootTable"}, at={@At(value="RETURN")})
    private void onLoadLoot(CompoundTag p_184283_1_, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            ServerLevelAccessor world = (ServerLevelAccessor)this.region.get();
            if (world != null && !this.spawnedBoss) {
                this.spawnedBoss = true;
                BossSpawnHandler.onChestPlaced(world, (RandomizableContainerBlockEntity)this);
            }
            this.region.clear();
        }
    }

    @Override
    public void setRegion(ServerLevelAccessor region) {
        this.region = new WeakReference<ServerLevelAccessor>(region);
    }

    @Redirect(method={"setLootTable(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/resources/ResourceLocation;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/BlockGetter;getBlockEntity(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;"))
    private static BlockEntity setLootTable(BlockGetter reader, BlockPos pos) {
        BlockEntity te = reader.m_7702_(pos);
        if (te instanceof RegionAwareTE && reader instanceof ServerLevelAccessor) {
            ((RegionAwareTE)te).setRegion((ServerLevelAccessor)reader);
        }
        return te;
    }
}

