/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.event;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.config.CommonConfiguration;
import com.brutalbosses.entity.BossJsonListener;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.network.BossCapMessage;
import com.brutalbosses.network.BossOverlayMessage;
import com.brutalbosses.network.BossTypeSyncMessage;
import com.brutalbosses.network.Network;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;

public class EventHandler {
    public static Map<EntityType, Set<BossType>> randomSpawns = new HashMap<EntityType, Set<BossType>>();
    public static Map<BlockPos, UUID> protectedBlocks = new HashMap<BlockPos, UUID>();

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (protectedBlocks.containsKey(event.getPos())) {
            UUID uuid = protectedBlocks.get(event.getPos());
            Entity boss = ((ServerLevel)event.getLevel()).m_8791_(uuid);
            if (boss instanceof LivingEntity && boss.m_6084_()) {
                ((LivingEntity)boss).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 1200));
                if (boss instanceof Mob && ((Mob)boss).m_5448_() == null) {
                    ((Mob)boss).m_6710_((LivingEntity)event.getEntity());
                }
                ((ServerPlayer)event.getEntity()).m_240418_((Component)Component.m_237110_((String)"boss.chest.lock", (Object[])new Object[]{boss.m_5446_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                event.setCancellationResult(InteractionResult.FAIL);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void applyProjectileDamageBoost(LivingHurtEvent event) {
        BossCapability cap;
        if (event.getSource().m_7639_() instanceof Player && event.getEntity() instanceof Mob) {
            BossCapability cap2 = (BossCapability)event.getEntity().getCapability(BossCapability.BOSS_CAP).orElse(null);
            if (cap2 != null && cap2.isBoss()) {
                Network.instance.sendPacket((ServerPlayer)event.getSource().m_7639_(), new BossOverlayMessage(event.getEntity().m_19879_()));
            }
            return;
        }
        if (event.getSource().m_276093_(DamageTypes.f_268425_) && event.getSource().m_7639_() != null && (cap = (BossCapability)event.getSource().m_7639_().getCapability(BossCapability.BOSS_CAP).orElse(null)) != null && cap.isBoss()) {
            event.setAmount((float)((double)(event.getAmount() + cap.getBossType().getCustomAttributeValueOrDefault("projectile_damage_bonus", 0.0f)) * ((CommonConfiguration)BrutalBosses.config.getCommonConfig()).damageMultiplier));
        }
    }

    @SubscribeEvent
    public static void playerClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        if (!((CommonConfiguration)BrutalBosses.config.getCommonConfig()).printChestLoottable || event.getLevel().m_5776_()) {
            return;
        }
        BlockEntity te = event.getEntity().m_9236_().m_7702_(event.getPos());
        if (te instanceof RandomizableContainerBlockEntity && ((RandomizableContainerBlockEntity)te).f_59605_ != null) {
            event.getEntity().m_213846_((Component)Component.m_237113_((String)("[Loottable: " + ((RandomizableContainerBlockEntity)te).f_59605_ + "]")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ((RandomizableContainerBlockEntity)te).f_59605_.toString()))));
        }
    }

    @SubscribeEvent
    public static void onBossDeath(LivingDeathEvent event) {
        BossCapability cap;
        if (!event.getEntity().m_9236_().m_5776_() && event.getSource().m_7639_() instanceof ServerPlayer && (cap = (BossCapability)event.getEntity().getCapability(BossCapability.BOSS_CAP).orElse(null)) != null && cap.isBoss()) {
            int orbValue;
            for (int exp = cap.getBossType().getExperienceDrop(); exp > 0; exp -= orbValue) {
                orbValue = ExperienceOrb.m_20782_((int)exp);
                event.getEntity().m_9236_().m_7967_((Entity)new ExperienceOrb(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), orbValue));
            }
            int gearDropCount = Math.min(EquipmentSlot.values().length, (int)cap.getBossType().getCustomAttributeValueOrDefault("dropgear", 0.0f));
            for (int i = 0; i < gearDropCount; ++i) {
                ItemEntity itementity = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), event.getEntity().m_6844_(EquipmentSlot.values()[i]));
                event.getEntity().m_9236_().m_7967_((Entity)itementity);
            }
            if (cap.getLootTable() != null) {
                LootParams params = new LootParams.Builder((ServerLevel)event.getEntity().m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)event.getEntity().m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)event.getSource().m_7639_()).m_287239_(((ServerPlayer)event.getSource().m_7639_()).m_36336_()).m_287235_(LootContextParamSets.f_81411_);
                LootTable loottable = event.getEntity().m_9236_().m_7654_().m_278653_().m_278676_(cap.getLootTable());
                ObjectArrayList list = loottable.m_287195_(params);
                if (list.isEmpty()) {
                    return;
                }
                for (int i = 0; i < cap.getBossType().getItemLootCount(); ++i) {
                    ItemEntity itementity = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), (ItemStack)list.get(BrutalBosses.rand.nextInt(list.size())));
                    event.getEntity().m_9236_().m_7967_((Entity)itementity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        Entity entity = (Entity)evt.getObject();
        if (entity == null || entity.m_9236_() == null) {
            return;
        }
        if (entity.m_9236_().f_46443_ || BossTypeManager.instance.isValidBossEntity(entity)) {
            evt.addCapability(BossCapability.ID, (ICapabilityProvider)new BossCapability(entity));
        }
    }

    @SubscribeEvent
    public static void onAddReloadListenerEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)BossJsonListener.instance);
    }

    @SubscribeEvent
    public static void onTrack(PlayerEvent.StartTracking event) {
        BossCapability bossCapability;
        Entity entity = event.getTarget();
        Player Player2 = event.getEntity();
        if (Player2 instanceof ServerPlayer && (bossCapability = (BossCapability)entity.getCapability(BossCapability.BOSS_CAP).orElse(null)) != null && bossCapability.isBoss()) {
            Network.instance.sendPacket((ServerPlayer)Player2, new BossCapMessage(bossCapability));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> Network.instance.sendPacket((ServerPlayer)event.getEntity(), new BossTypeSyncMessage(BossTypeManager.instance.bosses.values())));
    }

    @SubscribeEvent
    public static void onEntityConversion(LivingConversionEvent.Pre event) {
        BossCapability bossCapability = (BossCapability)event.getEntity().getCapability(BossCapability.BOSS_CAP).orElse(null);
        if (bossCapability != null && bossCapability.isBoss()) {
            event.setCanceled(true);
            event.setConversionTimer(20);
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (randomSpawns.containsKey(event.getEntity().m_6095_())) {
            Set<BossType> list = randomSpawns.get(event.getEntity().m_6095_());
            for (BossType type : list) {
                if (!type.rollRandomSpawn()) continue;
                ((BossCapability)event.getEntity().getCapability(BossCapability.BOSS_CAP).orElse(null)).setBossType(type);
                type.initForEntity((LivingEntity)event.getEntity());
                if (!(event.getEntity() instanceof Mob)) break;
                event.getEntity().f_21353_ = false;
                break;
            }
        }
    }
}

