/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.data.PotionData;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class JumpAttackGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:jumpattack");
    private final Mob mob;
    private JumpAttackParams params;
    private LivingEntity target = null;
    private Vec3 end;
    private int animationTick = 0;
    private double distance = 10.0;
    private int ticksToNextUpdate = 0;
    private boolean isCharging = false;

    public JumpAttackGoal(Mob mob, IAIParams params) {
        this.params = (JumpAttackParams)params;
        this.mob = mob;
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void m_8041_() {
        this.target = null;
    }

    public void m_8037_() {
        Path path;
        if (--this.ticksToNextUpdate > 0) {
            this.mob.m_20260_(true);
            return;
        }
        double dist = Math.sqrt(this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_()));
        if (dist >= (double)this.params.minDistance && dist <= (double)this.params.maxDistance && !this.isCharging && this.mob.m_21574_().m_148306_((Entity)this.target) && (float)Math.abs(this.mob.m_146904_() - this.target.m_146904_()) < this.params.maxJumpHeight && (path = this.mob.m_21573_().m_26570_()) != null) {
            this.isCharging = true;
            this.end = this.target.m_20182_();
            this.distance = this.mob.m_20182_().m_82554_(this.end);
            this.animationTick = 0;
            this.mob.m_9236_().m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_11874_, this.mob.m_5720_(), 2.0f, 1.0f);
            this.mob.m_9236_().m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_11913_, this.mob.m_5720_(), 1.5f, 1.0f);
            this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100, 1));
            double d0 = -Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
            if (this.mob.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.mob.m_20185_() + d0, this.mob.m_20227_(0.5), this.mob.m_20189_() + d1, 30, d0, 0.0, d1, 0.0);
                ((ServerLevel)this.mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175827_, this.mob.m_20185_() + d0, this.mob.m_20227_(0.5), this.mob.m_20189_() + d1, 500, d0, 0.1, d1, 10.0);
            }
        }
        if (!this.isCharging) {
            return;
        }
        this.params.duration = 20;
        this.mob.m_21563_().m_148051_((Entity)this.target);
        this.mob.m_21563_().m_8128_();
        if ((double)this.animationTick <= (double)this.params.duration * 0.1) {
            double distanceModifier = this.distance / (double)this.params.duration;
            direction = this.end.m_82546_(this.mob.m_20182_()).m_82542_(1.0, 0.0, 1.0).m_82541_().m_82542_(distanceModifier, 1.0, distanceModifier);
            this.mob.m_20256_(direction);
            this.mob.m_20260_(true);
        } else if ((double)this.animationTick <= (double)this.params.duration * 0.1 + 4.0) {
            this.mob.m_6862_(true);
            this.mob.m_20260_(false);
            this.mob.m_21569_().m_24901_();
            double distanceModifier = this.distance / (double)this.params.duration;
            direction = this.end.m_82546_(this.mob.m_20182_()).m_82542_(1.0, 0.0, 1.0).m_82541_().m_82520_(0.0, 0.75, 0.0).m_82542_(distanceModifier, distanceModifier, distanceModifier);
            this.mob.m_20256_(direction);
        } else if (this.animationTick <= this.params.duration && this.mob.m_20182_().m_82554_(this.end) >= 2.0) {
            double distanceModifier = this.distance / (double)this.params.duration;
            direction = this.end.m_82546_(this.mob.m_20182_()).m_82542_(1.0, 1.0, 1.0).m_82541_().m_82542_(distanceModifier, distanceModifier, distanceModifier);
            this.mob.m_20256_(direction);
        }
        if (this.mob.m_20096_() && this.mob.m_20182_().m_82554_(this.end) < 2.0 || this.animationTick == this.params.duration) {
            this.isCharging = false;
            this.ticksToNextUpdate = (int)(this.params.interval + (float)(BrutalBosses.rand.nextInt(20) - 10));
            this.ticksToNextUpdate = 100;
            this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 3));
            this.mob.m_20256_(Vec3.f_82478_.m_82520_(0.0, -0.8, 0.0));
            this.mob.m_9236_().m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_11668_, this.mob.m_5720_(), 100.0f, 0.1f);
            this.mob.m_9236_().m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_12058_, this.mob.m_5720_(), 100.0f, 0.1f);
            double d0 = 3.0;
            double d1 = 3.0;
            if (this.mob.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.mob.m_20185_() + d0, this.mob.m_20186_(), this.mob.m_20189_() + d1, 300, d0, 0.0, d1, 0.0);
                ((ServerLevel)this.mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.mob.m_20185_() + d0, this.mob.m_20186_(), this.mob.m_20189_() + d1, 300, d0, 0.0, d1, 0.0);
                ((ServerLevel)this.mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123815_, this.mob.m_20185_() + d0, this.mob.m_20186_(), this.mob.m_20189_() + d1, 300, d0, 0.0, d1, 0.0);
                ((ServerLevel)this.mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123745_, this.mob.m_20185_() + d0, this.mob.m_20186_(), this.mob.m_20189_() + d1, 300, d0, 0.0, d1, 0.0);
            }
            if (this.mob.m_20270_((Entity)this.target) <= this.params.attackDistance) {
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                float damage = this.params.extraDamage;
                if (this.mob.m_21204_().m_22171_(Attributes.f_22281_)) {
                    damage = (float)((double)damage + this.mob.m_21133_(Attributes.f_22281_));
                }
                this.target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), damage);
            }
            for (PotionData potionData : this.params.potions) {
                AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.mob.m_9236_(), this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
                areaeffectcloudentity.m_19718_((LivingEntity)this.mob);
                areaeffectcloudentity.m_19724_((ParticleOptions)(potionData.particleType() instanceof ParticleOptions ? (ParticleOptions)potionData.particleType() : ParticleTypes.f_123745_));
                areaeffectcloudentity.m_19712_((float)this.params.potionRadius);
                areaeffectcloudentity.m_19734_(200);
                areaeffectcloudentity.m_19716_(new MobEffectInstance(potionData.effect(), potionData.duration(), potionData.amplifier()));
                this.mob.m_9236_().m_7967_((Entity)areaeffectcloudentity);
            }
        } else if (this.mob.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.mob.m_20185_(), this.mob.m_20227_(0.5), this.mob.m_20189_(), 10, 0.1, 0.0, 0.1, 0.05);
        }
        ++this.animationTick;
    }

    public static class JumpAttackParams
    extends IAIParams.DefaultParams {
        private float maxDistance = 15.0f;
        private float minDistance = 3.0f;
        private float maxJumpHeight = 4.0f;
        private int duration = 10;
        private float interval = 200.0f;
        private float extraDamage = 2.0f;
        private float attackDistance = 4.0f;
        private List<PotionData> potions = new ArrayList<PotionData>();
        private int potionRadius = 5;
        private static final String ATKDIST = "attackdist";
        private static final String MAXHEIGHT = "maxheight";
        private static final String EXTDMG = "extradamage";
        public static final String MINDIST = "mindist";
        public static final String MAXDIST = "maxdist";
        public static final String DURATION = "duration";
        public static final String COOLDOWN = "interval";
        public static final String POTIONS = "potions";
        public static final String POTIONRADIUS = "potionradius";
        public static final String POTIONDURATION = "duration";
        public static final String POTIONAMPLIFIER = "amplifier";
        public static final String POTIONPARTICLE = "particle";

        public JumpAttackParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ATKDIST)) {
                this.attackDistance = jsonElement.get(ATKDIST).getAsFloat();
            }
            if (jsonElement.has(EXTDMG)) {
                this.extraDamage = jsonElement.get(EXTDMG).getAsFloat();
            }
            if (jsonElement.has(MINDIST)) {
                this.minDistance = jsonElement.get(MINDIST).getAsFloat();
            }
            if (jsonElement.has(MAXDIST)) {
                this.maxDistance = jsonElement.get(MAXDIST).getAsFloat();
            }
            if (jsonElement.has("duration")) {
                this.duration = jsonElement.get("duration").getAsInt();
            }
            if (jsonElement.has(POTIONRADIUS)) {
                this.potionRadius = jsonElement.get(POTIONRADIUS).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.interval = jsonElement.get(COOLDOWN).getAsFloat();
            }
            if (jsonElement.has(MAXHEIGHT)) {
                this.maxJumpHeight = jsonElement.get(MAXHEIGHT).getAsFloat();
            }
            if (jsonElement.has(POTIONS)) {
                this.potions = new ArrayList<PotionData>();
                for (Map.Entry data : jsonElement.get(POTIONS).getAsJsonObject().entrySet()) {
                    JsonObject potionData = ((JsonElement)data.getValue()).getAsJsonObject();
                    ParticleType particleType = null;
                    if (potionData.has(POTIONPARTICLE)) {
                        particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(ResourceLocation.m_135820_((String)potionData.get(POTIONPARTICLE).getAsString()));
                    }
                    this.potions.add(new PotionData((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)((String)data.getKey()))), potionData.get("duration").getAsInt(), potionData.get(POTIONAMPLIFIER).getAsInt(), particleType));
                }
            }
            return this;
        }
    }
}

