/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.integration.thief;

import io.github.mortuusars.monobank.config.Configuration;
import io.github.mortuusars.monobank.content.monobank.MonobankBlockEntity;
import io.github.mortuusars.monobank.integration.thief.ThiefCrime;
import io.github.mortuusars.thief.world.Crime;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class ThiefIntegration {
    public static void unlockingGuiOpened(ServerPlayer player, MonobankBlockEntity blockEntity) {
        ThiefIntegration.convertCrime((ThiefCrime)((Object)Configuration.THIEF_CRIME_FOR_UNLOCKING_ATTEMPT.get())).ifPresent(crime -> crime.commit(player.m_284548_(), (LivingEntity)player, blockEntity.m_58899_()));
    }

    public static void unlocked(ServerPlayer player, MonobankBlockEntity blockEntity) {
        ThiefIntegration.convertCrime((ThiefCrime)((Object)Configuration.THIEF_CRIME_FOR_UNLOCKING.get())).ifPresent(crime -> crime.commit(player.m_284548_(), (LivingEntity)player, blockEntity.m_58899_()));
    }

    public static void opened(ServerPlayer player, MonobankBlockEntity blockEntity) {
        ThiefIntegration.convertCrime((ThiefCrime)((Object)Configuration.THIEF_CRIME_FOR_OPENING.get())).ifPresent(crime -> crime.commit(player.m_284548_(), (LivingEntity)player, blockEntity.m_58899_()));
    }

    public static Optional<Crime> convertCrime(ThiefCrime crime) {
        return switch (crime) {
            default -> throw new IncompatibleClassChangeError();
            case ThiefCrime.NONE -> Optional.empty();
            case ThiefCrime.LIGHT -> Optional.of(Crime.LIGHT);
            case ThiefCrime.MEDIUM -> Optional.of(Crime.MEDIUM);
            case ThiefCrime.HEAVY -> Optional.of(Crime.HEAVY);
        };
    }
}

