/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.content.monobank;

import io.github.mortuusars.monobank.Monobank;
import io.github.mortuusars.monobank.client.gui.component.CombinationTooltip;
import io.github.mortuusars.monobank.client.gui.screen.PatchedAbstractContainerScreen;
import io.github.mortuusars.monobank.content.monobank.MonobankBlockEntity;
import io.github.mortuusars.monobank.content.monobank.MonobankMenu;
import io.github.mortuusars.monobank.core.inventory.BigItemHandlerSlot;
import io.github.mortuusars.monobank.util.TextUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MonobankScreen
extends PatchedAbstractContainerScreen<MonobankMenu> {
    public static final ResourceLocation TEXTURE = Monobank.resource("textures/gui/monobank.png");
    private final Component CTRL_TOOLTIP = TextUtil.translate("gui.monobank.tooltip.ctrl_take_single", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY);
    private final Component CTRL_SHIFT_TOOLTIP = TextUtil.translate("gui.monobank.tooltip.ctrl_shift_take_single", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY);
    private final Component OWNER_TOOLTIP = TextUtil.translate("gui.monobank.tooltip.owner", new Object[0]);
    private final Component BREAK_IN_ATTEMPTED_TOOLTIP = TextUtil.translate("gui.monobank.tooltip.break_in_attempted", new Object[0]);
    private final Component BREAK_IN_SUCCEEDED_TOOLTIP = TextUtil.translate("gui.monobank.tooltip.break_in_succeeded", new Object[0]);
    private final MonobankBlockEntity blockEntity;
    private Optional<TooltipComponent> combinationTooltip = Optional.empty();

    public MonobankScreen(MonobankMenu containerMenu, Inventory playerinventory, Component title) {
        super(containerMenu, playerinventory, title);
        this.blockEntity = containerMenu.getBlockEntity();
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    protected void m_6597_(@NotNull Slot pSlot, int pSlotId, int pMouseButton, @NotNull ClickType pType) {
        if (pSlotId == 0 && pMouseButton == 0) {
            if (pType == ClickType.PICKUP_ALL) {
                return;
            }
            if (Screen.m_96637_() && Screen.m_96638_()) {
                pMouseButton = -102;
                pType = ClickType.QUICK_MOVE;
            } else if (Screen.m_96637_()) {
                pMouseButton = -101;
                pType = ClickType.QUICK_MOVE;
            }
        }
        super.m_6597_(pSlot, pSlotId, pMouseButton, pType);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((MonobankMenu)this.m_6262_()).extraInfo.isOwner) {
            graphics.m_280218_(TEXTURE, this.getGuiLeft() + 161, this.getGuiTop() + 3, 176, 0, 12, 12);
            if (((MonobankMenu)this.m_6262_()).extraInfo.hasWarning()) {
                if (((MonobankMenu)this.m_6262_()).extraInfo.breakInSucceeded) {
                    if (this.f_96541_.f_91073_.m_46467_() % 10L > 5L) {
                        graphics.m_280218_(TEXTURE, this.getGuiLeft() + 151, this.getGuiTop() + 38, 188, 0, 10, 10);
                    }
                } else if (((MonobankMenu)this.m_6262_()).extraInfo.breakInAttempted && this.f_96541_.f_91073_.m_46467_() % 26L > 12L) {
                    graphics.m_280218_(TEXTURE, this.getGuiLeft() + 151, this.getGuiTop() + 38, 188, 0, 10, 10);
                }
            }
        }
    }

    protected void m_280072_(@NotNull GuiGraphics graphics, int x, int y) {
        BigItemHandlerSlot bankSlot;
        Slot slot;
        if (((MonobankMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && (slot = this.f_97734_) instanceof BigItemHandlerSlot && (bankSlot = (BigItemHandlerSlot)slot).m_6657_()) {
            this.renderBankSlotTooltip(bankSlot.m_7993_(), graphics, x, y);
        } else if (((MonobankMenu)this.m_6262_()).extraInfo.isOwner && this.m_6774_(161, 3, 12, 12, x, y)) {
            if (this.combinationTooltip.isEmpty() && !this.blockEntity.getLock().getCombination().isEmpty()) {
                this.combinationTooltip = Optional.of(new CombinationTooltip(this.blockEntity.getLock().getCombination()));
            }
            graphics.m_280677_(this.f_96547_, List.of(this.OWNER_TOOLTIP), this.combinationTooltip, x, y);
        } else if (((MonobankMenu)this.m_6262_()).extraInfo.isOwner && ((MonobankMenu)this.m_6262_()).extraInfo.hasWarning() && this.m_6774_(151, 38, 10, 10, x, y)) {
            if (((MonobankMenu)this.m_6262_()).extraInfo.breakInSucceeded) {
                graphics.m_280557_(this.f_96547_, this.BREAK_IN_SUCCEEDED_TOOLTIP, x, y);
            } else if (((MonobankMenu)this.m_6262_()).extraInfo.breakInAttempted) {
                graphics.m_280557_(this.f_96547_, this.BREAK_IN_ATTEMPTED_TOOLTIP, x, y);
            }
        } else {
            super.m_280072_(graphics, x, y);
        }
    }

    @Override
    protected String getCountStringForSlot(Slot slot, ItemStack itemStack, @Nullable String countString) {
        if (slot instanceof BigItemHandlerSlot && !itemStack.m_41619_()) {
            return TextUtil.shortenNumber(itemStack.m_41613_());
        }
        return super.getCountStringForSlot(slot, itemStack, countString);
    }

    protected void renderBankSlotTooltip(ItemStack itemStack, GuiGraphics graphics, int x, int y) {
        List tooltip = MonobankScreen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)itemStack);
        int stackCount = itemStack.m_41613_();
        if (stackCount > 1000) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setGroupingSeparator(' ');
            DecimalFormat numberFormatter = new DecimalFormat("###,###,###", symbols);
            String formattedCount = numberFormatter.format(stackCount);
            MutableComponent newTitle = ((Component)tooltip.get(0)).m_6881_().m_7220_((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)TextUtil.translate("gui.monobank.count", formattedCount).m_130940_(ChatFormatting.GRAY));
            tooltip.set(0, newTitle);
        }
        tooltip.add(this.CTRL_TOOLTIP);
        tooltip.add(this.CTRL_SHIFT_TOOLTIP);
        graphics.renderTooltip(this.f_96547_, tooltip, Optional.empty(), itemStack, x, y);
    }
}

