/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.content.monobank;

import io.github.mortuusars.monobank.Registry;
import io.github.mortuusars.monobank.content.monobank.MonobankBlockEntity;
import io.github.mortuusars.monobank.content.monobank.component.MonobankExtraInfo;
import io.github.mortuusars.monobank.core.inventory.BigItemHandlerSlot;
import io.github.mortuusars.monobank.core.inventory.MonobankItemStackHandler;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MonobankMenu
extends AbstractContainerMenu {
    public static final int MONOBANK_SLOT_INDEX = 0;
    public static final int MONOBANK_SLOT_X = 71;
    public static final int MONOBANK_SLOT_Y = 26;
    public static final int MONOBANK_SLOT_SIZE = 34;
    public static final int TRANSFER_SINGLE_BUTTON_ID = -101;
    public static final int TRANSFER_ALL_BUTTON_ID = -102;
    public final MonobankBlockEntity blockEntity;
    private final ContainerLevelAccess canInteractWithCallable;
    public MonobankExtraInfo extraInfo;
    protected final Level level;

    public MonobankMenu(int containerID, Inventory playerInventory, MonobankBlockEntity blockEntity, MonobankExtraInfo extraInfo) {
        super((MenuType)Registry.MenuTypes.MONOBANK.get(), containerID);
        this.blockEntity = blockEntity;
        this.level = playerInventory.f_35978_.m_9236_();
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        this.extraInfo = extraInfo;
        blockEntity.startOpen(playerInventory.f_35978_);
        blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> this.m_38897_((Slot)new BigItemHandlerSlot((MonobankItemStackHandler)itemHandler, 0, 71, 26, 34, 34)));
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    public static MonobankMenu fromBuffer(int containerID, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new MonobankMenu(containerID, playerInventory, MonobankMenu.getBlockEntity(playerInventory, buffer), MonobankExtraInfo.fromBuffer(buffer));
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().f_46443_) {
            this.blockEntity.stopOpen(player);
        }
    }

    public MonobankBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public void m_150399_(int slotId, int button, ClickType clickType, Player player) {
        if (clickType != ClickType.QUICK_MOVE) {
            super.m_150399_(slotId, button, clickType, player);
            return;
        }
        IItemHandler itemHandler = (IItemHandler)this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (itemHandler == null) {
            return;
        }
        if (button == -101) {
            ItemStack extractedItem = itemHandler.extractItem(0, 1, false);
            if (!player.m_36356_(extractedItem)) {
                itemHandler.insertItem(0, extractedItem, false);
            }
        } else if (button == -102) {
            ItemStack extractedStack;
            while (!(extractedStack = itemHandler.extractItem(0, this.blockEntity.getStoredItemStack().m_41741_(), false)).m_41619_()) {
                player.m_36356_(extractedStack);
                if (extractedStack.m_41619_()) continue;
                itemHandler.insertItem(0, extractedStack, false);
                break;
            }
        } else {
            super.m_150399_(slotId, button, clickType, player);
        }
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        Slot clickedSlot = (Slot)this.f_38839_.get(pIndex);
        if (clickedSlot == null || !clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack clickedSlotItemStack = clickedSlot.m_7993_();
        if (pIndex == 0) {
            ItemStack removedStack = clickedSlot.m_6201_(clickedSlotItemStack.m_41741_());
            this.m_38903_(removedStack, 1, this.f_38839_.size(), false);
            if (!removedStack.m_41619_()) {
                clickedSlot.m_150659_(removedStack);
            }
        } else {
            ItemStack remainder;
            Slot monobankSlot = (Slot)this.f_38839_.get(0);
            if (!(monobankSlot.m_6657_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)monobankSlot.m_7993_(), (ItemStack)clickedSlotItemStack) || (remainder = monobankSlot.m_150659_(clickedSlotItemStack)).m_41619_())) {
                clickedSlot.m_150659_(remainder);
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return !this.blockEntity.getLock().isLocked() && MonobankMenu.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)player, (Block)((Block)Registry.Blocks.MONOBANK.get()));
    }

    private static MonobankBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockEntityAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (blockEntityAtPos instanceof MonobankBlockEntity) {
            MonobankBlockEntity monobankBlockEntity = (MonobankBlockEntity)blockEntityAtPos;
            return monobankBlockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + blockEntityAtPos);
    }
}

