/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.content.monobank;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.monobank.Monobank;
import io.github.mortuusars.monobank.Registry;
import io.github.mortuusars.monobank.config.Configuration;
import io.github.mortuusars.monobank.content.monobank.MonobankBlock;
import io.github.mortuusars.monobank.content.monobank.MonobankMenu;
import io.github.mortuusars.monobank.content.monobank.component.DoorOpennessController;
import io.github.mortuusars.monobank.content.monobank.component.Lock;
import io.github.mortuusars.monobank.content.monobank.component.MonobankExtraInfo;
import io.github.mortuusars.monobank.content.monobank.component.MonobankOpenersCounter;
import io.github.mortuusars.monobank.content.monobank.component.Owner;
import io.github.mortuusars.monobank.content.monobank.unlocking.Combination;
import io.github.mortuusars.monobank.content.monobank.unlocking.UnlockingMenu;
import io.github.mortuusars.monobank.core.base.SyncedBlockEntity;
import io.github.mortuusars.monobank.core.inventory.MonobankItemStackHandler;
import io.github.mortuusars.monobank.integration.Mods;
import io.github.mortuusars.monobank.integration.thief.ThiefIntegration;
import io.github.mortuusars.monobank.util.TextUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MonobankBlockEntity
extends SyncedBlockEntity
implements Nameable,
LidBlockEntity {
    public static final String INVENTORY_TAG = "Inventory";
    public static final String LOCK_TAG = "Lock";
    public static final String OWNER_TAG = "Owner";
    public static final String CUSTOM_NAME_TAG = "CustomName";
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    public static final String BREAK_IN_SUCCEEDED_TAG = "BreakInSucceeded";
    public static final String BREAK_IN_ATTEMPTED_TAG = "BreakInAttempted";
    public static final String WARNINGS_SEEN_COUNT_TAG = "WarningsSeenCount";
    private static final int UPDATE_DOOR_EVENT_ID = 1;
    private final MenuProvider OPEN_MENU_PROVIDER = new MenuProvider(){

        public Component m_5446_() {
            return MonobankBlockEntity.this.m_7755_();
        }

        @NotNull
        public AbstractContainerMenu m_7208_(int containerID, Inventory playerInventory, Player player) {
            return new MonobankMenu(containerID, playerInventory, MonobankBlockEntity.this, MonobankBlockEntity.this.getExtraInfo(player));
        }
    };
    private final MenuProvider UNLOCKING_MENU_PROVIDER = new MenuProvider(){

        public Component m_5446_() {
            return TextUtil.translate("gui.monobank.unlocking", MonobankBlockEntity.this.m_7755_());
        }

        @NotNull
        public AbstractContainerMenu m_7208_(int containerID, Inventory playerInventory, Player player) {
            return new UnlockingMenu(containerID, playerInventory, MonobankBlockEntity.this, MonobankBlockEntity.this.lock.getCombination());
        }
    };
    private final ContainerOpenersCounter openersCounter = new MonobankOpenersCounter(this);
    private final DoorOpennessController doorOpennessController = new DoorOpennessController(0.5f, 0.35f, 0.6f, 0.65f, 0.36f);
    private final MonobankItemStackHandler inventory = new MonobankItemStackHandler(slot -> this.inventoryChanged(), 1);
    private final LazyOptional<IItemHandler> inventoryHandler = LazyOptional.of(() -> this.inventory);
    @Nullable
    protected ResourceLocation lootTable;
    protected long lootTableSeed;
    private final Lock lock = new Lock(this.m_58899_(), this::onLockedChanged, this::onLockInventoryChanged, () -> ((MonobankBlockEntity)this).m_58904_());
    private Owner owner = Owner.none();
    private Component customName;
    public boolean breakInAttempted;
    public boolean breakInSucceeded;
    protected int warningsSeenCount;
    private float fullness = -1.0f;
    private boolean isUnlocking = false;
    private int unlockingCountdown = 0;
    private int unlockingCountdownMax = 0;

    public MonobankBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Registry.BlockEntityTypes.MONOBANK.get(), pPos, pBlockState);
    }

    public static void appendHoverText(ItemStack stack, BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag blockEntityTag;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_("BlockEntityTag", 10) && (blockEntityTag = tag.m_128469_("BlockEntityTag")).m_128425_(LOCK_TAG, 10)) {
            CompoundTag lockTag = blockEntityTag.m_128469_(LOCK_TAG);
            boolean locked = lockTag.m_128471_("Locked");
            if (locked) {
                tooltip.add((Component)TextUtil.translate("tooltip.locked", new Object[0]).m_130940_(ChatFormatting.GRAY));
            }
            if (blockEntityTag.m_128425_(LOOT_TABLE_TAG, 8)) {
                String lootTable = blockEntityTag.m_128461_(LOOT_TABLE_TAG);
                tooltip.add((Component)TextUtil.translate("tooltip.loot_table", lootTable).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (lockTag.m_128425_("CombinationTable", 8)) {
                tooltip.add((Component)TextUtil.translate("tooltip.combination_table", lockTag.m_128461_("CombinationTable")).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public Lock getLock() {
        return this.lock;
    }

    public boolean replaceLock(Player player, Combination combination) {
        if (!((Boolean)Configuration.CAN_REPLACE_OTHER_PLAYERS_LOCKS.get()).booleanValue() && this.getOwner().isPlayerOwned() && !this.getOwner().isOwnedBy(player)) {
            LogUtils.getLogger().error("Tried to replace lock in other player owned Monobank. (without enabling in config). Lock will not be replaced.");
            return false;
        }
        this.getLock().setCombination(combination);
        this.setOwner(player);
        this.playSoundAtDoor((SoundEvent)Registry.Sounds.MONOBANK_CLICK.get());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Registry.Advancements.MONOBANK_LOCK_REPLACED.trigger(serverPlayer);
        }
        return true;
    }

    public boolean isUnlocking() {
        return this.isUnlocking;
    }

    public void startUnlocking() {
        this.startUnlocking(Objects.requireNonNull(this.m_58904_()).m_213780_().m_216339_(20, 61));
    }

    public void startUnlocking(int ticks) {
        if (!this.isUnlocking()) {
            assert (this.f_58857_ != null);
            List players = this.f_58857_.m_6907_();
            for (Player player : players) {
                ServerPlayer serverPlayer;
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (!(abstractContainerMenu instanceof UnlockingMenu)) continue;
                UnlockingMenu unlockingMenu = (UnlockingMenu)abstractContainerMenu;
                if (unlockingMenu.monobankEntity != this) continue;
                if (Mods.THIEF.isLoaded() && player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    ThiefIntegration.unlocked(serverPlayer, this);
                }
                if (this.getOwner().isPlayerOwned() && !this.getOwner().isOwnedBy(player)) {
                    this.breakInSucceeded = true;
                    this.m_6596_();
                }
                if (!(player instanceof ServerPlayer)) continue;
                serverPlayer = (ServerPlayer)player;
                Registry.Advancements.MONOBANK_UNLOCKED.trigger(serverPlayer);
            }
            this.isUnlocking = true;
            this.unlockingCountdown = ticks;
            this.unlockingCountdownMax = ticks;
        }
    }

    private void onLockedChanged() {
        boolean isLocked = this.lock.isLocked();
        this.doorOpennessController.setLocked(isLocked);
        this.unlockingCountdown = -1;
        this.isUnlocking = false;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            SoundEvent sound = isLocked ? (SoundEvent)Registry.Sounds.MONOBANK_LOCK.get() : (SoundEvent)Registry.Sounds.MONOBANK_UNLOCK.get();
            MonobankBlockEntity.playSoundAtDoor(this.f_58857_, this.f_58858_, this.m_58900_(), sound, 1.0f);
        }
        this.m_6596_();
    }

    private void onLockInventoryChanged(Integer slot) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return;
        }
        Combination combination = this.getLock().getCombination();
        if (combination.matches(slot, this.getLock().getInventory().getStackInSlot(slot.intValue()).m_41720_())) {
            this.playSoundAtDoor((SoundEvent)Registry.Sounds.MONOBANK_CLICK.get());
        }
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getLock().getInventory().getSlots(); ++i) {
            keys.add(this.getLock().getInventory().getStackInSlot(i));
        }
        if (combination.matches(keys.stream().map(ItemStack::m_41720_).collect(Collectors.toList()))) {
            this.startUnlocking();
            this.dropItemsAtDoor(keys);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.trySaveLootTable(tag)) {
            tag.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
        }
        tag.m_128365_(LOCK_TAG, (Tag)this.lock.serializeNBT());
        if (this.owner.getType() != Owner.Type.NONE) {
            tag.m_128365_(OWNER_TAG, (Tag)this.owner.serializeNBT());
        }
        if (this.customName != null) {
            tag.m_128359_(CUSTOM_NAME_TAG, Component.Serializer.m_130703_((Component)this.customName));
        }
        if (this.getOwner().isPlayerOwned()) {
            if (this.warningsSeenCount > 0) {
                tag.m_128405_(WARNINGS_SEEN_COUNT_TAG, this.warningsSeenCount);
            }
            if (this.breakInAttempted) {
                tag.m_128379_(BREAK_IN_ATTEMPTED_TAG, true);
            }
            if (this.breakInSucceeded) {
                tag.m_128379_(BREAK_IN_SUCCEEDED_TAG, true);
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (!this.tryLoadLootTable(tag)) {
            this.inventory.deserializeNBT(tag.m_128469_(INVENTORY_TAG));
        }
        this.lock.deserializeNBT(tag.m_128469_(LOCK_TAG));
        if (tag.m_128425_(OWNER_TAG, 10)) {
            this.owner.deserializeNBT(tag.m_128469_(OWNER_TAG));
        }
        if (tag.m_128425_(CUSTOM_NAME_TAG, 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_(CUSTOM_NAME_TAG));
        }
        this.breakInSucceeded = tag.m_128471_(BREAK_IN_SUCCEEDED_TAG);
        this.breakInAttempted = tag.m_128471_(BREAK_IN_ATTEMPTED_TAG);
        this.warningsSeenCount = tag.m_128451_(WARNINGS_SEEN_COUNT_TAG);
        this.updateFullness();
        this.doorOpennessController.setLocked(this.lock.isLocked());
    }

    protected boolean tryLoadLootTable(CompoundTag tag) {
        if (tag.m_128425_(LOOT_TABLE_TAG, 8)) {
            this.lootTable = new ResourceLocation(tag.m_128461_(LOOT_TABLE_TAG));
            this.lootTableSeed = tag.m_128454_(LOOT_TABLE_SEED_TAG);
            return true;
        }
        return false;
    }

    protected boolean trySaveLootTable(CompoundTag tag) {
        if (this.lootTable == null) {
            return false;
        }
        tag.m_128359_(LOOT_TABLE_TAG, this.lootTable.toString());
        if (this.lootTableSeed != 0L) {
            tag.m_128356_(LOOT_TABLE_SEED_TAG, this.lootTableSeed);
        }
        return true;
    }

    public void unpackLootTable(@Nullable Player player, boolean includeCombination) {
        if (includeCombination) {
            this.getLock().tryUnpackCombinationTable();
        }
        if (this.lootTable != null && this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            ObjectArrayList randomItems;
            if (!this.inventory.getStackInSlot(0).m_41619_()) {
                LogUtils.getLogger().warn("Tried to unpack Loot Table while Monobank is not empty. Loot Table will not be unpacked.");
                return;
            }
            LootTable loottable = this.f_58857_.m_7654_().m_278653_().m_278676_(this.lootTable);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)player, this.lootTable);
            }
            this.lootTable = null;
            LootParams.Builder lootParams = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_));
            if (player != null) {
                lootParams.m_287239_(player.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)player);
            }
            if (!(randomItems = loottable.m_287214_(lootParams.m_287235_(LootContextParamSets.f_81411_), this.lootTableSeed)).isEmpty()) {
                this.inventory.setStackInSlot(0, (ItemStack)randomItems.get(0));
            }
        }
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
        this.m_6596_();
    }

    public void setOwner(Player player) {
        this.setOwner(new Owner(player));
    }

    public void onSetPlacedBy(LivingEntity placer, ItemStack stack) {
        if (!placer.m_9236_().f_46443_ && placer instanceof Player) {
            Player player = (Player)placer;
            if (this.owner.getType() == Owner.Type.NONE) {
                this.setOwner(player);
            }
            if (!this.getLock().hasCombinationOrCombinationTable()) {
                this.getLock().setCombinationTable(Monobank.resource("combination/default"));
            }
            this.m_6596_();
        }
    }

    public void openUnlockingGui(ServerPlayer player) {
        if (!this.lock.isLocked()) {
            return;
        }
        if (Mods.THIEF.isLoaded()) {
            ThiefIntegration.unlockingGuiOpened(player, this);
        }
        if (this.getLock().getCombination().isEmpty()) {
            this.startUnlocking();
        } else {
            if (this.getOwner().isPlayerOwned() && !this.getOwner().isOwnedBy((Player)player)) {
                this.breakInAttempted = true;
                this.m_6596_();
            }
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)this.UNLOCKING_MENU_PROVIDER, buffer -> {
                buffer.m_130064_(this.f_58858_);
                this.lock.getCombination().toBuffer((FriendlyByteBuf)buffer);
            });
        }
    }

    public void open(ServerPlayer player) {
        if (Mods.THIEF.isLoaded()) {
            ThiefIntegration.opened(player, this);
        }
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)this.OPEN_MENU_PROVIDER, buffer -> {
            buffer.m_130064_(this.f_58858_);
            this.getExtraInfo((Player)player).toBuffer((FriendlyByteBuf)buffer);
        });
    }

    public IItemHandler getUnlockingInventoryHandler() {
        return this.lock.getInventory();
    }

    public float getFullness() {
        return this.fullness;
    }

    public void updateFullness() {
        this.fullness = Mth.m_14036_((float)((float)this.getStoredItemStack().m_41613_() / (float)Monobank.getSlotCapacity()), (float)0.0f, (float)1.0f);
    }

    public ItemStack getStoredItemStack() {
        return this.inventory.getStackInSlot(0);
    }

    public MonobankExtraInfo getExtraInfo(Player player) {
        return new MonobankExtraInfo(this.getOwner().isOwnedBy(player), this.breakInAttempted, this.breakInSucceeded);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (this.f_58859_ || this.getLock().isLocked()) {
            return super.getCapability(capability, side);
        }
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            this.unpackLootTable(null, false);
            return this.inventoryHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inventoryHandler.invalidate();
    }

    public void inventoryChanged() {
        ServerPlayer player;
        this.updateFullness();
        this.m_6596_();
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_ && this.getOwner().isPlayerOwned() && (player = Objects.requireNonNull(this.f_58857_.m_7654_()).m_6846_().m_11259_(this.getOwner().getUuid())) != null) {
            Registry.Advancements.MONOBANK_INVENTORY_CHANGED.trigger(player, this.getStoredItemStack());
        }
    }

    public boolean m_7531_(int id, int param) {
        if (id == 1) {
            this.doorOpennessController.shouldBeOpen(param > 0);
            return true;
        }
        return super.m_7531_(id, param);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, T blockEntity) {
        if (blockEntity instanceof MonobankBlockEntity) {
            MonobankBlockEntity monobankEntity = (MonobankBlockEntity)blockEntity;
            monobankEntity.doorOpennessController.tickDoor();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, T blockEntity) {
        if (blockEntity instanceof MonobankBlockEntity) {
            MonobankBlockEntity monobankEntity = (MonobankBlockEntity)blockEntity;
            if (!monobankEntity.getLock().isLocked()) {
                monobankEntity.unpackLootTable(null, false);
            }
            if (monobankEntity.unlockingCountdown > 0) {
                int current;
                int max = (int)Math.ceil(Math.log(monobankEntity.unlockingCountdownMax)) + 1;
                int freq = max - (current = (int)Math.ceil(Math.log(monobankEntity.unlockingCountdown)));
                if (monobankEntity.unlockingCountdown % freq == 0) {
                    MonobankBlockEntity.playSoundAtDoor(monobankEntity.m_58904_(), monobankEntity.m_58899_(), monobankEntity.m_58900_(), (SoundEvent)Registry.Sounds.MONOBANK_CLICK.get(), 0.5f);
                }
                --monobankEntity.unlockingCountdown;
            } else if (monobankEntity.isUnlocking() && monobankEntity.unlockingCountdown <= 0) {
                monobankEntity.getLock().setLocked(false);
            }
        }
    }

    public void startOpen(Player player) {
        if (this.f_58857_ != null && !this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (this.f_58857_ != null && !this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
            if (this.getOwner().isOwnedBy(player)) {
                if (this.breakInAttempted || this.breakInSucceeded) {
                    ++this.warningsSeenCount;
                }
                if (this.warningsSeenCount >= 3) {
                    this.breakInAttempted = false;
                    this.breakInSucceeded = false;
                    this.warningsSeenCount = 0;
                }
            }
        }
    }

    public void recheckOpen() {
        if (this.f_58857_ != null && !this.f_58859_) {
            this.openersCounter.m_155476_(this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public float m_6683_(float partialTicks) {
        return this.doorOpennessController.getOpenness(partialTicks);
    }

    @NotNull
    public Component m_5446_() {
        return this.m_7755_();
    }

    @NotNull
    public Component m_7755_() {
        return this.customName != null ? this.customName : TextUtil.translate("gui.monobank", new Object[0]);
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public void dropItemsAtDoor(List<ItemStack> items) {
        Vec3i facingNormal = ((Direction)this.m_58900_().m_61143_((Property)MonobankBlock.FACING)).m_122436_();
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)facingNormal.m_123341_() * 0.6;
        double y = (double)this.f_58858_.m_123342_() + 0.5;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)facingNormal.m_123343_() * 0.6;
        for (ItemStack stack : items) {
            assert (this.f_58857_ != null);
            Containers.m_18992_((Level)this.f_58857_, (double)x, (double)y, (double)z, (ItemStack)stack);
        }
    }

    public void playSoundAtDoor(SoundEvent sound, float volume, float pitch) {
        assert (this.f_58857_ != null);
        MonobankBlockEntity.playSoundAtDoor(this.f_58857_, this.f_58858_, this.m_58900_(), sound, volume, pitch);
    }

    public void playSoundAtDoor(SoundEvent sound) {
        MonobankBlockEntity.playSoundAtDoor(this.f_58857_, this.f_58858_, this.m_58900_(), sound);
    }

    public static void playSoundAtDoor(Level level, BlockPos pos, BlockState state, SoundEvent sound) {
        MonobankBlockEntity.playSoundAtDoor(level, pos, state, sound, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public static void playSoundAtDoor(Level level, BlockPos pos, BlockState state, SoundEvent sound, float volume) {
        MonobankBlockEntity.playSoundAtDoor(level, pos, state, sound, volume, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public static void playSoundAtDoor(Level level, BlockPos pos, BlockState state, SoundEvent sound, float volume, float pitch) {
        Vec3i facingNormal = ((Direction)state.m_61143_((Property)MonobankBlock.FACING)).m_122436_();
        double x = (double)pos.m_123341_() + 0.5 + (double)facingNormal.m_123341_() * 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5 + (double)facingNormal.m_123343_() * 0.5;
        level.m_6263_(null, x, y, z, sound, SoundSource.BLOCKS, volume, pitch);
    }
}

