/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.data;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraftforge.registries.ForgeRegistries;
import plus.dragons.visuality.data.CompositeRegistryCodec;
import plus.dragons.visuality.data.CompressedListCodec;
import plus.dragons.visuality.registry.VisualityRegistries;

public class VisualityCodecs {
    public static final Codec<ParticleType<?>> PARTICLE_TYPE = CompositeRegistryCodec.of(ForgeRegistries.PARTICLE_TYPES.getCodec(), VisualityRegistries.Keys.PARTICLE_TYPES);
    public static final Codec<ParticleOptions> PARTICLE_OPTIONS = PARTICLE_TYPE.dispatch("type", ParticleOptions::m_6012_, ParticleType::m_7652_);

    public static <T> Codec<List<T>> compressedListOf(Codec<T> codec) {
        return CompressedListCodec.of(codec, new Object[0]);
    }

    public static <T> Codec<Set<T>> compressedSetOf(Codec<T> codec) {
        return CompressedListCodec.of(codec, new Object[0]).xmap(HashSet::new, ArrayList::new);
    }

    public static <T, S extends Set<T>> Codec<S> compressedSetOf(Codec<T> codec, Function<List<T>, S> toSetFunction) {
        return CompressedListCodec.of(codec, new Object[0]).xmap(toSetFunction, ArrayList::new);
    }
}

