/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker.vrhand;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.vr.VRRumble;
import com.hammy275.immersivemc.server.data.LastTickData;
import com.hammy275.immersivemc.server.tracker.vrhand.AbstractVRHandTracker;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;

public class ArmorTracker
extends AbstractVRHandTracker {
    @Override
    protected boolean shouldRunForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        return player.m_20191_().m_82390_(currentVRData.getController(hand.ordinal()).position()) && stackInHand.m_41720_() instanceof Equipable;
    }

    @Override
    protected void runForHand(Player player, InteractionHand hand, ItemStack stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        boolean shouldEquip;
        EquipmentSlot slot = Mob.m_147233_((ItemStack)stackInHand);
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            return;
        }
        if (!((ItemStack)player.m_150109_().f_35975_.get(slot.m_20749_())).m_41619_()) {
            return;
        }
        switch (slot) {
            case HEAD: {
                shouldEquip = player.m_146892_().m_82557_(currentVRData.getController(hand.ordinal()).position()) <= 0.25;
                break;
            }
            case CHEST: {
                shouldEquip = player.m_20182_().m_82520_(0.0, 1.2, 0.0).m_82557_(currentVRData.getController(hand.ordinal()).position()) <= 0.25;
                break;
            }
            case LEGS: {
                shouldEquip = player.m_20182_().m_82520_(0.0, 0.7, 0.0).m_82557_(currentVRData.getController(hand.ordinal()).position()) <= 0.140625;
                break;
            }
            case FEET: {
                shouldEquip = player.m_20182_().m_82557_(currentVRData.getController(hand.ordinal()).position()) <= 0.25;
                break;
            }
            default: {
                return;
            }
        }
        if (shouldEquip) {
            ItemStack toEquip = stackInHand.m_41777_();
            toEquip.m_41764_(1);
            player.m_150109_().f_35975_.set(slot.m_20749_(), (Object)toEquip);
            stackInHand.m_41774_(1);
            VRRumble.rumbleIfVR(player, hand.ordinal(), 0.05f);
        }
    }

    @Override
    public boolean isEnabledInConfig(ActiveConfig config) {
        return config.useArmorImmersive;
    }
}

