/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.swap;

import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.immersive.SwapMode;
import com.hammy275.immersivemc.common.compat.Lootr;
import com.hammy275.immersivemc.common.compat.apotheosis.Apoth;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.AnvilStorage;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.SmithingTableStorage;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ETableStorage;
import com.hammy275.immersivemc.common.util.NullContainer;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.mixin.AnvilMenuMixin;
import com.hammy275.immersivemc.server.api_impl.SwapResultImpl;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import com.hammy275.immersivemc.server.storage.server.SwapResult;
import com.hammy275.immersivemc.server.storage.world.ImmersiveMCPlayerStorages;
import com.hammy275.immersivemc.server.storage.world.WorldStoragesImpl;
import com.hammy275.immersivemc.server.storage.world.impl.ETableWorldStorage;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Swap {
    public static SwapResult swapItems(ItemStack handStack, ItemStack immersiveStack, ItemSwapAmount swapAmount, int forcedMaxImmersiveStackSize, Player player, @Nullable Consumer<Integer> itemCountIncrementer, @Nullable Consumer<Void> itemCountClearer) {
        ItemStack leftovers;
        ItemStack toHand;
        ItemStack toImmersive;
        boolean immersiveStackAtMax;
        int immersiveMaxStackSize = forcedMaxImmersiveStackSize == -1 ? handStack.m_41741_() : forcedMaxImmersiveStackSize;
        int amountToPlace = Math.min(swapAmount.getNumItemsToSwap(), immersiveMaxStackSize);
        boolean handAndImmersiveStackMatch = Util.stacksEqualBesidesCount(handStack, immersiveStack);
        boolean bl = immersiveStackAtMax = immersiveStack.m_41613_() == immersiveMaxStackSize;
        if (handAndImmersiveStackMatch && !handStack.m_41619_() && !immersiveStackAtMax) {
            ItemStack handStackToPlace = handStack.m_41777_();
            handStackToPlace.m_41764_(amountToPlace);
            int oldImmersiveCount = immersiveStack.m_41613_();
            Util.ItemStackMergeResult mergeResult = Util.mergeStacks(immersiveStack, handStackToPlace, false);
            toImmersive = immersiveStack;
            toHand = handStack.m_41777_();
            toHand.m_41774_(amountToPlace);
            toHand.m_41769_(mergeResult.mergedFrom.m_41613_());
            leftovers = ItemStack.f_41583_;
            int itemsMoved = immersiveStack.m_41613_() - oldImmersiveCount;
            if (itemCountIncrementer != null) {
                itemCountIncrementer.accept(itemsMoved);
            }
        } else if (handStack.m_41619_()) {
            boolean stackToInventory = Util.hasItemInInventoryWithStackSpace(player, immersiveStack);
            toHand = stackToInventory ? ItemStack.f_41583_ : immersiveStack.m_41777_();
            toImmersive = ItemStack.f_41583_;
            ItemStack itemStack = leftovers = stackToInventory ? immersiveStack.m_41777_() : ItemStack.f_41583_;
            if (itemCountClearer != null) {
                itemCountClearer.accept(null);
            }
        } else if (immersiveStackAtMax && handAndImmersiveStackMatch) {
            toHand = immersiveStack.m_41777_();
            toImmersive = ItemStack.f_41583_;
            leftovers = handStack.m_41777_();
            if (itemCountClearer != null) {
                itemCountClearer.accept(null);
            }
        } else {
            toHand = handStack.m_41777_();
            toHand.m_41774_(amountToPlace);
            toImmersive = handStack.m_41777_();
            toImmersive.m_41764_(amountToPlace);
            leftovers = immersiveStack.m_41777_();
            if (toHand.m_41619_() && !Util.hasItemInInventoryWithStackSpace(player, leftovers)) {
                toHand = leftovers;
                leftovers = ItemStack.f_41583_;
            }
            if (itemCountClearer != null) {
                itemCountClearer.accept(null);
            }
            if (itemCountIncrementer != null) {
                itemCountIncrementer.accept(amountToPlace);
            }
        }
        return new SwapResultImpl(toHand, toImmersive, leftovers);
    }

    public static boolean doEnchanting(int slot, BlockPos pos, ServerPlayer player, InteractionHand hand) {
        if (slot < 1 || slot > 3) {
            return false;
        }
        ETableWorldStorage storage = (ETableWorldStorage)WorldStoragesImpl.getOrCreateS(pos, player.m_284548_());
        ItemStack toEnchantItem = storage.getItem(0).m_41777_();
        if (toEnchantItem.m_41619_()) {
            return false;
        }
        int lapisInInventory = 0;
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            if (player.m_150109_().m_8020_(i).m_41720_() != Items.f_42534_) continue;
            lapisInInventory += player.m_150109_().m_8020_(i).m_41613_();
        }
        if (lapisInInventory < slot && !player.m_150110_().f_35937_) {
            return false;
        }
        if (player.f_36078_ < slot && !player.m_150110_().f_35937_) {
            return false;
        }
        boolean doApoth = Apoth.apothImpl.enchantModuleEnabled();
        boolean takeLapis = false;
        if (doApoth) {
            ETableStorage.SlotData[] stats = Apoth.apothImpl.getEnchData((Player)player, pos, toEnchantItem);
            if (player.f_36078_ < stats[slot - 1].xpLevel() && !player.m_150110_().f_35937_) {
                return false;
            }
            takeLapis = true;
            ItemStack out = Apoth.apothImpl.doEnchant((Player)player, pos, slot - 1, toEnchantItem);
            if (out == null) {
                out = toEnchantItem;
            }
            Util.giveStackHandFirst((Player)player, hand, out);
            storage.setItem(0, ItemStack.f_41583_);
        } else {
            EnchantmentMenu container = new EnchantmentMenu(-1, player.m_150109_(), ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)pos));
            container.m_182406_(1, 0, new ItemStack((ItemLike)Items.f_42534_, 64));
            container.m_182406_(0, 0, toEnchantItem);
            if (container.m_6366_((Player)player, slot - 1)) {
                takeLapis = true;
                Util.giveStackHandFirst((Player)player, hand, container.m_38853_(0).m_7993_());
                storage.setItem(0, ItemStack.f_41583_);
            }
        }
        if (takeLapis) {
            int lapisToTake = slot;
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                if (player.m_150109_().m_8020_(i).m_41720_() == Items.f_42534_) {
                    ItemStack stack = player.m_150109_().m_8020_(i);
                    while (!stack.m_41619_() && lapisToTake > 0) {
                        stack.m_41774_(1);
                        --lapisToTake;
                    }
                }
                if (lapisToTake == 0) break;
            }
        }
        return takeLapis;
    }

    public static void handleBackpackCraftingSwap(int slot, InteractionHand hand, List<ItemStack> items, ServerPlayer player, ItemSwapAmount amount) {
        ItemStack[] itemArray = new ItemStack[5];
        for (int i = 0; i <= 4; ++i) {
            itemArray[i] = items.get(i);
        }
        if (slot < 4) {
            ItemStack playerItem = player.m_21120_(hand);
            ItemStack tableItem = itemArray[slot];
            SwapResult result = ImmersiveLogicHelpers.instance().swapItems(playerItem, tableItem, amount, (Player)player);
            itemArray[slot] = result.immersiveStack();
            result.giveToPlayer((Player)player, hand);
            itemArray[4] = Swap.getRecipeOutput(player, itemArray);
        } else if ((itemArray = Swap.handleDoCraft(player, itemArray, null, amount)) == null) {
            return;
        }
        for (int i = 0; i <= 4; ++i) {
            items.set(i, itemArray[i]);
        }
        ImmersiveMCPlayerStorages.getPlayerStorage((Player)player).m_77762_();
    }

    public static boolean handleAnvilCraft(AnvilStorage storage, BlockPos pos, ServerPlayer player, InteractionHand hand) {
        ItemStack mid;
        ItemStack left = storage.getItem(0);
        Pair<ItemStack, Integer> resAndCost = Swap.getAnvilOutput(left, mid = storage.getItem(1), player);
        if ((player.f_36078_ >= (Integer)resAndCost.getSecond() || player.m_150110_().f_35937_) && !((ItemStack)resAndCost.getFirst()).m_41619_()) {
            AnvilMenu container = new AnvilMenu(-1, player.m_150109_(), ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)pos));
            container.m_38853_(2).m_142406_((Player)player, (ItemStack)resAndCost.getFirst());
            if (!player.m_150110_().f_35937_) {
                player.m_6749_(-((Integer)resAndCost.getSecond()).intValue());
            }
            storage.setItem(0, container.m_38853_(0).m_7993_().m_41777_());
            storage.setItem(1, container.m_38853_(1).m_7993_().m_41777_());
            Pair<ItemStack, Integer> output = Swap.getAnvilOutput(storage.getItem(0), storage.getItem(1), player);
            storage.setItem(2, (ItemStack)output.getFirst());
            storage.xpLevels = (Integer)output.getSecond();
            Util.giveStackHandFirst((Player)player, hand, (ItemStack)resAndCost.getFirst());
            return true;
        }
        return false;
    }

    public static boolean handleSmithingTableCraft(SmithingTableStorage storage, BlockPos pos, ServerPlayer player, InteractionHand hand) {
        ItemStack right;
        ItemStack mid;
        ItemStack left = storage.getItem(0);
        ItemStack output = Swap.getSmithingTableOutput(left, mid = storage.getItem(1), right = storage.getItem(2), player);
        if (!output.m_41619_()) {
            SmithingMenu container = new SmithingMenu(-1, player.m_150109_(), ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)pos));
            container.m_38853_(3).m_142406_((Player)player, output);
            storage.shrinkSlot(0, 1);
            storage.shrinkSlot(1, 1);
            storage.shrinkSlot(2, 1);
            storage.setItem(3, ItemStack.f_41583_);
            Util.giveStackHandFirst((Player)player, hand, output);
            return true;
        }
        return false;
    }

    public static ItemStack getRecipeOutput(ServerPlayer player, ItemStack[] stacksIn) {
        int invDim = stacksIn.length >= 9 ? 3 : 2;
        TransientCraftingContainer inv = new TransientCraftingContainer((AbstractContainerMenu)new NullContainer(), invDim, invDim);
        for (int i = 0; i < stacksIn.length - 1; ++i) {
            inv.m_6836_(i, stacksIn[i]);
        }
        Optional res = player.m_20194_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)inv, player.m_9236_());
        if (res.isPresent()) {
            return ((CraftingRecipe)res.get()).m_5874_((Container)inv, player.m_9236_().m_9598_());
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public static ItemStack[] handleDoCraft(ServerPlayer player, ItemStack[] stacksIn, BlockPos tablePos, ItemSwapAmount amount) {
        int i;
        int iters;
        ItemStack stackOut;
        boolean isBackpack = stacksIn.length == 5;
        InventoryMenu menu = isBackpack ? new InventoryMenu(player.m_150109_(), false, (Player)player) : new CraftingMenu(-1, player.m_150109_());
        ItemStack firstOut = stackOut = Swap.getRecipeOutput(player, stacksIn);
        ItemStack[] newSlotsState = Arrays.copyOf(stacksIn, stacksIn.length);
        ArrayList<ItemStack> stacksToGive = new ArrayList<ItemStack>();
        int itersDone = 0;
        int n = iters = amount.getSwapMode() == SwapMode.ALL ? Integer.MAX_VALUE : amount.getNumItemsToSwap();
        while (itersDone++ < iters && ItemStack.m_41728_((ItemStack)firstOut, (ItemStack)stackOut) && !stackOut.m_41619_() && Swap.itemStackArraysMatchBesidesCount(stacksIn, newSlotsState, isBackpack ? 4 : 9)) {
            for (i = 0; i < newSlotsState.length - 1; ++i) {
                menu.m_182406_(i + 1, 0, newSlotsState[i].m_41777_());
            }
            menu.m_38853_(0).m_5852_(stackOut);
            menu.m_38853_(0).m_142406_((Player)player, stackOut);
            stackOut.m_41678_(player.m_9236_(), (Player)player, stackOut.m_41613_());
            for (i = 0; i < newSlotsState.length - 1; ++i) {
                newSlotsState[i] = menu.m_38853_(i + 1).m_7993_();
            }
            stacksToGive.add(stackOut);
            newSlotsState[newSlotsState.length - 1] = stackOut = Swap.getRecipeOutput(player, newSlotsState);
        }
        if (isBackpack) {
            menu.m_182406_(0, 0, ItemStack.f_41583_);
            for (i = 1; i < 5; ++i) {
                menu.m_182406_(i, 0, ItemStack.f_41583_);
            }
        }
        if (stacksToGive.isEmpty()) {
            return null;
        }
        boolean playedSound = false;
        for (ItemStack toGive : stacksToGive) {
            ItemStack handStack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!handStack.m_41619_() && Util.stacksEqualBesidesCount(toGive, handStack)) {
                Util.ItemStackMergeResult itemRes = Util.mergeStacks(handStack, toGive, true);
                player.m_21008_(InteractionHand.MAIN_HAND, itemRes.mergedInto);
                toGive = itemRes.mergedFrom;
            } else if (handStack.m_41619_() && !Util.hasItemInInventoryWithStackSpace((Player)player, toGive)) {
                player.m_21008_(InteractionHand.MAIN_HAND, toGive);
                toGive = ItemStack.f_41583_;
            }
            if (!toGive.m_41619_()) {
                BlockPos posBlock = tablePos != null ? tablePos.m_7494_() : player.m_20183_();
                Vec3 pos = Vec3.m_82512_((Vec3i)posBlock);
                ItemEntity entOut = new ItemEntity(player.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, toGive);
                entOut.m_20334_(0.0, 0.0, 0.0);
                player.m_9236_().m_7967_((Entity)entOut);
                continue;
            }
            if (playedSound) continue;
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, isBackpack ? SoundSource.PLAYERS : SoundSource.BLOCKS, 0.2f, ThreadLocalRandom.current().nextFloat() - ThreadLocalRandom.current().nextFloat() * 1.4f + 2.0f);
            playedSound = true;
        }
        return newSlotsState;
    }

    public static void handleInventorySwap(Player player, int slot, InteractionHand hand) {
        ItemStack handStack = player.m_21120_(hand).m_41777_();
        ItemStack invStack = player.m_150109_().m_8020_(slot).m_41777_();
        if (handStack.m_41619_() || invStack.m_41619_() || !Util.stacksEqualBesidesCount(handStack, invStack)) {
            player.m_21008_(hand, invStack);
            player.m_150109_().m_6836_(slot, handStack);
        } else {
            Util.ItemStackMergeResult res = Util.mergeStacks(invStack, handStack, false);
            player.m_21008_(hand, res.mergedFrom);
            player.m_150109_().m_6836_(slot, res.mergedInto);
        }
    }

    public static void handleChest(ChestBlockEntity chestIn, ServerPlayer player, InteractionHand hand, int slot) {
        Container chest;
        ChestBlockEntity chestBlockEntity = chestIn = slot > 26 ? Util.getOtherChest(chestIn) : chestIn;
        if (chestIn == null) {
            return;
        }
        Container lootrChest = Lootr.lootrImpl.getContainer(player, chestIn.m_58899_());
        Object object = chest = lootrChest != null ? lootrChest : chestIn;
        if (chest != null) {
            ItemStack chestItem = chest.m_8020_(slot %= 27).m_41777_();
            ItemStack playerItem = player.m_21120_(hand);
            if (playerItem.m_41619_() || chestItem.m_41619_() || !Util.stacksEqualBesidesCount(chestItem, playerItem)) {
                player.m_21008_(hand, chestItem);
                chest.m_6836_(slot, playerItem);
            } else {
                Util.ItemStackMergeResult result = Util.mergeStacks(chestItem, playerItem, false);
                player.m_21008_(hand, result.mergedFrom);
                chest.m_6836_(slot, result.mergedInto);
            }
            chest.m_6596_();
        }
    }

    public static void handleEnderChest(Player player, InteractionHand hand, int slot) {
        ItemStack chestItem = player.m_36327_().m_8020_(slot).m_41777_();
        ItemStack playerItem = player.m_21120_(hand);
        if (playerItem.m_41619_() || chestItem.m_41619_() || !Util.stacksEqualBesidesCount(chestItem, playerItem)) {
            player.m_21008_(hand, chestItem);
            player.m_36327_().m_6836_(slot, playerItem);
        } else {
            Util.ItemStackMergeResult result = Util.mergeStacks(chestItem, playerItem, false);
            player.m_21008_(hand, result.mergedFrom);
            player.m_36327_().m_6836_(slot, result.mergedInto);
        }
    }

    public static Pair<ItemStack, Integer> getAnvilOutput(ItemStack left, ItemStack mid, ServerPlayer player) {
        AnvilMenu container = new AnvilMenu(-1, player.m_150109_());
        container.m_182406_(0, 0, left);
        container.m_182406_(1, 0, mid);
        container.m_6640_();
        ItemStack res = container.m_38853_(2).m_7993_();
        int level = ((AnvilMenuMixin)container).immersiveMC$getCost().m_6501_();
        return new Pair((Object)res, (Object)level);
    }

    public static ItemStack getSmithingTableOutput(ItemStack left, ItemStack mid, ItemStack right, ServerPlayer player) {
        SmithingMenu container = new SmithingMenu(-1, player.m_150109_());
        container.m_182406_(0, 0, left);
        container.m_182406_(1, 0, mid);
        container.m_182406_(2, 0, right);
        container.m_6640_();
        ItemStack res = container.m_38853_(3).m_7993_();
        return res;
    }

    public static boolean itemStackArraysMatchBesidesCount(ItemStack[] a, ItemStack[] b, int numElements) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < numElements; ++i) {
            ItemStack as = a[i];
            ItemStack bs = b[i];
            if (as == bs || as != null && bs != null && Util.stacksEqualBesidesCount(as, bs)) continue;
            return false;
        }
        return true;
    }
}

