/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.storage.world;

import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.handler.WorldStorageHandler;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.AnvilStorage;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.ItemStorage;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.SmithingTableStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.ServerUtil;
import com.hammy275.immersivemc.server.storage.world.WorldStorage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class ImmersiveMCLevelStorage
extends SavedData {
    private static final int LEVEL_STORAGE_VERSION = 2;
    private static final String DATA_KEY = "immersivemc_data";
    protected Map<BlockPos, WorldStorage> storageMap = new HashMap<BlockPos, WorldStorage>();

    private static ImmersiveMCLevelStorage create() {
        return new ImmersiveMCLevelStorage();
    }

    public static ImmersiveMCLevelStorage getLevelStorage(ServerLevel level) {
        return (ImmersiveMCLevelStorage)level.m_8895_().m_164861_(ImmersiveMCLevelStorage::load, ImmersiveMCLevelStorage::create, DATA_KEY);
    }

    @Nullable
    public WorldStorage remove(BlockPos pos) {
        return this.storageMap.remove(pos);
    }

    @Nullable
    public WorldStorage get(BlockPos pos, Level level) {
        WorldStorage storage = this.storageMap.get(pos);
        for (ImmersiveHandler<?> handlerMaybeWS : ImmersiveHandlers.HANDLERS) {
            WorldStorageHandler handler;
            if (!(handlerMaybeWS instanceof WorldStorageHandler) || !(handler = (WorldStorageHandler)handlerMaybeWS).getWorldStorageClass().isInstance(storage) || !Util.isValidBlocks(handler, pos, level)) continue;
            return storage;
        }
        return null;
    }

    @Nullable
    public WorldStorage getWithoutVerification(BlockPos pos, Level level) {
        return this.storageMap.get(pos);
    }

    @Nullable
    public WorldStorage getOrCreate(BlockPos pos, Level level) {
        WorldStorage storage = this.get(pos, level);
        if (storage != null) {
            return storage;
        }
        for (ImmersiveHandler<?> handlerMaybeWS : ImmersiveHandlers.HANDLERS) {
            WorldStorageHandler handler;
            if (!(handlerMaybeWS instanceof WorldStorageHandler) || !Util.isValidBlocks(handler = (WorldStorageHandler)handlerMaybeWS, pos, level)) continue;
            storage = handler.getEmptyWorldStorage();
            this.storageMap.put(pos, storage);
            return storage;
        }
        storage = this.storageMap.get(pos);
        if (storage instanceof AnvilStorage) {
            AnvilStorage as = (AnvilStorage)storage;
            if (ImmersiveHandlers.smithingTableHandler.isValidBlock(pos, level)) {
                SmithingTableStorage sts = new SmithingTableStorage();
                sts.copyFromOld(as);
                sts.convertFrom119();
                this.storageMap.put(pos, sts);
                this.m_77762_();
                return sts;
            }
        }
        return null;
    }

    public static void unmarkAllItemStoragesDirty(MinecraftServer server) {
        for (ServerLevel level : server.m_129785_()) {
            ImmersiveMCLevelStorage storage = (ImmersiveMCLevelStorage)level.m_8895_().m_164858_(ImmersiveMCLevelStorage::load, DATA_KEY);
            if (storage == null) continue;
            storage.storageMap.forEach((pos, ws) -> {
                if (ws instanceof ItemStorage) {
                    ItemStorage is = (ItemStorage)ws;
                    is.setNoLongerDirtyForClientSync();
                }
            });
        }
    }

    public static ImmersiveMCLevelStorage load(CompoundTag nbt) {
        ImmersiveMCLevelStorage levelStorage = new ImmersiveMCLevelStorage();
        int lastVanillaDataVersion = nbt.m_128441_("lastVanillaDataVersion") ? nbt.m_128451_("lastVanillaDataVersion") : Math.min(3700, SharedConstants.m_183709_().m_183476_().m_193006_());
        nbt = ImmersiveMCLevelStorage.maybeUpgradeNBT(nbt, lastVanillaDataVersion);
        Map<BlockPos, WorldStorage> storageMap = levelStorage.storageMap;
        storageMap.clear();
        int numOfStorages = nbt.m_128451_("numOfStorages");
        CompoundTag storages = nbt.m_128469_("storages");
        for (int i = 0; i < numOfStorages; ++i) {
            CompoundTag storageInfo = storages.m_128469_(String.valueOf(i));
            BlockPos pos = new BlockPos(storageInfo.m_128451_("posX"), storageInfo.m_128451_("posY"), storageInfo.m_128451_("posZ"));
            ResourceLocation id = Util.getResourceLocation(storageInfo, "id");
            WorldStorage storage = null;
            for (ImmersiveHandler<?> handlerMaybeWS : ImmersiveHandlers.HANDLERS) {
                if (!handlerMaybeWS.getID().equals((Object)id) || !(handlerMaybeWS instanceof WorldStorageHandler)) continue;
                WorldStorageHandler handler = (WorldStorageHandler)handlerMaybeWS;
                storage = handler.getEmptyWorldStorage();
                storage.load(storageInfo.m_128469_("data"), lastVanillaDataVersion);
                break;
            }
            if (storage == null) continue;
            storageMap.put(pos, storage);
        }
        return levelStorage;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128405_("lastVanillaDataVersion", SharedConstants.m_183709_().m_183476_().m_193006_());
        nbt.m_128405_("version", 2);
        nbt.m_128405_("numOfStorages", this.storageMap.size());
        CompoundTag storages = new CompoundTag();
        int i = 0;
        for (Map.Entry<BlockPos, WorldStorage> entry : this.storageMap.entrySet()) {
            CompoundTag storageInfo = new CompoundTag();
            storageInfo.m_128405_("posX", entry.getKey().m_123341_());
            storageInfo.m_128405_("posY", entry.getKey().m_123342_());
            storageInfo.m_128405_("posZ", entry.getKey().m_123343_());
            storageInfo.m_128365_("data", (Tag)entry.getValue().save(new CompoundTag()));
            Util.putResourceLocation(storageInfo, "id", entry.getValue().getHandler().getID());
            storages.m_128365_(String.valueOf(i), (Tag)storageInfo);
            ++i;
        }
        nbt.m_128365_("storages", (Tag)storages);
        return nbt;
    }

    private static CompoundTag maybeUpgradeNBT(CompoundTag nbtIn, int lastVanillaDataVersion) {
        int version = 1;
        if (nbtIn.m_128441_("version")) {
            version = nbtIn.m_128451_("version");
        }
        while (version < 2) {
            if (version == 1) {
                int numOfStorages = nbtIn.m_128451_("numOfStorages");
                CompoundTag storages = nbtIn.m_128469_("storages");
                for (int i = 0; i < numOfStorages; ++i) {
                    ResourceLocation id;
                    CompoundTag storage = storages.m_128469_(String.valueOf(i));
                    String oldDataType = storage.m_128461_("dataType");
                    storage.m_128473_("dataType");
                    CompoundTag itemsData = storage.m_128469_("data");
                    String oldIdentifier = itemsData.m_128461_("identifier");
                    itemsData.m_128473_("identifier");
                    int numItems = itemsData.m_128451_("numOfItems");
                    if (numItems == 10) {
                        id = new ResourceLocation("immersivemc", "crafting_table");
                    } else if (numItems == 4 || numItems == 3 && oldDataType.equals("basic_item_store")) {
                        id = new ResourceLocation("immersivemc", "smithing_table");
                    } else if (numItems == 3) {
                        id = new ResourceLocation("immersivemc", "anvil");
                    } else {
                        if (numItems != 1) continue;
                        ItemStack item = ServerUtil.parseItem(itemsData.m_128469_("item0"), lastVanillaDataVersion);
                        id = item.m_204117_(ItemTags.f_13164_) ? new ResourceLocation("immersivemc", "beacon") : new ResourceLocation("immersivemc", "enchanting_table");
                    }
                    Util.putResourceLocation(storage, "id", id);
                }
            }
            ++version;
        }
        return nbtIn;
    }
}

