/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.api_impl;

import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.server.storage.server.SharedNetworkStorages;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SharedNetworkStoragesImpl
implements SharedNetworkStorages {
    public static final SharedNetworkStoragesImpl INSTANCE = new SharedNetworkStoragesImpl();
    private Map<ResourceLocation, Map<BlockPos, NetworkStorage>> storages = new HashMap<ResourceLocation, Map<BlockPos, NetworkStorage>>();

    @Override
    public <S extends NetworkStorage> S getOrCreate(Level level, BlockPos pos, ImmersiveHandler<S> handler) {
        S storage = this.get(level, pos, handler);
        if (storage == null) {
            storage = handler.getEmptyNetworkStorage();
            this.storages.get(level.m_46472_().m_135782_()).put(pos, (NetworkStorage)storage);
        }
        return storage;
    }

    @Override
    @Nullable
    public <S extends NetworkStorage> S get(Level level, BlockPos pos, ImmersiveHandler<S> handler) {
        NetworkStorage storage;
        Map innerMap = this.storages.computeIfAbsent(level.m_46472_().m_135782_(), rl -> new HashMap());
        S emptyStorage = handler.getEmptyNetworkStorage();
        if (innerMap.containsKey(pos) && (storage = (NetworkStorage)innerMap.get(pos)).getClass() == emptyStorage.getClass()) {
            return (S)storage;
        }
        return null;
    }

    @Override
    public <S extends NetworkStorage> void remove(Level level, BlockPos pos, ImmersiveHandler<S> handler) {
        NetworkStorage storage;
        Map<BlockPos, NetworkStorage> innerMap = this.storages.get(level.m_46472_().m_135782_());
        if (innerMap != null && (storage = innerMap.get(pos)) != null && storage.getClass() == handler.getEmptyNetworkStorage().getClass()) {
            innerMap.remove(pos);
        }
    }

    @Override
    public <S extends NetworkStorage> List<S> getAll(Class<S> storageClass) {
        return this.storages.values().stream().map(Map::values).flatMap(Collection::stream).filter(storage -> storage.getClass() == storageClass).map(storage -> storage).toList();
    }

    public void clear() {
        this.storages.clear();
    }
}

