/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.tracker.RangedGrabTrackerServer;
import com.hammy275.immersivemc.server.tracker.ServerTrackerInit;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;

public class GrabItemPacket {
    public final int entityId;

    public GrabItemPacket(ItemEntity item) {
        this.entityId = item.m_19879_();
    }

    public GrabItemPacket(int entityId) {
        this.entityId = entityId;
    }

    public static void encode(GrabItemPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.entityId);
    }

    public static GrabItemPacket decode(FriendlyByteBuf buffer) {
        return new GrabItemPacket(buffer.readInt());
    }

    public static void handle(GrabItemPacket packet, ServerPlayer player) {
        if (!ActiveConfig.FILE_SERVER.useRangedGrabImmersive) {
            return;
        }
        if (player != null) {
            Entity ent = player.m_9236_().m_6815_(packet.entityId);
            ClientActiveConfig playerConfig = ActiveConfig.getConfigForPlayer((Player)player);
            int range = playerConfig.rangedGrabRange == -1 ? 5 : (playerConfig.rangedGrabRange + 1) * 2;
            if (ent instanceof ItemEntity && player.m_20280_(ent) <= (double)(range * range) && Util.canPickUpItem((ItemEntity)ent, (Player)player)) {
                ItemEntity item = (ItemEntity)ent;
                ServerTrackerInit.rangedGrabTracker.infos.add(new RangedGrabTrackerServer.RangedGrabInfo(item, player));
            }
        }
    }
}

