/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.immersive.storage.dual.impl.BeaconStorage;
import com.hammy275.immersivemc.common.network.NetworkUtil;
import com.hammy275.immersivemc.mixin.BeaconBlockEntityMixin;
import com.hammy275.immersivemc.server.storage.world.WorldStoragesImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BeaconConfirmPacket {
    public final BlockPos pos;
    public final int primaryId;
    public final int secondaryId;

    public BeaconConfirmPacket(BlockPos beaconPos, int primaryId, int secondaryId) {
        this.pos = beaconPos;
        this.primaryId = primaryId;
        this.secondaryId = secondaryId;
    }

    public static void encode(BeaconConfirmPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos).writeInt(packet.primaryId).writeInt(packet.secondaryId);
    }

    public static BeaconConfirmPacket decode(FriendlyByteBuf buffer) {
        return new BeaconConfirmPacket(buffer.m_130135_(), buffer.readInt(), buffer.readInt());
    }

    public static void handle(BeaconConfirmPacket message, ServerPlayer player) {
        BlockEntity blockEntity;
        if (NetworkUtil.safeToRun(message.pos, player) && (blockEntity = player.m_9236_().m_7702_(message.pos)) instanceof BeaconBlockEntity) {
            BeaconBlockEntity beacon = (BeaconBlockEntity)blockEntity;
            ContainerData data = ((BeaconBlockEntityMixin)beacon).immersiveMC$getBeaconData();
            BeaconStorage beaconStorage = (BeaconStorage)WorldStoragesImpl.getOrCreateS(message.pos, player.m_284548_());
            int secondId = message.secondaryId;
            if (data.m_6413_(0) == 4 && message.secondaryId == -1) {
                secondId = message.primaryId;
            }
            if (!beaconStorage.getItem(0).m_41619_() && BeaconConfirmPacket.isValidForBeacon(data.m_6413_(0), message.primaryId, secondId)) {
                beaconStorage.setItem(0, ItemStack.f_41583_);
                data.m_8050_(1, message.primaryId);
                data.m_8050_(2, secondId);
                beaconStorage.setDirty(player.m_284548_());
                player.m_9236_().m_151543_(beacon.m_58899_());
            }
        }
    }

    private static boolean isValidForBeacon(int beaconLevel, int primaryId, int secondaryId) {
        MobEffect secondary;
        if (beaconLevel < 1 || beaconLevel < 4 && secondaryId != -1) {
            return false;
        }
        MobEffect primary = primaryId == -1 ? null : MobEffect.m_19453_((int)primaryId);
        MobEffect mobEffect = secondary = secondaryId == -1 ? null : MobEffect.m_19453_((int)secondaryId);
        if (beaconLevel == 1) {
            return primary == MobEffects.f_19596_ || primary == MobEffects.f_19598_;
        }
        if (beaconLevel == 2) {
            return primary == MobEffects.f_19606_ || primary == MobEffects.f_19603_ || BeaconConfirmPacket.isValidForBeacon(1, primaryId, secondaryId);
        }
        if (beaconLevel == 3) {
            return primary == MobEffects.f_19600_ || BeaconConfirmPacket.isValidForBeacon(2, primaryId, secondaryId);
        }
        return (secondary == MobEffects.f_19605_ || BeaconConfirmPacket.isValidForBeacon(3, secondaryId, -1)) && BeaconConfirmPacket.isValidForBeacon(3, primaryId, -1);
    }
}

