/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive_item;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.client.immersive_item.info.AbstractHandImmersiveInfo;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractHandImmersive<I extends AbstractHandImmersiveInfo> {
    protected List<I> infos = new ArrayList<I>();

    protected abstract void render(I var1, PoseStack var2, IVRData var3);

    protected abstract void tick(I var1, IVRData var2, IVRData var3);

    public abstract boolean activeForHand(InteractionHand var1);

    protected abstract I createInfo(InteractionHand var1);

    public abstract boolean isEnabled();

    public abstract boolean onLeftClick(I var1, IVRData var2, IVRData var3);

    protected boolean handSwapCandidate(InteractionHand newHand) {
        return false;
    }

    public boolean attemptLeftClickAll() {
        IVRPlayer player = VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_);
        for (AbstractHandImmersiveInfo info : this.infos) {
            boolean handledClick = this.onLeftClick(info, player.getController(info.hand.ordinal()), player.getController(info.hand == InteractionHand.MAIN_HAND ? 1 : 0));
            if (!handledClick) continue;
            return true;
        }
        return false;
    }

    public void registerAndTickAll() {
        if (!this.isEnabled()) {
            this.infos.clear();
            return;
        }
        ArrayList<AbstractHandImmersiveInfo> toRemove = new ArrayList<AbstractHandImmersiveInfo>();
        for (AbstractHandImmersiveInfo info : this.infos) {
            if (!this.activeForHand(info.hand)) {
                InteractionHand otherHand = Util.otherHand(info.hand);
                if (this.handSwapCandidate(otherHand)) {
                    info.hand = otherHand;
                } else {
                    info.shouldRemove = true;
                }
            }
            if (!info.shouldRemove) continue;
            toRemove.add(info);
        }
        this.infos.removeAll(toRemove);
        this.maybeRegister(InteractionHand.MAIN_HAND);
        this.maybeRegister(InteractionHand.OFF_HAND);
        IVRPlayer player = VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_);
        for (AbstractHandImmersiveInfo info : this.infos) {
            this.tick(info, player.getController(info.hand.ordinal()), player.getController(info.hand == InteractionHand.MAIN_HAND ? 1 : 0));
        }
    }

    public void renderAll(PoseStack poseStack) {
        IVRPlayer player = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_) : VRPlugin.API.getRenderVRPlayer();
        for (AbstractHandImmersiveInfo info : this.infos) {
            if (info.shouldRemove || !this.isEnabled()) continue;
            this.render(info, poseStack, player.getController(info.hand.ordinal()));
        }
    }

    private void maybeRegister(InteractionHand hand) {
        for (AbstractHandImmersiveInfo info : this.infos) {
            if (info.hand != hand) continue;
            return;
        }
        if (this.activeForHand(hand)) {
            this.infos.add(this.createInfo(hand));
        }
    }
}

