/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive.book;

import com.hammy275.immersivemc.api.common.hitbox.OBB;
import com.hammy275.immersivemc.client.immersive.book.BookInteractable;
import com.hammy275.immersivemc.client.immersive.book.BookRenderable;
import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.obb.OBBClientUtil;
import com.hammy275.immersivemc.common.util.PageChangeState;
import com.hammy275.immersivemc.common.util.PosRot;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ClientBookData
extends CommonBookData {
    private static final BookModel bookModel = new BookModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171271_));
    private static final ResourceLocation writtenBookTexture = new ResourceLocation("immersivemc", "nahnotfox_written_book.png");
    public final List<BookInteractable> interactables = new ArrayList<BookInteractable>();
    public final List<BookRenderable> renderables = new ArrayList<BookRenderable>();
    protected final List<OBB> obbs = new ArrayList<OBB>();
    protected float lastLeftPageTurn;
    protected float lastRightPageTurn;

    public ClientBookData() {
        this.pageTurner = Minecraft.m_91087_().f_91074_;
        this.lastLeftPageTurn = this.leftPageTurn;
        this.lastRightPageTurn = this.rightPageTurn;
    }

    @Override
    public void tick(PosRot bookPosRot, PosRot ... others) {
        this.lastLeftPageTurn = this.leftPageTurn;
        this.lastRightPageTurn = this.rightPageTurn;
        super.tick(bookPosRot, others);
        this.obbs.clear();
        BookInteractable[] interacted = new BookInteractable[others.length];
        for (BookInteractable interactable : this.interactables) {
            OBB obb = interactable.getOBB();
            this.obbs.add(obb);
            for (int o = 0; o < others.length; ++o) {
                PosRot other = others[o];
                if (interacted[o] != null || !obb.contains(other.position())) continue;
                interacted[o] = interactable;
            }
        }
        for (int o = 0; o < others.length; ++o) {
            if (interacted[o] == null) continue;
            if (Minecraft.m_91087_().f_91066_.f_92096_.m_90857_()) {
                interacted[o].interact(this, bookPosRot, others[o]);
                continue;
            }
            interacted[o].hover(this, bookPosRot, others[o]);
        }
    }

    public void render(PoseStack stack, int light, PosRot bookPosRot) {
        stack.m_85836_();
        float partialTick = Minecraft.m_91087_().m_91296_();
        Vec3 pos = bookPosRot.position();
        Camera cameraInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        stack.m_85837_(-cameraInfo.m_90583_().f_82479_ + pos.f_82479_, -cameraInfo.m_90583_().f_82480_ + pos.f_82480_, -cameraInfo.m_90583_().f_82481_ + pos.f_82481_);
        stack.m_85841_(1.0f, 1.0f, 1.0f);
        stack.m_252781_(Axis.f_252392_.m_252977_(bookPosRot.getYaw() + 90.0f));
        stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        stack.m_252781_(Axis.f_252403_.m_252977_(bookPosRot.getPitch()));
        stack.m_252781_(Axis.f_252392_.m_252977_(bookPosRot.getRoll()));
        float bookOpenAmount = 1.1f;
        bookModel.m_102292_(0.0f, Mth.m_14179_((float)partialTick, (float)this.lastLeftPageTurn, (float)this.leftPageTurn), Mth.m_14179_((float)partialTick, (float)this.lastRightPageTurn, (float)this.rightPageTurn), bookOpenAmount);
        bookModel.m_102316_(stack, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110446_((ResourceLocation)writtenBookTexture)), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
        if (this.pageChangeState == PageChangeState.NONE) {
            this.renderPage(stack, bookPosRot, true, light);
            this.renderPage(stack, bookPosRot, false, light);
        }
        if (this.pageChangeState == PageChangeState.NONE) {
            for (int i = 0; i <= 1; ++i) {
                OBBClientUtil.renderOBB(stack, this.pageTurnBoxes[i], false, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (!this.pageChangeState.isAnim) {
            OBBClientUtil.renderOBB(stack, this.pageTurnBoxes[2], false, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        for (OBB obb : this.obbs) {
            OBBClientUtil.renderOBB(stack, obb, false, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void mergeFromServer(CommonBookData fromServer) {
        this.leftPageIndex = fromServer.leftPageIndex;
        this.leftPageTurn = fromServer.leftPageTurn;
        this.rightPageTurn = fromServer.rightPageTurn;
        this.pageChangeState = fromServer.pageChangeState;
    }

    public List<OBB> getPageTurnHitboxes() {
        return List.of(this.pageTurnBoxes);
    }

    public List<OBB> getInteractableHitboxes() {
        return this.interactables.stream().map(BookInteractable::getOBB).toList();
    }

    protected void renderPage(PoseStack stack, PosRot bookPosRot, boolean leftPage, int light) {
        Vec3 awayFromBookUp = this.getAwayVector(bookPosRot);
        Vec3 pageUp = bookPosRot.getLookAngle();
        Vec3 left = this.getLeftRightVector(bookPosRot, leftPage);
        Vec3 posBase = bookPosRot.position().m_82549_(left.m_82490_(0.15)).m_82549_(awayFromBookUp.m_82490_(0.09375));
        Camera cameraInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        for (BookRenderable renderable : this.renderables) {
            stack.m_85836_();
            Vec3 renderableOffset = renderable.getStartOffset(this, leftPage, bookPosRot);
            Vec3 pos = posBase.m_82549_(pageUp.m_82490_(0.25 * renderableOffset.f_82480_)).m_82549_(left.m_82490_(-0.15 * renderableOffset.f_82479_)).m_82549_(awayFromBookUp.m_82490_(0.09375 * renderableOffset.f_82481_));
            stack.m_85837_(-cameraInfo.m_90583_().f_82479_ + pos.f_82479_, -cameraInfo.m_90583_().f_82480_ + pos.f_82480_, -cameraInfo.m_90583_().f_82481_ + pos.f_82481_);
            stack.m_252781_(Axis.f_252392_.m_252977_(bookPosRot.getYaw() + 90.0f));
            stack.m_252781_(Axis.f_252403_.m_252977_(bookPosRot.getPitch()));
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f + (leftPage ? 11.0f : -11.0f)));
            stack.m_252781_(Axis.f_252403_.m_252977_(270.0f));
            stack.m_252781_(Axis.f_252436_.m_252977_(bookPosRot.getRoll()));
            renderable.render(stack, this, leftPage, light, bookPosRot);
            stack.m_85849_();
        }
    }

    @Override
    public void resetTurnState() {
        super.resetTurnState();
        this.lastLeftPageTurn = this.leftPageTurn;
        this.lastRightPageTurn = this.rightPageTurn;
    }
}

