/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.immersive.BuiltImmersiveInfo;
import com.hammy275.immersivemc.api.client.immersive.ForcedUpDownRenderDir;
import com.hammy275.immersivemc.api.client.immersive.HitboxPositioningMode;
import com.hammy275.immersivemc.api.client.immersive.HitboxVRMovementInfo;
import com.hammy275.immersivemc.api.client.immersive.HitboxVRMovementInfoBuilder;
import com.hammy275.immersivemc.api.client.immersive.ItemRotationType;
import com.hammy275.immersivemc.api.client.immersive.RelativeHitboxInfo;
import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfo;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.LastClientVRData;
import com.hammy275.immersivemc.client.immersive.RelativeHitboxInfoBuilderImpl;
import com.hammy275.immersivemc.client.immersive.TextData;
import com.hammy275.immersivemc.client.immersive.info.BuiltImmersiveInfoImpl;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RelativeHitboxInfoImpl
implements RelativeHitboxInfo,
HitboxInfo,
Cloneable {
    private final RelativeHitboxInfoBuilderImpl usedBuilder;
    public final Function<BuiltImmersiveInfo<?>, Vec3> centerOffset;
    public final double sizeX;
    public final double sizeY;
    public final double sizeZ;
    public final boolean isInput;
    public final boolean holdsItems;
    public final boolean itemSpins;
    public final float itemRenderSizeMultiplier;
    public final boolean isTriggerHitbox;
    public final Function<BuiltImmersiveInfo<?>, List<Pair<Component, Vec3>>> textSupplier;
    public final Function<BuiltImmersiveInfo<?>, ForcedUpDownRenderDir> forcedUpDownRenderDir;
    public final boolean constantOffset;
    public final boolean needs3dCompat;
    public final HitboxVRMovementInfo vrMovementInfo;
    public final boolean renderItem;
    public final boolean renderItemCount;
    public final boolean forcedUpDownRenderDirConstant;
    public final ItemRotationType itemRotationType;
    private AABB box;
    private Vec3 pos;
    private boolean didCalc = false;
    private final List<TextData> textData = new ArrayList<TextData>();
    private Direction upDownRenderDir = null;
    private Vec3 xVec;
    private Vec3 yVec;
    private Vec3 zVec;
    private Vec3 centerPos;
    private Vec3 lastPos = null;
    public ItemStack item = null;

    public RelativeHitboxInfoImpl(RelativeHitboxInfoBuilderImpl usedBuilder, Function<BuiltImmersiveInfo<?>, Vec3> centerOffset, double sizeX, double sizeY, double sizeZ, boolean holdsItems, boolean isInput, boolean itemSpins, float itemRenderSizeMultiplier, boolean isTriggerHitbox, Function<BuiltImmersiveInfo<?>, List<Pair<Component, Vec3>>> textSupplier, Function<BuiltImmersiveInfo<?>, ForcedUpDownRenderDir> forcedUpDownDir, boolean constantOffset, boolean needs3dCompat, HitboxVRMovementInfo vrMovementInfo, boolean renderItem, boolean renderItemCount, boolean forcedUpDownRenderDirConstant, ItemRotationType itemRotationType) {
        this.usedBuilder = usedBuilder;
        this.centerOffset = centerOffset;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.holdsItems = holdsItems;
        this.isInput = isInput;
        this.itemSpins = itemSpins;
        this.itemRenderSizeMultiplier = itemRenderSizeMultiplier;
        this.isTriggerHitbox = isTriggerHitbox;
        this.textSupplier = textSupplier;
        this.forcedUpDownRenderDir = forcedUpDownDir;
        this.constantOffset = constantOffset;
        this.needs3dCompat = needs3dCompat;
        this.vrMovementInfo = vrMovementInfo;
        this.renderItem = renderItem;
        this.renderItemCount = renderItemCount;
        this.forcedUpDownRenderDirConstant = forcedUpDownRenderDirConstant;
        this.itemRotationType = itemRotationType;
    }

    public void forceNull() {
        this.pos = null;
        this.box = null;
        this.didCalc = true;
        this.textData.clear();
        this.upDownRenderDir = null;
    }

    public void recalculate(Level level, HitboxPositioningMode mode, BuiltImmersiveInfoImpl<?> info) {
        this.lastPos = this.pos;
        Vec3 offset = this.centerOffset.apply(info);
        if (offset == null) {
            this.forceNull();
            return;
        }
        if (ActiveConfig.active().compatFor3dResourcePacks && this.needs3dCompat) {
            offset = offset.m_82520_(0.0, 0.0, 0.0625);
        }
        BlockPos pos = info.getBlockPosition();
        if (mode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING) {
            blockFacing = (Direction)level.m_8055_(pos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            this.recalcHorizBlockFacing(blockFacing, info, offset);
            this.upDownRenderDir = null;
        } else if (mode == HitboxPositioningMode.TOP_PLAYER_FACING) {
            this.recalcTopPlayerFacing(info.immersiveDir, info, offset);
            this.upDownRenderDir = Direction.UP;
        } else if (mode == HitboxPositioningMode.TOP_LITERAL) {
            this.xVec = new Vec3(1.0, 0.0, 0.0);
            this.yVec = new Vec3(0.0, 1.0, 0.0);
            this.zVec = new Vec3(0.0, 0.0, 1.0);
            this.centerPos = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, 1.0, 0.0);
            double actualXSize = this.sizeX;
            double actualYSize = this.sizeY;
            double actualZSize = this.sizeZ;
            this.pos = this.centerPos.m_82549_(this.xVec.m_82490_(offset.f_82479_)).m_82549_(this.yVec.m_82490_(offset.f_82480_)).m_82549_(this.zVec.m_82490_(offset.f_82481_));
            this.box = AABB.m_165882_((Vec3)this.pos, (double)actualXSize, (double)actualYSize, (double)actualZSize);
            this.upDownRenderDir = Direction.UP;
        } else if (mode == HitboxPositioningMode.TOP_BLOCK_FACING) {
            blockFacing = (Direction)level.m_8055_(pos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            this.recalcTopBottomBlockFacing(blockFacing, info, offset, false);
            this.upDownRenderDir = Direction.UP;
        } else if (mode == HitboxPositioningMode.HORIZONTAL_PLAYER_FACING) {
            blockFacing = ImmersiveLogicHelpers.instance().getHorizontalBlockForward((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition());
            this.recalcHorizBlockFacing(blockFacing, info, offset);
            this.upDownRenderDir = null;
        } else if (mode == HitboxPositioningMode.BLOCK_FACING_NEG_X) {
            blockFacing = (Direction)level.m_8055_(pos).m_61143_((Property)DirectionalBlock.f_52588_);
            if (blockFacing.m_122434_() != Direction.Axis.Y) {
                this.recalcHorizBlockFacing(blockFacing, info, offset);
                this.upDownRenderDir = null;
            } else {
                this.recalcTopBottomBlockFacing(Direction.SOUTH, info, offset, blockFacing == Direction.DOWN);
                this.upDownRenderDir = blockFacing;
            }
        } else if (mode == HitboxPositioningMode.PLAYER_FACING_NO_DOWN) {
            Direction playerFacing = Util.getForwardFromPlayerUpAndDown((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition());
            if (playerFacing == Direction.UP) {
                this.recalcTopPlayerFacing(info.immersiveDir, info, offset);
                this.upDownRenderDir = Direction.UP;
            } else {
                blockFacing = ImmersiveLogicHelpers.instance().getHorizontalBlockForward((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition());
                this.recalcHorizBlockFacing(blockFacing, info, offset);
                this.upDownRenderDir = null;
            }
        } else if (mode == HitboxPositioningMode.PLAYER_FACING_FILTER_BLOCK_FACING) {
            Direction dir = info.immersiveDir;
            Direction literalFacing = (Direction)level.m_8055_(pos).m_61143_((Property)DirectionalBlock.f_52588_);
            if (dir.m_122434_() == Direction.Axis.Y) {
                this.recalcTopBottomBlockFacing(literalFacing, info, offset, dir == Direction.DOWN);
            } else {
                this.recalcHorizBlockFacing(dir, info, offset, literalFacing);
                this.upDownRenderDir = null;
            }
        } else if (mode == HitboxPositioningMode.HORIZONTAL_BLOCK_FACING_ATTACHED_FLOOR_CEILING_REVERSED) {
            BlockState state = level.m_8055_(pos);
            blockFacing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            AttachFace attachFace = (AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_);
            switch (attachFace) {
                case FLOOR: 
                case CEILING: {
                    boolean isCeiling = attachFace == AttachFace.CEILING;
                    blockFacing = blockFacing.m_122424_();
                    this.recalcHorizBlockFacing(blockFacing, info, offset, isCeiling ? Direction.DOWN : Direction.UP);
                    this.upDownRenderDir = isCeiling ? Direction.DOWN : Direction.UP;
                    break;
                }
                case WALL: {
                    this.xVec = Vec3.m_82528_((Vec3i)blockFacing.m_122428_().m_122436_());
                    this.yVec = Vec3.m_82528_((Vec3i)blockFacing.m_122436_());
                    this.zVec = new Vec3(0.0, -1.0, 0.0);
                    this.centerPos = Vec3.m_82539_((Vec3i)info.getBlockPosition());
                    this.upDownRenderDir = null;
                    double actualXSize = blockFacing.m_122434_() == Direction.Axis.X ? this.sizeZ : this.sizeX;
                    double actualYSize = blockFacing.m_122434_() == Direction.Axis.X ? this.sizeX : this.sizeZ;
                    double actualZSize = this.sizeY;
                    this.pos = this.centerPos.m_82549_(this.xVec.m_82490_(offset.f_82479_)).m_82549_(this.yVec.m_82490_(offset.f_82480_)).m_82549_(this.zVec.m_82490_(offset.f_82481_));
                    this.box = AABB.m_165882_((Vec3)this.pos, (double)actualXSize, (double)actualYSize, (double)actualZSize);
                }
            }
        } else {
            throw new UnsupportedOperationException("Hitbox calculation for positioning mode " + mode + " unimplemented!");
        }
        this.calcTextOffsets(info);
        ForcedUpDownRenderDir forcedDirApplied = this.forcedUpDownRenderDir.apply(info);
        if (forcedDirApplied != ForcedUpDownRenderDir.NOT_FORCED) {
            this.upDownRenderDir = forcedDirApplied.direction;
        }
        if (this.vrMovementInfo != null && VRPluginVerify.clientInVR()) {
            boolean[] passed = new boolean[]{false, false};
            for (int c = 0; c <= 1; ++c) {
                Vec3 velocityMask;
                double negThreshold;
                double posThreshold;
                if (!LastClientVRData.canGetVelocityChange() || !this.box.m_82390_(VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getController(c).position())) continue;
                Vec3 velocity = LastClientVRData.changeForVelocity(c == 0 ? LastClientVRData.VRType.C0 : LastClientVRData.VRType.C1);
                if (this.vrMovementInfo.relativeAxis() == null) {
                    passed[c] = velocity.m_82556_() >= this.vrMovementInfo.thresholds()[0] * this.vrMovementInfo.thresholds()[0];
                    continue;
                }
                if (this.vrMovementInfo.thresholds().length == 2) {
                    posThreshold = Math.max(this.vrMovementInfo.thresholds()[0], this.vrMovementInfo.thresholds()[1]);
                    negThreshold = Math.min(this.vrMovementInfo.thresholds()[0], this.vrMovementInfo.thresholds()[1]);
                } else {
                    posThreshold = Math.max(this.vrMovementInfo.thresholds()[0], 0.0);
                    negThreshold = Math.min(this.vrMovementInfo.thresholds()[0], 0.0);
                }
                Vec3 vec3 = this.vrMovementInfo.relativeAxis() == Direction.Axis.X ? this.xVec : (velocityMask = this.vrMovementInfo.relativeAxis() == Direction.Axis.Y ? this.yVec : this.zVec);
                if (posThreshold != 0.0) {
                    boolean bl = passed[c] = this.getNonZeroComponent(velocity.m_82559_(velocityMask)) >= posThreshold;
                }
                if (negThreshold == 0.0) continue;
                passed[c] = passed[c] || this.getNonZeroComponent(velocity.m_82559_(velocityMask)) <= negThreshold;
            }
            if (switch (this.vrMovementInfo.controllerMode()) {
                case HitboxVRMovementInfoBuilder.ControllerMode.PRIMARY -> passed[0];
                case HitboxVRMovementInfoBuilder.ControllerMode.SECONDARY -> passed[1];
                case HitboxVRMovementInfoBuilder.ControllerMode.EITHER -> passed[0] || passed[1];
                case HitboxVRMovementInfoBuilder.ControllerMode.BOTH -> passed[0] && passed[1];
                default -> throw new IllegalArgumentException("Invalid controllerMOde for HitboxVRMovementInfo.");
            }) {
                ArrayList<InteractionHand> passedHands = new ArrayList<InteractionHand>(2);
                if (passed[0]) {
                    passedHands.add(InteractionHand.MAIN_HAND);
                }
                if (passed[1]) {
                    passedHands.add(InteractionHand.OFF_HAND);
                }
                this.vrMovementInfo.actionConsumer().accept(info, passedHands);
            }
        }
        this.didCalc = true;
    }

    public AABB getRenderHitbox(float partialTick) {
        if (!this.didCalc) {
            throw new IllegalStateException("Should call recalculate() or forceNull() before getting render hitbox.");
        }
        if (this.lastPos == null || this.constantOffset) {
            return this.box;
        }
        return this.box.m_82383_(ClientUtil.lerpVec3(this.lastPos, this.pos, partialTick).m_82546_(this.lastPos));
    }

    public void onOrientationChange() {
        this.lastPos = null;
    }

    private void recalcHorizBlockFacing(Direction blockFacing, BuiltImmersiveInfoImpl<?> info, Vec3 offset) {
        this.recalcHorizBlockFacing(blockFacing, info, offset, Direction.UP);
    }

    private void recalcHorizBlockFacing(Direction blockFacing, BuiltImmersiveInfoImpl<?> info, Vec3 offset, Direction blockLiteralFacing) {
        BlockPos pos = info.getBlockPosition();
        this.xVec = blockLiteralFacing.m_122434_() != Direction.Axis.Y ? new Vec3(0.0, 1.0, 0.0) : Vec3.m_82528_((Vec3i)blockFacing.m_122428_().m_122436_());
        this.yVec = Vec3.m_82528_((Vec3i)blockLiteralFacing.m_122436_());
        this.zVec = Vec3.m_82528_((Vec3i)blockFacing.m_122436_());
        this.centerPos = Vec3.m_82512_((Vec3i)info.getBlockPosition()).m_82549_(this.zVec.m_82490_(0.5));
        double actualXSize = blockFacing.m_122434_() == Direction.Axis.X ? this.sizeZ : this.sizeX;
        double actualYSize = this.sizeY;
        double actualZSize = blockFacing.m_122434_() == Direction.Axis.X ? this.sizeX : this.sizeZ;
        this.pos = this.centerPos.m_82549_(this.xVec.m_82490_(offset.f_82479_)).m_82549_(this.yVec.m_82490_(offset.f_82480_)).m_82549_(this.zVec.m_82490_(offset.f_82481_));
        this.box = AABB.m_165882_((Vec3)this.pos, (double)actualXSize, (double)actualYSize, (double)actualZSize);
    }

    private void recalcTopBottomBlockFacing(Direction blockFacing, BuiltImmersiveInfoImpl<?> info, Vec3 offset, boolean bottomOfBlock) {
        BlockPos pos = info.getBlockPosition();
        this.xVec = Vec3.m_82528_((Vec3i)blockFacing.m_122427_().m_122436_());
        this.yVec = Vec3.m_82528_((Vec3i)blockFacing.m_122436_());
        this.zVec = new Vec3(0.0, 1.0, 0.0);
        this.centerPos = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, bottomOfBlock ? 0.0 : 1.0, 0.0);
        double actualXSize = blockFacing.m_122434_() == Direction.Axis.X ? this.sizeY : this.sizeX;
        double actualYSize = this.sizeZ;
        double actualZSize = blockFacing.m_122434_() == Direction.Axis.X ? this.sizeX : this.sizeY;
        this.pos = this.centerPos.m_82549_(this.xVec.m_82490_(offset.f_82479_)).m_82549_(this.yVec.m_82490_(offset.f_82480_)).m_82549_(this.zVec.m_82490_(offset.f_82481_));
        this.box = AABB.m_165882_((Vec3)this.pos, (double)actualXSize, (double)actualYSize, (double)actualZSize);
    }

    private void recalcTopPlayerFacing(Direction playerFacing, BuiltImmersiveInfoImpl<?> info, Vec3 offset) {
        BlockPos pos = info.getBlockPosition();
        this.xVec = Vec3.m_82528_((Vec3i)playerFacing.m_122428_().m_122436_());
        this.yVec = Vec3.m_82528_((Vec3i)playerFacing.m_122424_().m_122436_());
        this.zVec = new Vec3(0.0, 1.0, 0.0);
        this.centerPos = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, 1.0, 0.0);
        double actualXSize = playerFacing.m_122434_() == Direction.Axis.X ? this.sizeY : this.sizeX;
        double actualYSize = this.sizeZ;
        double actualZSize = playerFacing.m_122434_() == Direction.Axis.X ? this.sizeX : this.sizeY;
        this.pos = this.centerPos.m_82549_(this.xVec.m_82490_(offset.f_82479_)).m_82549_(this.yVec.m_82490_(offset.f_82480_)).m_82549_(this.zVec.m_82490_(offset.f_82481_));
        this.box = AABB.m_165882_((Vec3)this.pos, (double)actualXSize, (double)actualYSize, (double)actualZSize);
    }

    private void calcTextOffsets(BuiltImmersiveInfoImpl<?> info) {
        if (this.textSupplier != null) {
            List<Pair<Component, Vec3>> textList = this.textSupplier.apply(info);
            this.textData.clear();
            if (textList != null) {
                for (Pair<Component, Vec3> pair : textList) {
                    if (pair == null) continue;
                    this.textData.add(new TextData((Component)pair.getFirst(), this.xVec.m_82490_(((Vec3)pair.getSecond()).f_82479_).m_82549_(this.yVec.m_82490_(((Vec3)pair.getSecond()).f_82480_)).m_82549_(this.zVec.m_82490_(((Vec3)pair.getSecond()).f_82481_))));
                }
            }
        }
    }

    private double getNonZeroComponent(Vec3 vec) {
        return vec.f_82479_ != 0.0 ? vec.f_82479_ : (vec.f_82480_ != 0.0 ? vec.f_82480_ : vec.f_82481_);
    }

    public AABB getAABB() {
        if (!this.didCalc) {
            throw new IllegalStateException("Should call recalculate() or forceNull() before getting hitbox.");
        }
        return this.box;
    }

    public Direction getUpDownRenderDir() {
        if (!this.didCalc) {
            throw new IllegalStateException("Should call recalculate() or forceNull() before getting upDownRenderDir.");
        }
        return this.upDownRenderDir;
    }

    public boolean hasAABB() {
        return this.box != null;
    }

    public List<TextData> getTextData() {
        return this.textData;
    }

    public boolean calcDone() {
        return this.didCalc;
    }

    public Object clone() {
        return this.cloneWithNewOffset(this.centerOffset);
    }

    public RelativeHitboxInfoImpl cloneWithNewOffset(Function<BuiltImmersiveInfo<?>, Vec3> newOffset) {
        return ((RelativeHitboxInfoBuilderImpl)this.getBuilderClone().setCenterOffset((Function)newOffset)).build();
    }

    @Override
    public RelativeHitboxInfoImpl cloneWithAddedOffset(Vec3 offset) {
        return ((RelativeHitboxInfoBuilderImpl)this.getBuilderClone().setCenterOffset(info -> {
            Vec3 offsetOut = this.centerOffset.apply((BuiltImmersiveInfo<?>)info);
            if (offsetOut == null) {
                return null;
            }
            return offsetOut.m_82549_(offset);
        })).build();
    }

    @Override
    public RelativeHitboxInfoBuilderImpl getBuilderClone() {
        return this.usedBuilder.clone();
    }

    @Override
    public BoundingBox getHitbox() {
        return this.hasAABB() ? this.getAABB() : null;
    }

    @Override
    public boolean isTriggerHitbox() {
        return this.isTriggerHitbox;
    }
}

