/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.HitboxInfoFactory;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.AbstractDragImmersive;
import com.hammy275.immersivemc.client.immersive.info.DragImmersiveInfo;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.NullStorage;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.UsePacket;
import com.hammy275.immersivemc.common.util.Util;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ImmersiveTrapdoor
extends AbstractDragImmersive {
    private static final AbstractDragImmersive.AutoDragSettings settings = new AbstractDragImmersive.AutoDragSettings(List.of(Integer.valueOf(2)), true);

    @Override
    protected void hitboxDragged(DragImmersiveInfo info, int controller, int oldIndex, int newIndex) {
        if (newIndex == 1) {
            Util.useTrapdoor((Player)Minecraft.m_91087_().f_91074_, (Level)Minecraft.m_91087_().f_91073_, info.getBlockPosition());
            Network.INSTANCE.sendToServer(new UsePacket(info.getBlockPosition()));
        }
    }

    @Override
    protected AbstractDragImmersive.AutoDragSettings autoDragSettings() {
        return settings;
    }

    @Override
    public DragImmersiveInfo buildInfo(BlockPos pos, Level level) {
        DragImmersiveInfo info = new DragImmersiveInfo(pos);
        for (int i = 0; i < 3; ++i) {
            info.hitboxes.add(null);
        }
        info.startingHitboxIndex = 0;
        this.makeHitboxes(info, level);
        return info;
    }

    @Override
    public ImmersiveHandler<NullStorage> getHandler() {
        return ImmersiveHandlers.trapdoorHandler;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return ClientUtil.createConfigScreenInfo("trapdoor", () -> new ItemStack((ItemLike)Items.f_42056_), config -> config.useTrapdoorImmersive, (config, newVal) -> {
            config.useTrapdoorImmersive = newVal;
        });
    }

    @Override
    protected void makeHitboxes(DragImmersiveInfo info, Level level) {
        AABB end;
        BlockState state = level.m_8055_(info.getBlockPosition());
        Direction trapdoorWallDir = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
        boolean closesTop = state.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        boolean isOpen = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
        VoxelShape currentShape = state.m_60808_((BlockGetter)level, info.getBlockPosition());
        AABB start = currentShape.m_83215_().m_82338_(info.getBlockPosition()).m_82400_(1.0E-4);
        Vec3 endPos = Vec3.m_82539_((Vec3i)info.getBlockPosition());
        if (isOpen) {
            endPos = closesTop ? endPos.m_82520_(0.0, 0.8125, 0.0) : endPos.m_82520_(0.0, 0.1875, 0.0);
            end = AABB.m_165882_((Vec3)endPos, (double)1.0, (double)0.375, (double)1.0);
        } else {
            endPos = endPos.m_82549_(Vec3.m_82528_((Vec3i)trapdoorWallDir.m_122436_()).m_82490_(0.3125)).m_82520_(0.0, 0.5, 0.0);
            double xSize = trapdoorWallDir.m_122434_() == Direction.Axis.X ? 0.375 : 1.0;
            double zSize = xSize == 1.0 ? 0.375 : 1.0;
            end = AABB.m_165882_((Vec3)endPos, (double)xSize, (double)1.0, (double)zSize);
        }
        end = end.m_82400_(1.0E-4);
        AABB bounds = new AABB(info.getBlockPosition()).m_82400_(0.001);
        info.hitboxes.set(0, HitboxInfoFactory.instance().interactHitbox((BoundingBox)start));
        info.hitboxes.set(1, HitboxInfoFactory.instance().interactHitbox((BoundingBox)end));
        info.hitboxes.set(2, HitboxInfoFactory.instance().interactHitbox((BoundingBox)bounds));
    }
}

