/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.OBBFactory;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.AbstractPlayerAttachmentImmersive;
import com.hammy275.immersivemc.client.immersive.info.AbstractPlayerAttachmentInfo;
import com.hammy275.immersivemc.client.immersive.info.ImmersiveHitboxesInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.NullStorage;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.common.vr.VRRumble;
import com.mojang.blaze3d.vertex.PoseStack;
import net.blf02.vrapi.api.data.IVRData;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ImmersiveHitboxes
extends AbstractPlayerAttachmentImmersive<ImmersiveHitboxesInfo, NullStorage> {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final double backpackHeight = 0.625;
    private static final Vec3 DOWN = new Vec3(0.0, -1.0, 0.0);
    private int backpackCooldown = 0;

    public ImmersiveHitboxes() {
        super(1);
        this.forceDisableItemGuide = true;
        this.forceTickEvenIfNoTrack = true;
    }

    @Override
    protected void renderTick(ImmersiveHitboxesInfo info, boolean isInVR) {
        super.renderTick(info, isInVR);
        if (ActiveConfig.active().reachBehindBagMode.usesBehindBack() && VRPluginVerify.clientInVR()) {
            Vec3 headLook;
            double yaw;
            Vec3 centerPos;
            IVRData hmdData = Platform.isDevelopmentEnvironment() ? null : VRPlugin.API.getRenderVRPlayer().getHMD();
            Vec3 vec3 = centerPos = hmdData != null ? hmdData.position().m_82520_(0.0, -0.5, 0.0).m_82549_(hmdData.getLookAngle().m_82490_(-0.15)) : ImmersiveHitboxes.mc.f_91074_.m_20299_(mc.m_91296_()).m_82520_(0.0, -0.5, 0.0).m_82549_(ImmersiveHitboxes.mc.f_91074_.m_20154_().m_82490_(-0.15));
            if (VRPluginVerify.clientInVR() && VRPlugin.API.playerInVR((Player)ImmersiveHitboxes.mc.f_91074_) && !Platform.isDevelopmentEnvironment()) {
                yaw = Math.toRadians(hmdData.getYaw());
                headLook = hmdData.getLookAngle();
            } else {
                yaw = Math.toRadians(ImmersiveHitboxes.mc.f_91074_.m_146908_());
                headLook = ImmersiveHitboxes.mc.f_91074_.m_20154_();
            }
            headLook = headLook.m_82542_(1.0, 0.0, 1.0).m_82541_();
            centerPos = centerPos.m_82549_(headLook.m_82490_(-0.25));
            info.setHitbox(0, OBBFactory.instance().create(AABB.m_165882_((Vec3)centerPos, (double)0.35, (double)0.625, (double)0.2), 0.0, yaw, 0.0));
        } else {
            info.setHitbox(0, null);
        }
        if (ActiveConfig.active().reachBehindBagMode.usesOverShoulder() && VRPluginVerify.clientInVR()) {
            boolean behindHMD;
            int cNum = ActiveConfig.active().swapBagHand ? 0 : 1;
            IVRData hmdData = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((Player)ImmersiveHitboxes.mc.f_91074_).getHMD() : VRPlugin.API.getRenderVRPlayer().getHMD();
            IVRData cData = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((Player)ImmersiveHitboxes.mc.f_91074_).getController(cNum) : VRPlugin.API.getRenderVRPlayer().getController(cNum);
            Vec3 hmdDir = hmdData.getLookAngle();
            Vec3 hmdPos = hmdData.position();
            Vec3 cDir = cData.getLookAngle();
            Vec3 cPos = cData.position();
            Vec3 cToHMDDir = cPos.m_82546_(hmdPos).m_82541_();
            double angleToDown = Math.acos(DOWN.m_82526_(cDir));
            boolean pointingDown = angleToDown < 1.5707963267948966;
            double cHMDAngleDiff = Math.acos(cToHMDDir.m_82526_(hmdDir));
            boolean bl = behindHMD = cHMDAngleDiff > 2.0943951023931953;
            if (pointingDown && behindHMD) {
                this.doBagOpen((Player)ImmersiveHitboxes.mc.f_91074_);
            }
        }
    }

    @Override
    @Nullable
    public ImmersiveHandler getHandler() {
        return null;
    }

    @Override
    protected void doTick(ImmersiveHitboxesInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        if (this.backpackCooldown > 0) {
            --this.backpackCooldown;
        }
    }

    @Override
    public boolean shouldRender(ImmersiveHitboxesInfo info, boolean isInVR) {
        return true;
    }

    @Override
    protected void render(ImmersiveHitboxesInfo info, PoseStack stack, boolean isInVR) {
        BoundingBox backpackHitbox = info.getHitbox(0);
        if (backpackHitbox != null) {
            IVRData c;
            this.renderHitbox(stack, backpackHitbox);
            if (VRPluginVerify.hasAPI && VRPlugin.API.playerInVR((Player)ImmersiveHitboxes.mc.f_91074_) && mc.m_91290_().m_114377_() && BoundingBox.contains(backpackHitbox, (c = VRPlugin.API.getVRPlayer((Player)ImmersiveHitboxes.mc.f_91074_).getController(ActiveConfig.active().swapBagHand ? 0 : 1)).position())) {
                ImmersiveHitboxes.renderHitbox(stack, (BoundingBox)AABB.m_165882_((Vec3)c.position(), (double)0.25, (double)0.25, (double)0.25), true, 0.0f, 1.0f, 0.0f);
            }
        }
    }

    @Override
    public boolean enabledInConfig() {
        return true;
    }

    @Override
    protected boolean inputSlotShouldRenderHelpHitbox(ImmersiveHitboxesInfo info, int slotNum) {
        return false;
    }

    @Override
    public boolean shouldTrack(BlockPos pos, Level level) {
        return true;
    }

    @Override
    public ImmersiveHitboxesInfo refreshOrTrackObject(BlockPos pos, Level level) {
        return null;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractPlayerAttachmentInfo info) {
        return false;
    }

    @Override
    protected void initInfo(ImmersiveHitboxesInfo info) {
    }

    @Override
    public void handleRightClick(AbstractPlayerAttachmentInfo info, Player player, int closest, InteractionHand hand) {
        if (info instanceof ImmersiveHitboxesInfo) {
            ImmersiveHitboxesInfo hInfo = (ImmersiveHitboxesInfo)info;
            if (closest == 0 && (hand == InteractionHand.OFF_HAND && !ActiveConfig.active().swapBagHand || hand == InteractionHand.MAIN_HAND && ActiveConfig.active().swapBagHand)) {
                this.doBagOpen(player);
            }
        }
    }

    @Override
    public void processStorageFromNetwork(AbstractPlayerAttachmentInfo info, NullStorage storage) {
    }

    @Override
    public BlockPos getLightPos(ImmersiveHitboxesInfo info) {
        return info.getBlockPosition();
    }

    public void initImmersiveIfNeeded() {
        if (this.infos.isEmpty()) {
            this.infos.add(new ImmersiveHitboxesInfo());
        }
    }

    private void doBagOpen(Player player) {
        if (this.backpackCooldown <= 0 && ActiveConfig.active().useBagImmersive) {
            VRRumble.rumbleIfVR((Player)ImmersiveHitboxes.mc.f_91074_, ActiveConfig.active().swapBagHand ? 0 : 1, 0.05f);
            ClientUtil.openBag(player);
            this.backpackCooldown = 50;
        }
    }
}

