/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientConstants;
import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.ChestInfo;
import com.hammy275.immersivemc.common.compat.Lootr;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.ListOfItemsStorage;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.ChestShulkerOpenPacket;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.common.vr.VRRumble;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ImmersiveChest
extends AbstractImmersive<ChestInfo, ListOfItemsStorage> {
    public static final double spacing = 0.1875;
    private final double threshold = 0.03;
    public int openCloseCooldown = 0;

    @Override
    public void globalTick() {
        super.globalTick();
        if (this.openCloseCooldown > 0) {
            --this.openCloseCooldown;
        }
        this.infos.removeIf(info -> !this.chestsValid((ChestInfo)info));
    }

    @Override
    public ChestInfo buildInfo(BlockPos pos, Level level) {
        BlockEntity blockEnt = level.m_7702_(pos);
        if (blockEnt instanceof ChestBlockEntity) {
            return new ChestInfo(blockEnt, (BlockEntity)Util.getOtherChest((ChestBlockEntity)blockEnt));
        }
        if (blockEnt instanceof EnderChestBlockEntity) {
            return new ChestInfo(blockEnt, null);
        }
        throw new IllegalArgumentException("ImmersiveChest can only track chests and ender chests!");
    }

    @Override
    public int handleHitboxInteract(ChestInfo info, LocalPlayer player, List<Integer> hitboxIndices, InteractionHand hand, boolean modifierPressed) {
        if (!info.isOpen) {
            return -1;
        }
        ImmersiveClientLogicHelpers.instance().sendSwapPacket(info.getBlockPosition(), hitboxIndices, hand, false);
        return ImmersiveClientConstants.instance().defaultCooldown();
    }

    @Override
    public boolean shouldRender(ChestInfo info) {
        return info.hasHitboxes();
    }

    @Override
    public void render(ChestInfo info, PoseStack stack, ImmersiveRenderHelpers helpers, float partialTick) {
        int i;
        if (info.isOpen) {
            boolean showCount;
            int endTop;
            int startTop;
            for (i = 0; i < 27; ++i) {
                startTop = 9 * info.getRowNum();
                endTop = startTop + 9;
                showCount = i >= startTop && i <= endTop;
                helpers.renderItemWithInfo(info.hitboxes.get((int)i).item, stack, 0.25f, showCount, info.light, info, true, i, null, info.forward, Direction.UP);
            }
            if (info.otherChest != null) {
                for (i = 27; i < 54; ++i) {
                    startTop = 9 * info.getRowNum() + 27;
                    endTop = startTop + 9 + 27;
                    showCount = i >= startTop && i <= endTop;
                    helpers.renderItemWithInfo(info.hitboxes.get((int)i).item, stack, 0.25f, showCount, info.light, info, true, i, null, info.forward, Direction.UP);
                }
            }
        }
        for (i = 0; i <= 1; ++i) {
            if (info.openCloseHitboxes[i] == null || info.openClosePositions[i] == null) continue;
            helpers.renderHitbox(stack, (BoundingBox)info.openCloseHitboxes[i]);
        }
    }

    @Override
    public void tick(ChestInfo info) {
        BlockEntity chest;
        super.tick(info);
        info.light = ImmersiveClientLogicHelpers.instance().getLight(info.getBlockPosition().m_7494_());
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(info.getBlockPosition());
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity cbe = (ChestBlockEntity)blockEntity;
            info.otherChest = Util.getOtherChest(cbe);
        }
        BlockEntity[] chests = new BlockEntity[]{info.chest, info.otherChest};
        for (int i = 0; i <= 1; ++i) {
            chest = chests[i];
            if (chest == null) continue;
            info.forward = (Direction)chest.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Vec3[] positions = Util.get3x3HorizontalGrid(chest.m_58899_(), 0.1875, info.forward, false);
            float hitboxSize = 0.18333334f;
            int startTop = 9 * info.getRowNum() + 27 * i;
            int endTop = startTop + 9;
            for (int z = startTop; z < endTop; ++z) {
                Vec3 pos = positions[z % 9];
                double offset = (double)(z - startTop) * 2.0E-4;
                info.getAllHitboxes().get((int)z).box = AABB.m_165882_((Vec3)pos.m_82520_(offset, -0.2 + offset, offset), (double)hitboxSize, (double)hitboxSize, (double)hitboxSize);
            }
            int startMid = 9 * info.getNextRow(info.getRowNum()) + 27 * i;
            int endMid = startMid + 9;
            for (int z = startMid; z < endMid; ++z) {
                Vec3 pos = positions[z % 9];
                double offset = (double)(z - startMid) * 2.0E-4;
                info.getAllHitboxes().get((int)z).box = AABB.m_165882_((Vec3)pos.m_82520_(offset, -0.325 + offset, offset), (double)0.0, (double)0.0, (double)0.0);
            }
            int startBot = 9 * info.getNextRow(info.getNextRow(info.getRowNum())) + 27 * i;
            int endBot = startBot + 9;
            for (int z = startBot; z < endBot; ++z) {
                Vec3 pos = positions[z % 9];
                double offset = (double)(z - startBot) * 2.0E-4;
                info.getAllHitboxes().get((int)z).box = AABB.m_165882_((Vec3)pos.m_82520_(offset, -0.45 + offset, offset), (double)0.0, (double)0.0, (double)0.0);
            }
        }
        for (int chestNum = 0; chestNum <= 1; ++chestNum) {
            Vec3 linePos;
            chest = chests[chestNum];
            if (chest == null) continue;
            Vec3 forward = Vec3.m_82528_((Vec3i)info.forward.m_122436_());
            Vec3 left = Vec3.m_82528_((Vec3i)info.forward.m_122428_().m_122436_());
            Vec3 frontMid = Vec3.m_82514_((Vec3i)chest.m_58899_(), (double)1.0).m_82549_(forward.m_82542_(0.5, 0.5, 0.5));
            if (info.isOpen) {
                linePos = frontMid.m_82549_(forward.m_82542_(-0.5, -0.5, -0.5));
                info.openClosePositions[chestNum] = linePos = linePos.m_82520_(0.0, 0.5, 0.0);
                info.openCloseHitboxes[chestNum] = new AABB(linePos.m_82549_(left.m_82542_(-0.5, -0.5, -0.5)).m_82520_(0.0, -0.25, 0.0).m_82549_(forward.m_82542_(-0.625, -0.625, -0.625)), linePos.m_82549_(left.m_82542_(0.5, 0.5, 0.5)).m_82520_(0.0, 0.25, 0.0).m_82549_(forward.m_82542_(0.625, 0.625, 0.625)));
                continue;
            }
            info.openClosePositions[chestNum] = linePos = frontMid.m_82520_(0.0, -0.375, 0.0);
            info.openCloseHitboxes[chestNum] = new AABB(linePos.m_82549_(left.m_82542_(-0.5, -0.5, -0.5)).m_82520_(0.0, -0.25, 0.0).m_82549_(forward.m_82542_(-0.15, -0.15, -0.15)), linePos.m_82549_(left.m_82542_(0.5, 0.5, 0.5)).m_82520_(0.0, 0.25, 0.0).m_82549_(forward.m_82542_(0.15, 0.15, 0.15)));
        }
        if (this.openCloseCooldown <= 0 && !ActiveConfig.active().rightClickChestInteractions && VRPluginVerify.clientInVR() && VRPlugin.API.apiActive((Player)Minecraft.m_91087_().f_91074_) && info.openCloseHitboxes != null) {
            boolean cond;
            Vec3 current0 = VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getController0().position();
            Vec3 current1 = VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getController1().position();
            double diff0 = current0.f_82480_ - info.lastY0;
            double diff1 = current1.f_82480_ - info.lastY1;
            if (Util.getFirstIntersect(current0, (BoundingBox[])info.openCloseHitboxes).isEmpty()) {
                diff0 = 0.0;
            }
            if (Util.getFirstIntersect(current1, (BoundingBox[])info.openCloseHitboxes).isEmpty()) {
                diff1 = 0.0;
            }
            if (info.isOpen) {
                cond = diff0 <= -0.03 || diff1 <= -0.03;
            } else {
                boolean bl = cond = diff0 >= 0.03 || diff1 >= 0.03;
            }
            if (cond) {
                if (!info.isOpen) {
                    if (diff0 >= 0.03) {
                        VRRumble.rumbleIfVR((Player)Minecraft.m_91087_().f_91074_, 0, 0.15f);
                        if (diff1 >= 0.006 && current0.m_82557_(current1) <= 1.0) {
                            VRRumble.rumbleIfVR((Player)Minecraft.m_91087_().f_91074_, 1, 0.15f);
                        }
                    }
                    if (diff1 >= 0.03) {
                        VRRumble.rumbleIfVR((Player)Minecraft.m_91087_().f_91074_, 1, 0.15f);
                        if (diff0 >= 0.006 && current0.m_82557_(current1) <= 1.0) {
                            VRRumble.rumbleIfVR((Player)Minecraft.m_91087_().f_91074_, 0, 0.15f);
                        }
                    }
                }
                ImmersiveChest.openChest(info);
                this.openCloseCooldown = 40;
            }
            info.lastY0 = current0.f_82480_;
            info.lastY1 = current1.f_82480_;
        }
    }

    @Nullable
    public AABB getDragHitbox(ChestInfo info) {
        return null;
    }

    @Override
    public boolean isInputHitbox(ChestInfo info, int hitboxIndex) {
        return true;
    }

    @Override
    public ImmersiveHandler<ListOfItemsStorage> getHandler() {
        return ImmersiveHandlers.chestHandler;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return ClientUtil.createConfigScreenInfo("chest", () -> new ItemStack((ItemLike)Items.f_42009_), config -> config.useChestImmersive, (config, newVal) -> {
            config.useChestImmersive = newVal;
        });
    }

    @Override
    public boolean shouldDisableRightClicksWhenVanillaInteractionsDisabled(ChestInfo info) {
        return true;
    }

    @Override
    public void processStorageFromNetwork(ChestInfo info, ListOfItemsStorage storage) {
        for (int i = 0; i < storage.getItems().size(); ++i) {
            info.hitboxes.get((int)i).item = storage.getItems().get(i);
        }
    }

    @Override
    public boolean isVROnly() {
        return false;
    }

    public boolean chestsValid(ChestInfo info) {
        try {
            boolean mainChestExists = this.getHandler().isValidBlock(info.getBlockPosition(), info.chest.m_58904_());
            boolean otherChestExists = info.otherChest == null || info.chest.m_58904_() != null && info.chest.m_58904_().m_7702_(info.otherPos) instanceof ChestBlockEntity;
            return mainChestExists && otherChestExists;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static ChestInfo findImmersive(BlockEntity chest) {
        Objects.requireNonNull(chest);
        for (ChestInfo info : Immersives.immersiveChest.getTrackedObjects()) {
            if (info.chest != chest && info.otherChest != chest) continue;
            return info;
        }
        return null;
    }

    public static void openChest(ChestInfo info) {
        info.isOpen = !info.isOpen;
        Network.INSTANCE.sendToServer(new ChestShulkerOpenPacket(info.getBlockPosition(), info.isOpen));
        if (info.isOpen) {
            Lootr.lootrImpl.markOpener((Player)Minecraft.m_91087_().f_91074_, info.getBlockPosition());
        }
    }
}

