/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.api_impl.ImmersiveRenderHelpersImpl;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractPlayerAttachmentInfo;
import com.hammy275.immersivemc.client.immersive.info.InfoTriggerHitboxes;
import com.hammy275.immersivemc.client.subscribe.ClientRenderSubscriber;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPlayerAttachmentImmersive<I extends AbstractPlayerAttachmentInfo, S extends NetworkStorage> {
    public static final int maxLight = LightTexture.m_109885_((int)15, (int)15);
    protected final List<I> infos;
    public final int maxImmersives;
    protected boolean forceDisableItemGuide = false;
    public boolean forceTickEvenIfNoTrack = false;

    public AbstractPlayerAttachmentImmersive(int maxImmersives) {
        Immersives.IMMERSIVE_ATTACHMENTS.add(this);
        this.maxImmersives = maxImmersives;
        this.infos = new ArrayList<I>(maxImmersives > 0 ? maxImmersives + 1 : 16);
    }

    public Vec3 playerPos() {
        return ClientUtil.playerPos();
    }

    protected void renderTick(I info, boolean isInVR) {
    }

    public void globalTick() {
    }

    public boolean clientAuthoritative() {
        return false;
    }

    @Nullable
    public abstract ImmersiveHandler<S> getHandler();

    public boolean hitboxesAvailable(AbstractPlayerAttachmentInfo info) {
        return true;
    }

    public abstract boolean shouldRender(I var1, boolean var2);

    protected abstract void render(I var1, PoseStack var2, boolean var3);

    public abstract boolean enabledInConfig();

    protected abstract boolean inputSlotShouldRenderHelpHitbox(I var1, int var2);

    public abstract boolean shouldTrack(BlockPos var1, Level var2);

    @Nullable
    public abstract I refreshOrTrackObject(BlockPos var1, Level var2);

    public abstract boolean shouldBlockClickIfEnabled(AbstractPlayerAttachmentInfo var1);

    protected abstract void initInfo(I var1);

    public void onAnyRightClick(AbstractPlayerAttachmentInfo info) {
    }

    public boolean isVROnly() {
        return false;
    }

    public abstract void handleRightClick(AbstractPlayerAttachmentInfo var1, Player var2, int var3, InteractionHand var4);

    public void handleTriggerHitboxRightClick(InfoTriggerHitboxes info, Player player, int hitboxNum) {
    }

    public void onRemove(I info) {
    }

    protected boolean slotHelpBoxIsSelected(I info, int slotNum) {
        return ((AbstractPlayerAttachmentInfo)info).slotHovered(slotNum);
    }

    public abstract void processStorageFromNetwork(AbstractPlayerAttachmentInfo var1, S var2);

    public void tick(I info, boolean isInVR) {
        if (this.enabledInConfig()) {
            if (!((AbstractPlayerAttachmentInfo)info).initCompleted) {
                this.initInfo(info);
                ((AbstractPlayerAttachmentInfo)info).initCompleted = true;
            }
            if (Minecraft.m_91087_().f_91073_ != null && (this.shouldTrack(((AbstractPlayerAttachmentInfo)info).getBlockPosition(), (Level)Minecraft.m_91087_().f_91073_) || this.forceTickEvenIfNoTrack)) {
                this.doTick(info, isInVR);
                ((AbstractPlayerAttachmentInfo)info).setInputSlots();
                ((AbstractPlayerAttachmentInfo)info).light = this.hasMultipleLightPositions(info) ? this.getLight(this.getLightPositions(info)) : this.getLight(this.getLightPos(info));
            } else {
                ((AbstractPlayerAttachmentInfo)info).remove();
            }
        }
    }

    public int getCooldownVR() {
        return 12;
    }

    public int getCooldownDesktop() {
        return 8;
    }

    protected void doTick(I info, boolean isInVR) {
        if (((AbstractPlayerAttachmentInfo)info).getItemTransitionCountdown() > 1 && ((AbstractPlayerAttachmentInfo)info).getTicksLeft() > 20) {
            ((AbstractPlayerAttachmentInfo)info).changeItemTransitionCountdown(-1);
        } else if (((AbstractPlayerAttachmentInfo)info).getItemTransitionCountdown() < 10 && ((AbstractPlayerAttachmentInfo)info).getTicksLeft() <= 20) {
            ((AbstractPlayerAttachmentInfo)info).changeItemTransitionCountdown(1);
        }
        if (((AbstractPlayerAttachmentInfo)info).getTicksLeft() > 0) {
            ((AbstractPlayerAttachmentInfo)info).changeTicksLeft(-1);
        }
        ++((AbstractPlayerAttachmentInfo)info).ticksActive;
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20238_(Vec3.m_82512_((Vec3i)((AbstractPlayerAttachmentInfo)info).getBlockPosition())) > 256.0) {
            ((AbstractPlayerAttachmentInfo)info).remove();
        }
    }

    public abstract BlockPos getLightPos(I var1);

    public boolean hasMultipleLightPositions(I info) {
        return false;
    }

    public BlockPos[] getLightPositions(I info) {
        return new BlockPos[0];
    }

    public void doRender(I info, PoseStack stack, boolean isInVR) {
        if (this.shouldRender(info, isInVR)) {
            try {
                this.renderTick(info, isInVR);
                this.render(info, stack, isInVR);
                if (ActiveConfig.active().placementGuideMode != PlacementGuideMode.OFF && !this.forceDisableItemGuide && this.nearbyItemGuideRenderCheck(info)) {
                    for (int i = 0; i < ((AbstractPlayerAttachmentInfo)info).getInputSlots().length; ++i) {
                        if (!this.inputSlotShouldRenderHelpHitbox(info, i)) continue;
                        BoundingBox itemBox = ((AbstractPlayerAttachmentInfo)info).getInputSlots()[i];
                        this.enqueueItemGuideRender(stack, itemBox, 0.2f, this.slotHelpBoxIsSelected(info, i), ((AbstractPlayerAttachmentInfo)info).light);
                    }
                }
            }
            catch (NullPointerException | ConcurrentModificationException runtimeException) {
                // empty catch block
            }
        }
    }

    private boolean nearbyItemGuideRenderCheck(I info) {
        HitResult hit = Minecraft.m_91087_().f_91077_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean inVR = VRPluginVerify.clientInVR();
        Vec3 vrHitStart = inVR ? VRPlugin.API.getVRPlayer((Player)player).getHMD().position() : null;
        Vec3 vrLook = inVR ? VRPlugin.API.getVRPlayer((Player)player).getHMD().getLookAngle() : null;
        Vec3 vrHitEnd = inVR ? vrHitStart.m_82549_(vrLook.m_82490_((double)Minecraft.m_91087_().f_91072_.m_105286_())) : null;
        BlockHitResult vrHit = inVR ? player.m_9236_().m_45547_(new ClipContext(vrHitStart, vrHitEnd, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)) : null;
        return hit != null && hit.m_6662_() == HitResult.Type.BLOCK && ((BlockHitResult)hit).m_82425_().equals((Object)((AbstractPlayerAttachmentInfo)info).getBlockPosition()) || this.playerPos().m_82554_(Vec3.m_82512_((Vec3i)((AbstractPlayerAttachmentInfo)info).getBlockPosition())) <= 4.0 || vrHit != null && vrHit.m_6662_() == HitResult.Type.BLOCK && vrHit.m_82425_().equals((Object)((AbstractPlayerAttachmentInfo)info).getBlockPosition());
    }

    public List<I> getTrackedObjects() {
        return this.infos;
    }

    public void noInfosTick() {
    }

    public void renderItem(ItemStack item, PoseStack stack, Vec3 pos, float size, Direction facing, BoundingBox hitbox, boolean renderItemCounts, int light) {
        this.renderItem(item, stack, pos, size, facing, null, hitbox, renderItemCounts, -1, light);
    }

    public void renderItem(ItemStack item, PoseStack stack, Vec3 pos, float size, Direction facing, Direction upDown, BoundingBox hitbox, boolean renderItemCounts, int spinDegrees, int light) {
        ImmersiveRenderHelpersImpl.INSTANCE.renderItem(item, stack, size, hitbox, renderItemCounts, light, spinDegrees < 0 ? null : Float.valueOf(spinDegrees), facing, upDown);
    }

    protected void enqueueItemGuideRender(PoseStack stack, BoundingBox hitbox, float alpha, boolean isSelected, int light) {
        ClientRenderSubscriber.itemGuideRenderData.add(new ClientRenderSubscriber.ItemGuideRenderData(stack, hitbox, alpha, isSelected, light));
    }

    protected void renderHitbox(PoseStack stack, BoundingBox hitbox) {
        this.renderHitbox(stack, hitbox, false);
    }

    protected void renderHitbox(PoseStack stack, BoundingBox hitbox, boolean alwaysRender) {
        AbstractPlayerAttachmentImmersive.renderHitbox(stack, hitbox, alwaysRender, 1.0f, 1.0f, 1.0f);
    }

    public static void renderHitbox(PoseStack stack, BoundingBox hitbox, boolean alwaysRender, float red, float green, float blue) {
        AbstractPlayerAttachmentImmersive.renderHitbox(stack, hitbox, alwaysRender, red, green, blue, 1.0f);
    }

    public static void renderHitbox(PoseStack stack, BoundingBox hitbox, boolean alwaysRender, float red, float green, float blue, float alpha) {
        ImmersiveRenderHelpersImpl.INSTANCE.renderHitbox(stack, hitbox, alwaysRender, red, green, blue, alpha);
    }

    public static Direction getLeftOfDirection(Direction forward) {
        if (forward == Direction.UP || forward == Direction.DOWN) {
            throw new IllegalArgumentException("Direction cannot be up or down!");
        }
        if (forward == Direction.NORTH) {
            return Direction.WEST;
        }
        if (forward == Direction.WEST) {
            return Direction.SOUTH;
        }
        if (forward == Direction.SOUTH) {
            return Direction.EAST;
        }
        return Direction.NORTH;
    }

    public static Vec3 getTopCenterOfBlock(BlockPos pos) {
        return Vec3.m_82514_((Vec3i)pos, (double)1.0);
    }

    public static Direction getForwardFromPlayer(Player player, BlockPos pos) {
        Direction.Axis axis;
        Vec3 blockPos = Vec3.m_82539_((Vec3i)pos);
        Vec3 playerPos = player.m_20182_();
        Vec3 diff = playerPos.m_82546_(blockPos);
        Direction.Axis axis2 = axis = Math.abs(diff.f_82479_) > Math.abs(diff.f_82481_) ? Direction.Axis.X : Direction.Axis.Z;
        if (axis == Direction.Axis.X) {
            return diff.f_82479_ < 0.0 ? Direction.WEST : Direction.EAST;
        }
        return diff.f_82481_ < 0.0 ? Direction.NORTH : Direction.SOUTH;
    }

    public static Vec3[] get3x3HorizontalGrid(BlockPos blockPos, double spacing, Direction blockForward, boolean use3DCompat) {
        Vec3 pos = AbstractPlayerAttachmentImmersive.getTopCenterOfBlock(blockPos);
        if (use3DCompat) {
            pos = pos.m_82520_(0.0, 0.0625, 0.0);
        }
        Direction left = AbstractPlayerAttachmentImmersive.getLeftOfDirection(blockForward);
        Vec3 leftOffset = new Vec3((double)left.m_122436_().m_123341_() * -spacing, 0.0, (double)left.m_122436_().m_123343_() * -spacing);
        Vec3 rightOffset = new Vec3((double)left.m_122436_().m_123341_() * spacing, 0.0, (double)left.m_122436_().m_123343_() * spacing);
        Vec3 topOffset = new Vec3((double)blockForward.m_122436_().m_123341_() * -spacing, 0.0, (double)blockForward.m_122436_().m_123343_() * -spacing);
        Vec3 botOffset = new Vec3((double)blockForward.m_122436_().m_123341_() * spacing, 0.0, (double)blockForward.m_122436_().m_123343_() * spacing);
        return new Vec3[]{pos.m_82549_(leftOffset).m_82549_(topOffset), pos.m_82549_(topOffset), pos.m_82549_(rightOffset).m_82549_(topOffset), pos.m_82549_(leftOffset), pos, pos.m_82549_(rightOffset), pos.m_82549_(leftOffset).m_82549_(botOffset), pos.m_82549_(botOffset), pos.m_82549_(rightOffset).m_82549_(botOffset)};
    }

    public int getLight(BlockPos pos) {
        return ImmersiveClientLogicHelpers.instance().getLight(pos);
    }

    public int getLight(BlockPos[] positions) {
        return ImmersiveClientLogicHelpers.instance().getLight(Arrays.stream(positions).toList());
    }

    public void clearImmersives() {
        this.infos.clear();
    }

    public static Direction getForwardFromPlayerUpAndDown(Player player, BlockPos pos) {
        return AbstractPlayerAttachmentImmersive.getForwardFromPlayerUpAndDownFilterBlockFacing(player, pos, false);
    }

    public static Direction getForwardFromPlayerUpAndDownFilterBlockFacing(Player player, BlockPos pos, boolean filterOnBlockFacing) {
        Direction.Axis filter = filterOnBlockFacing ? ((Direction)player.m_9236_().m_8055_(pos).m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_() : null;
        Vec3 playerPos = player.m_20182_();
        if (playerPos.f_82480_ >= (double)pos.m_123342_() + 0.625 && filter != Direction.Axis.Y) {
            return Direction.UP;
        }
        if (playerPos.f_82480_ <= (double)pos.m_123342_() - 0.625 && filter != Direction.Axis.Y) {
            return Direction.DOWN;
        }
        Direction forward = AbstractPlayerAttachmentImmersive.getForwardFromPlayer(player, pos);
        if (forward.m_122434_() != filter) {
            return forward;
        }
        Direction blockFacing = (Direction)player.m_9236_().m_8055_(pos).m_61143_((Property)DirectionalBlock.f_52588_);
        Vec3 blockCenter = Vec3.m_82512_((Vec3i)pos);
        Direction blockLeftDir = blockFacing.m_122428_();
        Vec3 blockLeftVec = new Vec3((double)blockLeftDir.m_122436_().m_123341_(), (double)blockLeftDir.m_122436_().m_123342_(), (double)blockLeftDir.m_122436_().m_123343_());
        Vec3 counterClockwisePos = blockCenter.m_82549_(blockLeftVec.m_82490_(0.5));
        Vec3 clockwisePos = blockCenter.m_82549_(blockLeftVec.m_82490_(-0.5));
        Vec3 upPos = blockCenter.m_82520_(0.0, 0.5, 0.0);
        Vec3 downPos = blockCenter.m_82520_(0.0, -0.5, 0.0);
        double counterClockwiseDist = counterClockwisePos.m_82557_(playerPos);
        double clockwiseDist = clockwisePos.m_82557_(playerPos);
        double upDist = upPos.m_82557_(playerPos);
        double downDist = downPos.m_82557_(playerPos);
        double min = Math.min(counterClockwiseDist, clockwiseDist);
        min = Math.min(min, upDist);
        if ((min = Math.min(min, downDist)) == counterClockwiseDist) {
            return forward.m_122428_();
        }
        if (min == clockwiseDist) {
            return forward.m_122427_();
        }
        if (min == upDist) {
            return Direction.UP;
        }
        return Direction.DOWN;
    }
}

