/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.config.screen;

import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.config.screen.ConfigScreen;
import com.hammy275.immersivemc.client.config.screen.ScreenUtils;
import com.hammy275.immersivemc.client.model.Cube1x1;
import com.hammy275.immersivemc.client.subscribe.ClientRenderSubscriber;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ItemGuideColorData;
import com.hammy275.immersivemc.common.config.ItemGuidePreset;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.util.RGBA;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemGuideCustomizeScreen
extends Screen {
    private static final String[] types = new String[]{"item_guide_custom", "item_guide_selected_custom", "ranged_grab_custom"};
    private static final char[] rgba = new char[]{'r', 'g', 'b', 'a'};
    private final Screen lastScreen;
    protected OptionsList list;
    protected static int BUTTON_WIDTH = 128;
    protected static int BUTTON_HEIGHT = 20;

    public ItemGuideCustomizeScreen(Screen lastScreen) {
        super((Component)Component.m_237115_((String)"screen.immersivemc.item_guide_customize_screen"));
        this.lastScreen = lastScreen;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ClientRenderSubscriber.setRenderColors();
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 8, 0xFFFFFF);
        this.renderPreview(graphics.m_280168_(), ClientRenderSubscriber.itemGuideColor(), 0.25f, false, ConfigScreen.getClientConfigIfAdjusting().itemGuideSize);
        this.renderPreview(graphics.m_280168_(), ClientRenderSubscriber.itemGuideSelectedColor(), 0.5f, false, ConfigScreen.getClientConfigIfAdjusting().itemGuideSelectedSize);
        this.renderPreview(graphics.m_280168_(), ClientRenderSubscriber.rangedGrabColor(), 0.75f, true, 1.0);
        if (ScreenUtils.mouseInBox(mouseX, mouseY, this.f_96543_ * 19 / 20 - 16, this.f_96544_ * 250 / 1000 - 16, this.f_96543_ * 19 / 20 + 16, this.f_96544_ * 250 / 1000 + 16)) {
            graphics.m_280245_(this.f_96547_, Tooltip.m_257868_((Minecraft)Minecraft.m_91087_(), (Component)Component.m_237115_((String)"config.immersivemc.item_guide.desc")), mouseX, mouseY);
        }
        if (ScreenUtils.mouseInBox(mouseX, mouseY, this.f_96543_ * 19 / 20 - 16, this.f_96544_ * 500 / 1000 - 16, this.f_96543_ * 19 / 20 + 16, this.f_96544_ * 500 / 1000 + 16)) {
            graphics.m_280245_(this.f_96547_, Tooltip.m_257868_((Minecraft)Minecraft.m_91087_(), (Component)Component.m_237115_((String)"config.immersivemc.item_guide_selected.desc")), mouseX, mouseY);
        }
        if (ScreenUtils.mouseInBox(mouseX, mouseY, this.f_96543_ * 19 / 20 - 16, this.f_96544_ * 750 / 1000 - 16, this.f_96543_ * 19 / 20 + 16, this.f_96544_ * 750 / 1000 + 16)) {
            graphics.m_280245_(this.f_96547_, Tooltip.m_257868_((Minecraft)Minecraft.m_91087_(), (Component)Component.m_237115_((String)"config.immersivemc.ranged_grab_color.desc")), mouseX, mouseY);
        }
    }

    private void renderPreview(PoseStack stack, RGBA color, float heightMult, boolean renderSquare, double size) {
        stack.m_85836_();
        stack.m_85837_((double)this.f_96543_ * 0.95, (double)((float)this.f_96544_ * heightMult - 16.0f), 0.0);
        stack.m_85841_(0.225f, 0.225f, 0.225f);
        if (!renderSquare) {
            long currentTimeMilli = Instant.now().toEpochMilli();
            long millisPerRot = 8000L;
            float rot = (float)(currentTimeMilli % millisPerRot) / (float)millisPerRot * ((float)Math.PI * 2);
            stack.m_252781_(Axis.f_252392_.m_252961_(rot));
        }
        if (renderSquare) {
            stack.m_252880_(0.0f, 64.0f * color.alphaF(), 0.0f);
            stack.m_85841_(color.alphaF(), color.alphaF(), color.alphaF());
        } else {
            stack.m_85837_(0.0, 64.0 * size, 0.0);
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        if (ConfigScreen.getClientConfigIfAdjusting().placementGuideMode == PlacementGuideMode.CUBE || renderSquare) {
            RGBA renderColor = renderSquare ? new RGBA(color.toLong() | 0xFF000000L) : color;
            ClientRenderSubscriber.cubeModel.render(stack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)Cube1x1.textureLocation)), renderColor.redF(), renderColor.greenF(), renderColor.blueF(), renderColor.alphaF(), 64.0f * (float)size, ClientUtil.maxLight);
        } else if (ConfigScreen.getClientConfigIfAdjusting().placementGuideMode == PlacementGuideMode.OUTLINE) {
            LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)AABB.m_165882_((Vec3)Vec3.f_82478_, (double)(128.0 * size), (double)(128.0 * size), (double)(128.0 * size)), (float)color.redF(), (float)color.greenF(), (float)color.blueF(), (float)color.alphaF());
        }
        buffer.m_109911_();
        stack.m_85849_();
    }

    protected void m_7856_() {
        this.list = new OptionsList(Minecraft.m_91087_(), this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 24);
        this.list.m_232528_(ScreenUtils.createEnumOption(PlacementGuideMode.class, "config.immersivemc.placement_guide_mode", guideMode -> Component.m_237115_((String)("config.immersivemc.placement_guide_mode." + guideMode.ordinal())), guideMode -> Component.m_237115_((String)"config.immersivemc.placement_guide_mode.desc"), () -> ConfigScreen.getClientConfigIfAdjusting().placementGuideMode, (newModeIndex, newMode) -> {
            ConfigScreen.getClientConfigIfAdjusting().placementGuideMode = newMode;
        }));
        this.list.m_232528_(ScreenUtils.createIntSlider("config.immersivemc.item_guide_size", value -> Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.item_guide_size", (Object[])new Object[0]) + ": " + String.format("%.02f", Float.valueOf((float)value.intValue() / 100.0f)))), 0, 100, () -> (int)(ConfigScreen.getClientConfigIfAdjusting().itemGuideSize * 100.0), newVal -> {
            ConfigScreen.getClientConfigIfAdjusting().itemGuideSize = (double)newVal.intValue() / 100.0;
        }));
        this.list.m_232528_(ScreenUtils.createIntSlider("config.immersivemc.item_guide_selected_size", value -> Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.item_guide_selected_size", (Object[])new Object[0]) + ": " + String.format("%.02f", Float.valueOf((float)value.intValue() / 100.0f)))), 0, 100, () -> (int)(ConfigScreen.getClientConfigIfAdjusting().itemGuideSelectedSize * 100.0), newVal -> {
            ConfigScreen.getClientConfigIfAdjusting().itemGuideSelectedSize = (double)newVal.intValue() / 100.0;
        }));
        if (ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset != ItemGuidePreset.CUSTOM) {
            this.list.m_232528_(ScreenUtils.createIntSlider("config.immersivemc.ranged_grab_a", value -> Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.ranged_grab_a", (Object[])new Object[0]) + ": " + value)), 0, 255, () -> ConfigScreen.getClientConfigIfAdjusting().colorPresetRangedGrabSize, newVal -> {
                ConfigScreen.getClientConfigIfAdjusting().colorPresetRangedGrabSize = newVal;
            }));
        }
        this.list.m_232528_(ScreenUtils.createEnumOption(ItemGuidePreset.class, "config.immersivemc.item_guide_preset", preset -> Component.m_237115_((String)("config.immersivemc.item_guide_preset." + preset.ordinal())), preset -> Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.item_guide_preset.desc", (Object[])new Object[0]) + "\n\n" + I18n.m_118938_((String)("config.immersivemc.item_guide_preset." + preset.ordinal() + ".desc"), (Object[])new Object[0]))), () -> ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset, (newPresetIndex, newPreset) -> {
            ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset = newPreset;
            Minecraft.m_91087_().m_91152_((Screen)new ItemGuideCustomizeScreen(this.lastScreen));
        }));
        if (ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset == ItemGuidePreset.PRIDE_FLAG) {
            this.list.m_232528_(ScreenUtils.createEnumOption(ItemGuidePreset.PrideFlag.class, "config.immersivemc.item_guide_preset.pride_flag_option", flag -> Component.m_237115_((String)("config.immersivemc.item_guide_preset.pride_flag_option." + flag.name().toLowerCase())), flag -> Component.m_237119_(), () -> ConfigScreen.getClientConfigIfAdjusting().itemGuidePrideFlag, (newFlagIndex, newFlag) -> {
                ConfigScreen.getClientConfigIfAdjusting().itemGuidePrideFlag = newFlag;
            }));
        }
        if (ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset.isCustomizablePreset()) {
            this.list.m_232528_(ScreenUtils.createIntSlider("config.immersivemc.item_guide_a", value -> Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.item_guide_a", (Object[])new Object[0]) + ": " + value)), 0, 255, () -> ConfigScreen.getClientConfigIfAdjusting().colorPresetAlpha, newVal -> {
                ConfigScreen.getClientConfigIfAdjusting().colorPresetAlpha = newVal;
            }));
            this.list.m_232528_(ScreenUtils.createIntSlider("config.immersivemc.item_guide_selected_a", value -> Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.item_guide_selected_a", (Object[])new Object[0]) + ": " + value)), 0, 255, () -> ConfigScreen.getClientConfigIfAdjusting().colorPresetSelectedAlpha, newVal -> {
                ConfigScreen.getClientConfigIfAdjusting().colorPresetSelectedAlpha = newVal;
            }));
        }
        if (ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset.showTransitionConfig()) {
            this.list.m_232528_(ScreenUtils.createIntSlider("config.immersivemc.item_guide_transition_time", value -> Component.m_237110_((String)"config.immersivemc.item_guide_transition_time_value", (Object[])new Object[]{String.format("%.02f", Float.valueOf((float)value.intValue() / 1000.0f))}), 500, 60000, () -> ConfigScreen.getClientConfigIfAdjusting().multiColorPresetTransitionTimeMS, newVal -> {
                ConfigScreen.getClientConfigIfAdjusting().multiColorPresetTransitionTimeMS = newVal;
                ConfigScreen.getClientConfigIfAdjusting().itemGuideCustomColorData = ConfigScreen.getClientConfigIfAdjusting().itemGuideCustomColorData.withChangedTransitionTime((int)newVal);
            }));
        }
        if (ConfigScreen.getClientConfigIfAdjusting().itemGuidePreset == ItemGuidePreset.CUSTOM) {
            ItemGuideColorData colorData = ActiveConfig.FILE_CLIENT.itemGuideCustomColorData;
            for (String key : types) {
                List<RGBA> colors = key.equals(types[0]) ? colorData.colors().get() : (key.equals(types[1]) ? colorData.selectedColors().get() : colorData.rangedGrabColors().get());
                this.list.m_232528_(ScreenUtils.createIntSlider("config.immersivemc.num_custom_colors." + key, value -> Component.m_237113_((String)(I18n.m_118938_((String)("config.immersivemc.num_custom_colors." + key), (Object[])new Object[0]) + ": " + value)), 1, 10, colors::size, newVal -> {
                    List<RGBA> newColors = new ArrayList<RGBA>(colors);
                    while (newVal > newColors.size()) {
                        newColors.add(RGBA.random());
                    }
                    if (newVal < newColors.size()) {
                        newColors = newColors.subList(0, (int)newVal);
                    }
                    ArrayList<RGBA> newColorsFinal = newColors;
                    ActiveConfig.FILE_CLIENT.itemGuideCustomColorData = key.equals(types[0]) ? new ItemGuideColorData(() -> newColorsFinal, colorData.selectedColors(), colorData.rangedGrabColors(), colorData.transitionTimeMS()) : (key.equals(types[1]) ? new ItemGuideColorData(colorData.colors(), () -> newColorsFinal, colorData.rangedGrabColors(), colorData.transitionTimeMS()) : new ItemGuideColorData(colorData.colors(), colorData.selectedColors(), () -> newColorsFinal, colorData.transitionTimeMS()));
                    ClientRenderSubscriber.resetCycleProgresses();
                    Minecraft.m_91087_().m_91152_((Screen)new ItemGuideCustomizeScreen(this.lastScreen));
                }));
                this.addColorOptions(colors, key);
            }
        }
        this.m_142416_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)ScreenUtils.createDoneButton((this.f_96543_ - BUTTON_WIDTH) / 2, this.f_96544_ - 26, BUTTON_WIDTH, BUTTON_HEIGHT, this));
    }

    private void addColorOptions(List<RGBA> colors, String key) {
        for (int i = 0; i < colors.size(); ++i) {
            RGBA color = colors.get(i);
            for (char c : rgba) {
                String compKey = "config.immersivemc." + key + "." + c;
                int readableColorNum = i + 1;
                this.list.m_232528_(ScreenUtils.createIntSlider(compKey, value -> Component.m_237110_((String)compKey, (Object[])new Object[]{String.valueOf(readableColorNum), String.valueOf(value)}), 0, 255, () -> color.getColor(c), newVal -> color.setColor(c, (int)newVal)));
            }
        }
    }

    public void m_7379_() {
        ConfigScreen.writeAdjustingConfig();
        Minecraft.m_91087_().m_91152_(this.lastScreen);
    }
}

