/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.config.screen;

import com.hammy275.immersivemc.client.config.screen.ConfigScreen;
import com.hammy275.immersivemc.client.config.screen.ScreenUtils;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ConfigType;
import com.hammy275.immersivemc.common.config.CrouchMode;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class ImmersivesCustomizeScreen
extends Screen {
    protected final Screen lastScreen;
    protected OptionsList list;
    protected static int BUTTON_WIDTH = 256;
    protected static int BUTTON_HEIGHT = 20;

    public ImmersivesCustomizeScreen(Screen lastScreen) {
        super((Component)Component.m_237115_((String)"screen.immersivemc.immersives_customize.title"));
        this.lastScreen = lastScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.list = new OptionsList(Minecraft.m_91087_(), this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 24);
        ScreenUtils.addOption("disable_vanilla_guis", config -> config.disableVanillaInteractionsForSupportedImmersives, (config, newVal) -> {
            config.disableVanillaInteractionsForSupportedImmersives = newVal;
        }, this.list);
        ScreenUtils.addOptionIfClient("return_items", config -> config.returnItemsWhenLeavingImmersives, (config, newVal) -> {
            config.returnItemsWhenLeavingImmersives = newVal;
        }, this.list);
        ScreenUtils.addOptionIfClient("do_rumble", config -> config.doVRControllerRumble, (config, newVal) -> {
            config.doVRControllerRumble = newVal;
        }, this.list);
        ScreenUtils.addOptionIfClient("center_brewing", config -> config.autoCenterBrewingStandImmersive, (config, newVal) -> {
            config.autoCenterBrewingStandImmersive = newVal;
        }, this.list);
        ScreenUtils.addOptionIfClient("center_furnace", config -> config.autoCenterFurnaceImmersive, (config, newVal) -> {
            config.autoCenterFurnaceImmersive = newVal;
        }, this.list);
        ScreenUtils.addOptionIfClient("right_click_chest", config -> config.rightClickChestInteractions, (config, newVal) -> {
            config.rightClickChestInteractions = newVal;
        }, this.list);
        ScreenUtils.addOptionIfClient("spin_crafting_output", config -> config.spinSomeImmersiveOutputs, (config, newVal) -> {
            config.spinSomeImmersiveOutputs = newVal;
        }, this.list);
        ScreenUtils.addOption("pet_any_living", config -> config.allowPettingAnythingLiving, (config, newVal) -> {
            config.allowPettingAnythingLiving = newVal;
            if (ConfigScreen.getAdjustingConfigType() == ConfigType.CLIENT && newVal.booleanValue()) {
                ActiveConfig server = ActiveConfig.getFileConfig(ConfigType.SERVER);
                server.allowPettingAnythingLiving = true;
                server.writeConfigFile(ConfigType.SERVER);
            }
        }, this.list);
        if (VRPluginVerify.clientInVR()) {
            ScreenUtils.addOptionIfClient("right_click_in_vr", config -> config.rightClickImmersiveInteractionsInVR, (config, newVal) -> {
                config.rightClickImmersiveInteractionsInVR = newVal;
            }, this.list);
            ScreenUtils.addOptionIfClient("dont_step_up_immersives_in_vr", config -> config.dontAutoStepOnImmersiveBlocksInVR, (config, newVal) -> {
                config.dontAutoStepOnImmersiveBlocksInVR = newVal;
            }, this.list);
        }
        ScreenUtils.addOptionIfClient("3d_compat", config -> config.compatFor3dResourcePacks, (config, newVal) -> {
            config.compatFor3dResourcePacks = newVal;
        }, this.list);
        if (ConfigScreen.getAdjustingConfigType() == ConfigType.CLIENT) {
            this.list.m_232528_(ScreenUtils.createEnumOption(CrouchMode.class, "config.immersivemc.crouch_mode", mode -> Component.m_237115_((String)("config.immersivemc.crouch_mode." + mode.ordinal())), mode -> Component.m_237115_((String)("config.immersivemc.crouch_mode." + mode.ordinal() + ".desc")), () -> ConfigScreen.getClientConfigIfAdjusting().crouchMode, (newModeIndex, newMode) -> {
                ConfigScreen.getClientConfigIfAdjusting().crouchMode = newMode;
            }));
            this.list.m_232528_(ScreenUtils.createIntSlider("config.immersivemc.ranged_grab_range", val -> {
                if (val == -1) {
                    return Component.m_237115_((String)"config.immersivemc.use_pick_range");
                }
                return Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.ranged_grab_range", (Object[])new Object[0]) + ": " + val));
            }, -1, 12, () -> ConfigScreen.getClientConfigIfAdjusting().rangedGrabRange, newVal -> {
                ConfigScreen.getClientConfigIfAdjusting().rangedGrabRange = newVal;
            }));
            this.list.m_232528_(ScreenUtils.createIntSlider("config.immersivemc.text_scale", val -> Component.m_237110_((String)"config.immersivemc.text_scale_val", (Object[])new Object[]{String.format("%.2f", Float.valueOf((float)val.intValue() / 20.0f))}), 10, 40, () -> (int)(ConfigScreen.getClientConfigIfAdjusting().textScale * 20.0f), newVal -> {
                ConfigScreen.getClientConfigIfAdjusting().textScale = (float)newVal.intValue() / 20.0f;
            }));
        }
        if (VRPluginVerify.clientInVR()) {
            ScreenUtils.addOptionIfClient("grab_beacon", config -> config.useGrabBeaconInVR, (config, newVal) -> {
                config.useGrabBeaconInVR = newVal;
            }, this.list);
            ScreenUtils.addOptionIfClient("grind_grindstone", config -> config.useGrindMotionGrindstoneInVR, (config, newVal) -> {
                config.useGrindMotionGrindstoneInVR = newVal;
            }, this.list);
        }
        this.m_142416_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)ScreenUtils.createDoneButton((this.f_96543_ - BUTTON_WIDTH) / 2, this.f_96544_ - 26, BUTTON_WIDTH, BUTTON_HEIGHT, this));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 8, 0xFFFFFF);
    }

    public void m_7379_() {
        ConfigScreen.writeAdjustingConfig();
        Minecraft.m_91087_().m_91152_(this.lastScreen);
    }
}

