/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.config.screen;

import com.hammy275.immersivemc.client.config.screen.ConfigScreen;
import com.hammy275.immersivemc.client.config.screen.ScreenUtils;
import com.hammy275.immersivemc.client.immersive.ImmersiveBackpack;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.BackpackMode;
import com.hammy275.immersivemc.common.config.ClientActiveConfig;
import com.hammy275.immersivemc.common.config.ReachBehindBackpackMode;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.time.Instant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class BackpackConfigScreen
extends Screen {
    protected final Screen parentScreen;
    protected OptionsList list;
    protected static int BUTTON_WIDTH = 128;
    protected static int BUTTON_HEIGHT = 20;

    public BackpackConfigScreen(Screen lastScreen) {
        super((Component)Component.m_237115_((String)"screen.immersivemc.backpack_config.title"));
        this.parentScreen = lastScreen;
    }

    protected void m_7856_() {
        this.list = new OptionsList(Minecraft.m_91087_(), this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 24);
        this.initOptionsList();
        this.m_142416_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)ScreenUtils.createDoneButton((this.f_96543_ - BUTTON_WIDTH) / 2, this.f_96544_ - 26, BUTTON_WIDTH, BUTTON_HEIGHT, this));
    }

    protected void initOptionsList() {
        this.list.m_232528_(ScreenUtils.createEnumOption(BackpackMode.class, "config.immersivemc.backpack_mode", backpackMode -> Component.m_237115_((String)("config.immersivemc.backpack_mode." + backpackMode.ordinal())), backpackMode -> Component.m_237115_((String)("config.immersivemc.backpack_mode." + backpackMode.ordinal() + ".desc")), () -> ConfigScreen.getClientConfigIfAdjusting().bagMode, (newModeIndex, newMode) -> {
            BackpackMode oldMode = ConfigScreen.getClientConfigIfAdjusting().bagMode;
            ConfigScreen.getClientConfigIfAdjusting().bagMode = newMode;
            ActiveConfig.activeRaw().bagMode = newMode;
            if (oldMode.colorable != newMode.colorable) {
                Minecraft.m_91087_().m_91152_((Screen)new BackpackConfigScreen(this.parentScreen));
            }
        }));
        this.list.m_232528_(ScreenUtils.createEnumOption(ReachBehindBackpackMode.class, "config.immersivemc.reach_behind_backpack_mode", reachBehindBackpackMode -> Component.m_237115_((String)("config.immersivemc.reach_behind_backpack_mode." + reachBehindBackpackMode.ordinal())), reachBehindBackpackMode -> Component.m_237115_((String)("config.immersivemc.reach_behind_backpack_mode." + reachBehindBackpackMode.ordinal() + ".desc")), () -> ConfigScreen.getClientConfigIfAdjusting().reachBehindBagMode, (newModeIndex, newMode) -> {
            ConfigScreen.getClientConfigIfAdjusting().reachBehindBagMode = newMode;
        }));
        this.list.m_232528_(ScreenUtils.createOption("swap_bag_hand", config -> ((ClientActiveConfig)config).swapBagHand, (config, val) -> {
            ((ClientActiveConfig)config).swapBagHand = val;
        }));
        if (ConfigScreen.getClientConfigIfAdjusting().bagMode.colorable) {
            this.list.m_232528_(ScreenUtils.createIntSlider("config.immersivemc.backpack_r", integer -> Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.backpack_r", (Object[])new Object[0]) + ": " + this.getRGB('r'))), 0, 255, () -> this.getRGB('r'), newRVal -> this.setRGB((Integer)newRVal, 'r')));
            this.list.m_232528_(ScreenUtils.createIntSlider("config.immersivemc.backpack_g", integer -> Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.backpack_g", (Object[])new Object[0]) + ": " + this.getRGB('g'))), 0, 255, () -> this.getRGB('g'), newRVal -> this.setRGB((Integer)newRVal, 'g')));
            this.list.m_232528_(ScreenUtils.createIntSlider("config.immersivemc.backpack_b", integer -> Component.m_237113_((String)(I18n.m_118938_((String)"config.immersivemc.backpack_b", (Object[])new Object[0]) + ": " + this.getRGB('b'))), 0, 255, () -> this.getRGB('b'), newRVal -> this.setRGB((Integer)newRVal, 'b')));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 8, 0xFFFFFF);
        this.renderBackpack(graphics.m_280168_());
    }

    protected void renderBackpack(PoseStack stack) {
        stack.m_85836_();
        Vector3f rgb = ImmersiveBackpack.getBackpackColor();
        float size = 72.0f;
        stack.m_85837_((double)this.f_96543_ * 0.9325, (double)((float)this.f_96544_ / 2.0f), 548.0);
        stack.m_85841_(0.5f, 0.5f, 0.5f);
        long currentTimeMilli = Instant.now().toEpochMilli();
        long millisPerRot = 8000L;
        float rot = (float)(currentTimeMilli % millisPerRot) / (float)millisPerRot * ((float)Math.PI * 2);
        stack.m_252781_(Axis.f_252495_.m_252977_(205.0f));
        stack.m_252781_(Axis.f_252392_.m_252961_(rot));
        stack.m_85837_(0.0, (double)size * 1.75, 0.0);
        stack.m_85841_(size, -size, size);
        ImmersiveBackpack.getBackpackModel().m_7695_(stack, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110452_((ResourceLocation)ImmersiveBackpack.getBackpackTexture())), 0xF000F0, OverlayTexture.f_118083_, rgb.x(), rgb.y(), rgb.z(), 1.0f);
        Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
        stack.m_85849_();
    }

    public void m_7379_() {
        ConfigScreen.writeAdjustingConfig();
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }

    protected int getRGB(char type) {
        if (type == 'r') {
            return ConfigScreen.getClientConfigIfAdjusting().bagColor >> 16;
        }
        if (type == 'g') {
            return ConfigScreen.getClientConfigIfAdjusting().bagColor >> 8 & 0xFF;
        }
        return ConfigScreen.getClientConfigIfAdjusting().bagColor & 0xFF;
    }

    protected void setRGB(Integer newVal, char type) {
        int newColor;
        Vec3i rgb = new Vec3i(this.getRGB('r'), this.getRGB('g'), this.getRGB('b'));
        rgb = type == 'r' ? new Vec3i(newVal.intValue(), rgb.m_123342_(), rgb.m_123343_()) : (type == 'g' ? new Vec3i(rgb.m_123341_(), newVal.intValue(), rgb.m_123343_()) : new Vec3i(rgb.m_123341_(), rgb.m_123342_(), newVal.intValue()));
        ConfigScreen.getClientConfigIfAdjusting().bagColor = newColor = (rgb.m_123341_() << 16) + (rgb.m_123342_() << 8) + rgb.m_123343_();
        ActiveConfig.activeRaw().bagColor = newColor;
    }
}

