/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.item;

import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.dawnoftime.armoroftheages.client.ArmorModelProvider;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;
import org.dawnoftime.armoroftheages.item.HumanoidArmorItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeHumanoidArmorItem
extends HumanoidArmorItem {
    public ForgeHumanoidArmorItem(@NotNull String armorSetName, ArmorMaterial material, ArmorItem.Type type) {
        super(armorSetName, material, type);
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> defaultModel) {
                ArmorModelProvider provider = ForgeHumanoidArmorItem.this.getModelProvider();
                if (provider != null) {
                    ArmorModel<?> model = provider.getArmorModel((Entity)living);
                    model.f_102817_ = living.m_6144_();
                    model.f_102609_ = defaultModel.f_102609_;
                    return model;
                }
                return defaultModel;
            }
        });
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ArmorModelProvider provider = this.getModelProvider();
        return provider != null ? provider.getTexture(entity).toString() : null;
    }
}

