/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client.models.quetzalcoatl_armor;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;

public class ChestQuetzalcoatlArmorModel<T extends LivingEntity>
extends ArmorModel<T> {
    private final ModelPart tail;
    private final ModelPart tailTip;
    private final ModelPart armFeather;
    private final ModelPart neckStart;
    private final ModelPart neckEnd;
    private final ModelPart snakeHead;
    private final ModelPart jow;
    private final ModelPart snakeCrownRight;
    private final ModelPart snakeCrownLeft;

    public ChestQuetzalcoatlArmorModel(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.tail = this.f_102810_.m_171324_("tail");
        this.tailTip = this.tail.m_171324_("tailTip");
        this.armFeather = this.f_102812_.m_171324_("armFeather");
        this.neckStart = this.f_102810_.m_171324_("neckStart");
        this.neckEnd = this.neckStart.m_171324_("neckEnd");
        this.snakeHead = this.neckEnd.m_171324_("snakeHead");
        this.jow = this.snakeHead.m_171324_("jow");
        this.snakeCrownRight = this.snakeHead.m_171324_("snakeCrownRight");
        this.snakeCrownLeft = this.snakeHead.m_171324_("snakeCrownLeft");
    }

    @Override
    public <E extends LivingEntity> ArmorModel<E> create(ModelPart root, boolean isSlim) {
        return new ChestQuetzalcoatlArmorModel<T>(root, isSlim);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = ChestQuetzalcoatlArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-4.0f, -0.5f, -2.5f, 8.0f, 4.0f, 5.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("snakeA", CubeListBuilder.m_171558_().m_171514_(50, 19).m_171488_(-6.0f, 0.0f, -3.0f, 3.0f, 3.0f, 5.0f, CubeDeformation.f_171458_).m_171514_(76, 0).m_171488_(-6.0f, 0.0f, 2.0f, 12.0f, 3.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.67f, (float)0.2454f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        body.m_171599_("snakeB", CubeListBuilder.m_171558_().m_171514_(85, 11).m_171488_(3.5f, 2.5f, -3.25f, 3.0f, 3.0f, 7.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)2.6523f, (float)-0.9639f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.4363f));
        body.m_171599_("snakeC", CubeListBuilder.m_171558_().m_171514_(98, 10).m_171488_(3.5f, -2.5f, -3.0f, 3.0f, 5.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)2.6523f, (float)-0.9639f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        body.m_171599_("snakeD", CubeListBuilder.m_171558_().m_171514_(114, 18).m_171488_(3.25f, -5.5f, -3.5f, 3.0f, 4.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)3.0428f, (float)1.4415f, (float)-2.6225f, (float)-1.0308f, (float)-0.0415f, (float)0.1632f));
        PartDefinition neckStart = body.m_171599_("neckStart", CubeListBuilder.m_171558_().m_171514_(102, 18).m_171488_(-1.3977f, -6.9113f, -2.4979f, 3.0f, 7.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)8.0f, (float)-1.25f, (float)1.5f, (float)-0.6929f, (float)0.0315f, (float)0.1992f));
        PartDefinition neckEnd = neckStart.m_171599_("neckEnd", CubeListBuilder.m_171558_().m_171514_(110, 10).m_171488_(-1.5f, -5.0f, -2.25f, 3.0f, 5.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.0551f, (float)-6.6055f, (float)-0.1796f, (float)0.9904f, (float)0.0148f, (float)-0.0067f));
        neckEnd.m_171599_("featherA", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171488_(-0.2694f, -0.4602f, -2.4251f, 4.0f, 4.0f, 6.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.1511f, (float)-1.337f, (float)1.1273f, (float)-1.078f, (float)0.7476f, (float)0.3405f));
        neckEnd.m_171599_("featherB", CubeListBuilder.m_171558_().m_171514_(68, 6).m_171488_(0.5858f, 0.3358f, 0.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-0.25f)), PartPose.m_171423_((float)-0.1511f, (float)-6.337f, (float)1.1273f, (float)-0.5992f, (float)0.4909f, (float)0.6321f));
        PartDefinition snakeHead = neckEnd.m_171599_("snakeHead", CubeListBuilder.m_171558_().m_171514_(61, 19).m_171480_().m_171488_(-1.9512f, -1.3244f, -7.3903f, 4.0f, 1.0f, 4.0f, CubeDeformation.f_171458_).m_171514_(86, 6).m_171488_(-1.4512f, -0.5744f, -6.8903f, 3.0f, 1.0f, 4.0f, CubeDeformation.f_171458_).m_171514_(52, 5).m_171488_(-1.9512f, -3.3244f, -3.3903f, 4.0f, 4.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.1999f, (float)-5.0126f, (float)-0.4824f, (float)0.1176f, (float)0.0076f, (float)-0.0741f));
        snakeHead.m_171599_("snakeCrownLeft", CubeListBuilder.m_171558_().m_171514_(26, 7).m_171488_(-7.0f, 0.0f, 0.0f, 7.0f, 12.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0488f, (float)-8.0026f, (float)2.1767f, (float)-2.5831f, (float)0.3378f, (float)-2.9374f));
        snakeHead.m_171599_("snakeCrownRight", CubeListBuilder.m_171558_().m_171514_(26, 7).m_171488_(-7.0f, 0.0f, 0.0f, 7.0f, 12.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0488f, (float)-8.0026f, (float)2.1767f, (float)-0.5585f, (float)0.3378f, (float)-0.2042f));
        snakeHead.m_171599_("featherC", CubeListBuilder.m_171558_().m_171514_(68, 6).m_171488_(-0.1642f, -0.1642f, -2.0f, 6.0f, 6.0f, 6.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0488f, (float)-1.3244f, (float)1.6097f, (float)-0.5992f, (float)0.4909f, (float)0.6321f));
        snakeHead.m_171599_("featherD", CubeListBuilder.m_171558_().m_171514_(68, 6).m_171488_(0.25f, 0.25f, -2.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)0.0488f, (float)-3.3244f, (float)1.6097f, (float)0.0f, (float)0.0f, (float)0.7854f));
        snakeHead.m_171599_("featherE", CubeListBuilder.m_171558_().m_171514_(68, 6).m_171488_(-0.2324f, -0.25f, -0.3181f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-0.25f)), PartPose.m_171423_((float)0.0488f, (float)-3.3244f, (float)-0.3903f, (float)0.4711f, (float)-0.3981f, (float)0.6996f));
        snakeHead.m_171599_("headA", CubeListBuilder.m_171558_().m_171514_(120, 6).m_171488_(-4.9f, -1.0f, -1.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)3.4488f, (float)-1.28f, (float)-6.2866f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        snakeHead.m_171599_("headB", CubeListBuilder.m_171558_().m_171514_(114, 0).m_171488_(-3.5f, 0.0f, -4.0f, 3.0f, 2.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)2.0488f, (float)-3.3244f, (float)-3.3903f, (float)0.3491f, (float)0.0f, (float)0.0f));
        snakeHead.m_171599_("headC", CubeListBuilder.m_171558_().m_171514_(68, 8).m_171488_(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-2.4204f, (float)-3.6286f, (float)-3.8423f, (float)0.2236f, (float)0.1398f, (float)0.224f));
        snakeHead.m_171599_("headD", CubeListBuilder.m_171558_().m_171514_(68, 5).m_171488_(-1.75f, -1.35f, -0.5f, 1.0f, 1.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.4512f, (float)-1.8244f, (float)-3.8903f, (float)0.2589f, (float)-0.5398f, (float)0.0571f));
        snakeHead.m_171599_("headE", CubeListBuilder.m_171558_().m_171514_(119, 8).m_171488_(-0.45f, -1.75f, -1.8f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.m_171423_((float)-1.9512f, (float)-1.3244f, (float)-3.3903f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        snakeHead.m_171599_("headF", CubeListBuilder.m_171558_().m_171514_(68, 8).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)2.5179f, (float)-3.6286f, (float)-3.8423f, (float)0.2236f, (float)-0.1398f, (float)-0.224f));
        snakeHead.m_171599_("headG", CubeListBuilder.m_171558_().m_171514_(68, 5).m_171480_().m_171488_(0.75f, -1.35f, -0.5f, 1.0f, 1.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.5488f, (float)-1.8244f, (float)-3.8903f, (float)0.2589f, (float)0.5398f, (float)-0.0571f));
        snakeHead.m_171599_("headH", CubeListBuilder.m_171558_().m_171514_(119, 8).m_171480_().m_171488_(-1.55f, -1.75f, -1.8f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.m_171423_((float)2.0488f, (float)-1.3244f, (float)-3.3903f, (float)0.0f, (float)0.2618f, (float)0.0f));
        snakeHead.m_171599_("jow", CubeListBuilder.m_171558_().m_171514_(73, 18).m_171480_().m_171488_(-3.4471f, 0.7487f, -5.805f, 4.0f, 1.0f, 4.0f, CubeDeformation.f_171458_).m_171514_(86, 6).m_171488_(-2.9471f, -0.0013f, -5.305f, 3.0f, 1.0f, 4.0f, CubeDeformation.f_171458_).m_171514_(52, 13).m_171488_(-3.9471f, -1.2513f, -1.805f, 5.0f, 3.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)1.4959f, (float)0.4269f, (float)-1.5853f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(87, 21).m_171488_(0.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-6.9225f, (float)0.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition tailTip = tail.m_171599_("tailTip", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)6.0f, (float)0.5f));
        tailTip.m_171599_("tailTipFeather", CubeListBuilder.m_171558_().m_171514_(20, 33).m_171488_(1.0f, 0.0f, -1.0f, 0.0f, 9.0f, 3.0f, CubeDeformation.f_171458_).m_171514_(96, 21).m_171488_(-0.5f, 0.0f, 0.5f, 3.0f, 9.0f, 0.0f, CubeDeformation.f_171458_).m_171514_(122, 12).m_171488_(0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 1.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        body.m_171599_("necklaceJewel", CubeListBuilder.m_171558_().m_171514_(21, 20).m_171488_(-1.5f, -1.5f, -0.5f, 3.0f, 3.0f, 1.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition rightArm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(30, 19).m_171488_(-3.5f, 0.5f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        rightArm.m_171599_("shoulderRightProtection", CubeListBuilder.m_171558_().m_171514_(20, 24).m_171488_(-0.5f, -5.25f, -0.4f, 2.0f, 6.0f, 6.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-3.6f, (float)0.4f, (float)-2.6f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftArm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171555_(true).m_171488_(-1.5f, 5.5f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        leftArm.m_171599_("leftArmJewel", CubeListBuilder.m_171558_().m_171514_(29, 20).m_171488_(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)3.5f, (float)7.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        leftArm.m_171599_("armFeather", CubeListBuilder.m_171558_().m_171514_(36, 19).m_171488_(0.15f, -5.0f, -3.5f, 0.0f, 10.0f, 7.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)3.75f, (float)5.5f, (float)1.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public static LayerDefinition createSlimLayerDefinition() {
        MeshDefinition meshdefinition = ChestQuetzalcoatlArmorModel.templateLayerDefinition(1.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-4.0f, -0.5f, -2.5f, 8.0f, 4.0f, 5.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("snakeA", CubeListBuilder.m_171558_().m_171514_(50, 19).m_171488_(-6.0f, 0.0f, -3.0f, 3.0f, 3.0f, 5.0f, CubeDeformation.f_171458_).m_171514_(76, 0).m_171488_(-6.0f, 0.0f, 2.0f, 12.0f, 3.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.67f, (float)0.2454f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        body.m_171599_("snakeB", CubeListBuilder.m_171558_().m_171514_(85, 11).m_171488_(3.5f, 2.5f, -3.25f, 3.0f, 3.0f, 7.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)2.6523f, (float)-0.9639f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.4363f));
        body.m_171599_("snakeC", CubeListBuilder.m_171558_().m_171514_(98, 10).m_171488_(3.5f, -2.5f, -3.0f, 3.0f, 5.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)2.6523f, (float)-0.9639f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        body.m_171599_("snakeD", CubeListBuilder.m_171558_().m_171514_(114, 18).m_171488_(3.25f, -5.5f, -3.5f, 3.0f, 4.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)3.0428f, (float)1.4415f, (float)-2.6225f, (float)-1.0308f, (float)-0.0415f, (float)0.1632f));
        PartDefinition neckStart = body.m_171599_("neckStart", CubeListBuilder.m_171558_().m_171514_(102, 18).m_171488_(-1.3977f, -6.9113f, -2.4979f, 3.0f, 7.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)8.0f, (float)-1.25f, (float)1.5f, (float)-0.6929f, (float)0.0315f, (float)0.1992f));
        PartDefinition neckEnd = neckStart.m_171599_("neckEnd", CubeListBuilder.m_171558_().m_171514_(110, 10).m_171488_(-1.5f, -5.0f, -2.25f, 3.0f, 5.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.0551f, (float)-6.6055f, (float)-0.1796f, (float)0.9904f, (float)0.0148f, (float)-0.0067f));
        neckEnd.m_171599_("featherA", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171488_(-0.2694f, -0.4602f, -2.4251f, 4.0f, 4.0f, 6.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.1511f, (float)-1.337f, (float)1.1273f, (float)-1.078f, (float)0.7476f, (float)0.3405f));
        neckEnd.m_171599_("featherB", CubeListBuilder.m_171558_().m_171514_(68, 6).m_171488_(0.5858f, 0.3358f, 0.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-0.25f)), PartPose.m_171423_((float)-0.1511f, (float)-6.337f, (float)1.1273f, (float)-0.5992f, (float)0.4909f, (float)0.6321f));
        PartDefinition snakeHead = neckEnd.m_171599_("snakeHead", CubeListBuilder.m_171558_().m_171514_(61, 19).m_171480_().m_171488_(-1.9512f, -1.3244f, -7.3903f, 4.0f, 1.0f, 4.0f, CubeDeformation.f_171458_).m_171514_(86, 6).m_171488_(-1.4512f, -0.5744f, -6.8903f, 3.0f, 1.0f, 4.0f, CubeDeformation.f_171458_).m_171514_(52, 5).m_171488_(-1.9512f, -3.3244f, -3.3903f, 4.0f, 4.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.1999f, (float)-5.0126f, (float)-0.4824f, (float)0.1176f, (float)0.0076f, (float)-0.0741f));
        snakeHead.m_171599_("snakeCrownLeft", CubeListBuilder.m_171558_().m_171514_(26, 7).m_171488_(-7.0f, 0.0f, 0.0f, 7.0f, 12.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0488f, (float)-8.0026f, (float)2.1767f, (float)-2.5831f, (float)0.3378f, (float)-2.9374f));
        snakeHead.m_171599_("snakeCrownRight", CubeListBuilder.m_171558_().m_171514_(26, 7).m_171488_(-7.0f, 0.0f, 0.0f, 7.0f, 12.0f, 0.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0488f, (float)-8.0026f, (float)2.1767f, (float)-0.5585f, (float)0.3378f, (float)-0.2042f));
        snakeHead.m_171599_("featherC", CubeListBuilder.m_171558_().m_171514_(68, 6).m_171488_(-0.1642f, -0.1642f, -2.0f, 6.0f, 6.0f, 6.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0488f, (float)-1.3244f, (float)1.6097f, (float)-0.5992f, (float)0.4909f, (float)0.6321f));
        snakeHead.m_171599_("featherD", CubeListBuilder.m_171558_().m_171514_(68, 6).m_171488_(0.25f, 0.25f, -2.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)0.0488f, (float)-3.3244f, (float)1.6097f, (float)0.0f, (float)0.0f, (float)0.7854f));
        snakeHead.m_171599_("featherE", CubeListBuilder.m_171558_().m_171514_(68, 6).m_171488_(-0.2324f, -0.25f, -0.3181f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-0.25f)), PartPose.m_171423_((float)0.0488f, (float)-3.3244f, (float)-0.3903f, (float)0.4711f, (float)-0.3981f, (float)0.6996f));
        snakeHead.m_171599_("headA", CubeListBuilder.m_171558_().m_171514_(120, 6).m_171488_(-4.9f, -1.0f, -1.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)3.4488f, (float)-1.28f, (float)-6.2866f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        snakeHead.m_171599_("headB", CubeListBuilder.m_171558_().m_171514_(114, 0).m_171488_(-3.5f, 0.0f, -4.0f, 3.0f, 2.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)2.0488f, (float)-3.3244f, (float)-3.3903f, (float)0.3491f, (float)0.0f, (float)0.0f));
        snakeHead.m_171599_("headC", CubeListBuilder.m_171558_().m_171514_(68, 8).m_171488_(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-2.4204f, (float)-3.6286f, (float)-3.8423f, (float)0.2236f, (float)0.1398f, (float)0.224f));
        snakeHead.m_171599_("headD", CubeListBuilder.m_171558_().m_171514_(68, 5).m_171488_(-1.75f, -1.35f, -0.5f, 1.0f, 1.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.4512f, (float)-1.8244f, (float)-3.8903f, (float)0.2589f, (float)-0.5398f, (float)0.0571f));
        snakeHead.m_171599_("headE", CubeListBuilder.m_171558_().m_171514_(119, 8).m_171488_(-0.45f, -1.75f, -1.8f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.m_171423_((float)-1.9512f, (float)-1.3244f, (float)-3.3903f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        snakeHead.m_171599_("headF", CubeListBuilder.m_171558_().m_171514_(68, 8).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)2.5179f, (float)-3.6286f, (float)-3.8423f, (float)0.2236f, (float)-0.1398f, (float)-0.224f));
        snakeHead.m_171599_("headG", CubeListBuilder.m_171558_().m_171514_(68, 5).m_171480_().m_171488_(0.75f, -1.35f, -0.5f, 1.0f, 1.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.5488f, (float)-1.8244f, (float)-3.8903f, (float)0.2589f, (float)0.5398f, (float)-0.0571f));
        snakeHead.m_171599_("headH", CubeListBuilder.m_171558_().m_171514_(119, 8).m_171480_().m_171488_(-1.55f, -1.75f, -1.8f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.m_171423_((float)2.0488f, (float)-1.3244f, (float)-3.3903f, (float)0.0f, (float)0.2618f, (float)0.0f));
        snakeHead.m_171599_("jow", CubeListBuilder.m_171558_().m_171514_(73, 18).m_171480_().m_171488_(-3.4471f, 0.7487f, -5.805f, 4.0f, 1.0f, 4.0f, CubeDeformation.f_171458_).m_171514_(86, 6).m_171488_(-2.9471f, -0.0013f, -5.305f, 3.0f, 1.0f, 4.0f, CubeDeformation.f_171458_).m_171514_(52, 13).m_171488_(-3.9471f, -1.2513f, -1.805f, 5.0f, 3.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)1.4959f, (float)0.4269f, (float)-1.5853f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(87, 21).m_171488_(0.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-6.9225f, (float)0.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition tailTip = tail.m_171599_("tailTip", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)6.0f, (float)0.5f));
        tailTip.m_171599_("tailTipFeather", CubeListBuilder.m_171558_().m_171514_(20, 33).m_171488_(1.0f, 0.0f, -1.0f, 0.0f, 9.0f, 3.0f, CubeDeformation.f_171458_).m_171514_(96, 21).m_171488_(-0.5f, 0.0f, 0.5f, 3.0f, 9.0f, 0.0f, CubeDeformation.f_171458_).m_171514_(122, 12).m_171488_(0.5f, 0.0f, 0.0f, 1.0f, 5.0f, 1.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        body.m_171599_("chestBreast", CubeListBuilder.m_171558_().m_171514_(26, 40).m_171488_(-3.5f, -1.75f, 0.0f, 7.0f, 4.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-3.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        body.m_171599_("necklaceJewel", CubeListBuilder.m_171558_().m_171514_(21, 20).m_171488_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 1.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-2.5f, (float)-0.3527f, (float)0.3326f, (float)0.7256f));
        PartDefinition rightArm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(30, 19).m_171488_(-2.5f, 0.5f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        rightArm.m_171599_("shoulderRightProtection", CubeListBuilder.m_171558_().m_171514_(20, 24).m_171488_(0.5f, -5.25f, -0.4f, 2.0f, 6.0f, 6.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)-3.6f, (float)0.4f, (float)-2.6f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftArm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171555_(true).m_171488_(-1.5f, 5.5f, -2.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        leftArm.m_171599_("leftArmJewel", CubeListBuilder.m_171558_().m_171514_(29, 20).m_171488_(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)2.5f, (float)7.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        leftArm.m_171599_("armFeather", CubeListBuilder.m_171558_().m_171514_(36, 19).m_171488_(0.15f, -5.0f, -3.5f, 0.0f, 10.0f, 7.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)2.75f, (float)5.5f, (float)1.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    @Override
    protected void setupArmorPartAnim(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float rA = ChestQuetzalcoatlArmorModel.sinPI(ageInTicks / 40.0f);
        float rB = ChestQuetzalcoatlArmorModel.sinPI((ageInTicks - 15.0f) / 40.0f);
        this.tail.f_104203_ = this.f_102811_.f_104203_ < 0.0f ? this.f_102811_.f_104203_ : this.f_102811_.f_104203_ * 0.1f;
        this.tail.f_104205_ = 0.2182f + 0.1f * rA;
        this.tailTip.f_104205_ = 0.1f * rB;
        this.armFeather.f_104205_ = -0.05f * rB;
        this.armFeather.f_104203_ = 0.1f * rB;
        this.neckStart.f_104203_ = -0.3f + 0.2f * rA;
        this.neckStart.f_104205_ = 0.2f + 0.04f * rB;
        this.neckEnd.f_104203_ = 0.6f + 0.1f * rB;
        this.snakeHead.f_104203_ = -0.2f * rB + 0.02f * headPitch;
        this.snakeHead.f_104204_ = 0.02f * netHeadYaw;
        this.jow.f_104203_ = 0.13f + 0.1f * rA;
        this.snakeCrownRight.f_104204_ = 0.3378f + 0.1f * rB;
        this.snakeCrownLeft.f_104204_ = 0.3378f - 0.1f * rB;
    }
}

