/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.spawnbalanceutility.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Summary {
    private static final Logger LOGGER = LogManager.getLogger();
    private static int biomeTotal;
    private static int biomeSkip;
    private static int biomeUsed;
    private static int biomeAdd;
    private static int biomeChange;
    private static int biomeDelete;
    private static int structureTotal;
    private static int structureSkip;
    private static int structureUsed;
    private static int massAddTotal;
    private static int massAddSkip;
    private static int massAddUsed;
    private static int massAddBiomes;
    private static int bFixCount;
    private static int sFixCount;
    private static int netherCount;

    public static void clear() {
        biomeUsed = -1;
        massAddUsed = -1;
        massAddBiomes = 0;
        bFixCount = 0;
        netherCount = 0;
        biomeAdd = 0;
        biomeChange = 0;
        biomeDelete = 0;
    }

    public static void clearStructure() {
        structureUsed = -1;
        sFixCount = 0;
    }

    public static void setBiomeReadInfo(int total, int skip) {
        biomeTotal = total;
        biomeSkip = skip;
    }

    public static void setBiomeUsed(int used) {
        biomeUsed = used;
    }

    public static void biomeUpdate(Map<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>> oldMap, Map<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>> newMap) {
        HashSet<MobCategory> set = new HashSet<MobCategory>(oldMap.keySet());
        set.addAll(newMap.keySet());
        for (MobCategory k : set) {
            BiomeSpawns data;
            WeightedRandomList<MobSpawnSettings.SpawnerData> oldWList = oldMap.get(k);
            WeightedRandomList<MobSpawnSettings.SpawnerData> newWList = newMap.get(k);
            List oldList = oldWList != null ? oldWList.m_146338_() : new ArrayList();
            List newList = newWList != null ? newWList.m_146338_() : new ArrayList();
            HashMap<EntityType, BiomeSpawns> dataMap = new HashMap<EntityType, BiomeSpawns>();
            Function<EntityType, BiomeSpawns> def = t -> new BiomeSpawns();
            for (MobSpawnSettings.SpawnerData e : oldList) {
                data = dataMap.computeIfAbsent(e.f_48404_, def);
                data.oldList.add(e);
            }
            for (MobSpawnSettings.SpawnerData e : newList) {
                data = dataMap.computeIfAbsent(e.f_48404_, def);
                data.newList.add(e);
            }
            for (BiomeSpawns data2 : dataMap.values()) {
                List<MobSpawnSettings.SpawnerData> list2;
                List<MobSpawnSettings.SpawnerData> list1;
                List<MobSpawnSettings.SpawnerData> oldTList = data2.oldList;
                List<MobSpawnSettings.SpawnerData> newTList = data2.newList;
                int delta = newTList.size() - oldTList.size();
                if (delta > 0) {
                    biomeAdd += delta;
                } else if (delta < 0) {
                    biomeDelete -= delta;
                }
                if (newTList.size() <= 0 || oldTList.size() <= 0) continue;
                if (delta < 0) {
                    list1 = newTList;
                    list2 = oldTList;
                } else {
                    list1 = oldTList;
                    list2 = newTList;
                }
                for (MobSpawnSettings.SpawnerData e : list1) {
                    boolean found = false;
                    Iterator<MobSpawnSettings.SpawnerData> it = list2.iterator();
                    while (it.hasNext()) {
                        MobSpawnSettings.SpawnerData e2 = it.next();
                        if (e2.m_142631_().m_146281_() != e.m_142631_().m_146281_() || e2.f_48405_ != e.f_48405_ || e2.f_48406_ != e.f_48406_) continue;
                        it.remove();
                        found = true;
                        break;
                    }
                    if (found) continue;
                    ++biomeChange;
                }
            }
        }
    }

    public static void setStructureReadInfo(int total, int skip) {
        structureTotal = total;
        structureSkip = skip;
    }

    public static void setStructureUsed(int used) {
        if (structureUsed < 0) {
            structureUsed = 0;
        }
        structureUsed += used;
    }

    public static void setMassAddReadInfo(int total, int skip) {
        massAddTotal = total;
        massAddSkip = skip;
    }

    public static void setMassAddUsed(int used, int biomes) {
        massAddUsed = used;
        massAddBiomes = biomes;
    }

    public static void setBiomeFix(int count, int netherUsed) {
        bFixCount = count;
        netherCount = netherUsed;
    }

    public static void setStructureFix(int count) {
        sFixCount += count;
    }

    public static void report() {
        LOGGER.info("SBU SUMMARY");
        Object extra = "";
        if (biomeSkip > 0) {
            extra = (String)extra + ", " + biomeSkip + " lines skipped";
        }
        if (biomeTotal - biomeSkip > 0 && biomeUsed >= 0) {
            extra = (String)extra + ", " + biomeUsed + " lines used";
            extra = (String)extra + " (" + biomeAdd + "/" + biomeChange + "/" + biomeDelete + ")";
        }
        LOGGER.info("Biome csv: " + biomeTotal + " lines read" + (String)extra);
        extra = "";
        if (structureSkip > 0) {
            extra = (String)extra + ", " + structureSkip + " lines skipped";
        }
        if (structureTotal - structureSkip > 0 && structureUsed >= 0) {
            extra = (String)extra + ", " + structureUsed + " lines used";
        }
        LOGGER.info("Structure csv: " + structureTotal + " lines read" + (String)extra);
        extra = "";
        if (massAddSkip > 0) {
            extra = (String)extra + ", " + massAddSkip + " lines skipped";
        }
        if (massAddTotal - massAddSkip > 0 && massAddUsed >= 0) {
            extra = (String)extra + ", " + massAddUsed + " lines used (" + massAddBiomes + " biomes)";
        }
        LOGGER.info("Mass add csv: " + massAddTotal + " lines read" + (String)extra);
        LOGGER.info("Biome fix: " + bFixCount + " weight changed, " + netherCount + " add to nether");
        LOGGER.info("Structure fix: " + sFixCount + " weight changed");
    }

    static class BiomeSpawns {
        public List<MobSpawnSettings.SpawnerData> oldList = new ArrayList<MobSpawnSettings.SpawnerData>();
        public List<MobSpawnSettings.SpawnerData> newList = new ArrayList<MobSpawnSettings.SpawnerData>();
    }
}

